/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogPrivilege;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWDatabasePackageImpl;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ModelPackage;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2PackageStatement;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Schema;
import org.eclipse.datatools.enablement.ibm.util.ModelHelper;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogDatabasePackage
extends LUWDatabasePackageImpl
implements ICatalogObject,
IDatabaseObject {
    private boolean privilegeLoaded = false;
    private boolean statementLoaded = false;
    private Collection impacts = new ArrayList();
    private Collection statistics = new ArrayList();
    private boolean impactsLoaded = false;

    public void refresh() {
        this.privilegeLoaded = false;
        this.statementLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        return new ArrayList();
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public EList getStatements() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getStatements();
        }
        if (!this.statementLoaded) {
            this.loadStatements();
        }
        return this.statements;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getPrivileges();
        } else if (id == 18) {
            this.getStatements();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            EList privileges = super.getPrivileges();
            for (Privilege privilege : privileges) {
                privilege.setGrantor(null);
                privilege.setGrantee(null);
            }
            privileges.clear();
            LUWCatalogDatabasePackage.loadPrivileges(this.getConnection(), privileges, this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadStatements() {
        if (this.statementLoaded) {
            return;
        }
        this.statementLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogDatabasePackage.loadStatements(this.getConnection(), super.getStatements(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static void loadPrivileges(Connection connection, EList privilegeList, DB2Package pkg, String granteeFilter) throws SQLException {
        DB2Schema schema = pkg.getSchema();
        Database database = ModelHelper.getDatabase((Schema)schema);
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        databaseDefinition.getDataModelElementFactory();
        int options = ((LUWCatalogDatabase)database).getLoadOptions();
        if ((options & 0x800) == 2048) {
            return;
        }
        Statement s = connection.createStatement();
        String query = "SELECT GRANTOR,GRANTEE,GRANTEETYPE,CONTROLAUTH,BINDAUTH,EXECUTEAUTH FROM SYSCAT.PACKAGEAUTH WHERE GRANTOR <> GRANTEE  AND PKGSCHEMA='" + LUWUtil.getIdentifier(pkg.getSchema().getName()) + "'" + " AND PKGNAME='" + LUWUtil.getIdentifier(pkg.getName()) + "'";
        if (granteeFilter != null && !"".equals(granteeFilter)) {
            query = String.valueOf(query) + " AND " + granteeFilter;
        }
        ResultSet r = s.executeQuery(query);
        String userName = connection.getMetaData().getUserName();
        while (r.next()) {
            String executeAuth;
            String bindAuth;
            String grantorId = r.getString("GRANTOR").trim();
            AuthorizationIdentifier grantor = LUWCatalogDatabase.getAuthorizationId(database, grantorId, null);
            String granteeId = r.getString("GRANTEE").trim();
            AuthorizationIdentifier grantee = null;
            String granteeType = r.getString("GRANTEETYPE");
            grantee = "G".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "G") : ("R".equals(granteeType) ? LUWCatalogDatabase.getAuthorizationId(database, granteeId, "R") : LUWCatalogDatabase.getAuthorizationId(database, granteeId, "U"));
            LUWCatalogPrivilege privilege = null;
            boolean isSystemGranted = granteeId.equalsIgnoreCase(userName);
            String controlAuth = r.getString("CONTROLAUTH");
            if (controlAuth.equals("Y")) {
                privilege = new LUWCatalogPrivilege();
                privilege.setAction("CONTROL");
                privilegeList.add((Object)privilege);
                privilege.setGrantor(grantor);
                privilege.setGrantee(grantee);
                LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
            }
            if (!(bindAuth = r.getString("BINDAUTH")).equals("N")) {
                privilege = new LUWCatalogPrivilege();
                privilege.setAction("BIND");
                if (bindAuth.equals("G")) {
                    privilege.setGrantable(true);
                }
                privilegeList.add((Object)privilege);
                privilege.setGrantor(grantor);
                privilege.setGrantee(grantee);
                LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
            }
            if ((executeAuth = r.getString("EXECUTEAUTH")).equals("N")) continue;
            privilege = new LUWCatalogPrivilege();
            privilege.setAction("EXECUTE");
            if (executeAuth.equals("G")) {
                privilege.setGrantable(true);
            }
            privilegeList.add((Object)privilege);
            privilege.setGrantor(grantor);
            privilege.setGrantee(grantee);
            LUWCatalogPrivilege.setAsSystemGranted((Privilege)privilege, isSystemGranted);
        }
        r.close();
        s.close();
    }

    public static void loadStatements(Connection connection, EList statements, DB2Package pkg) throws SQLException {
        DB2Schema schema = pkg.getSchema();
        Database database = ModelHelper.getDatabase((Schema)schema);
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        Statement s = connection.createStatement();
        String query = "SELECT STMTNO, SECTNO, TEXT FROM SYSCAT.STATEMENTS WHERE PKGSCHEMA='" + LUWUtil.getIdentifier(pkg.getSchema().getName()) + "'" + " AND PKGNAME='" + LUWUtil.getIdentifier(pkg.getName()) + "'" + (pkg.getVersion().length() > 0 ? " AND VERSION='" + LUWUtil.getIdentifier(pkg.getVersion()) + "'" : " AND VERSION = ''") + " ORDER BY STMTNO" + " FOR FETCH ONLY WITH UR";
        ResultSet r = s.executeQuery(query);
        while (r.next()) {
            DB2PackageStatement pkgstmt = (DB2PackageStatement)factory.create(DB2ModelPackage.eINSTANCE.getDB2PackageStatement());
            int pkgStmtNo = r.getInt("STMTNO");
            pkgstmt.setStatementNumber(pkgStmtNo);
            int pkgSectNo = r.getInt("SECTNO");
            pkgstmt.setSectionNumber(pkgSectNo);
            String pkgText = r.getString("TEXT").trim();
            SQLStatement sqlstate = (SQLStatement)factory.create(SQLStatementsPackage.eINSTANCE.getSQLStatementDefault());
            ((SQLStatementDefault)sqlstate).setSQL(pkgText);
            pkgstmt.setSqlStatement(sqlstate);
            statements.add((Object)pkgstmt);
        }
        r.close();
        s.close();
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogDatabasePackage.loadPrivileges(this.getConnection(), privileges, this, granteeFilter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogDatabasePackage.getImpactedRoutines(connection, this));
        impacts.addAll(LUWCatalogDatabasePackage.getImpactedTriggers(connection, this));
        return impacts;
    }

    protected static Collection getImpactedRoutines(Connection connection, DB2Package db2package) {
        ArrayList<Routine> impacts = new ArrayList<Routine>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT ROUTINENAME, ROUTINESCHEMA FROM SYSCAT.ROUTINEDEP WHERE BTYPE = 'K' AND BNAME='" + LUWUtil.getIdentifier(db2package.getName()) + "'" + " AND BSCHEMA='" + LUWUtil.getIdentifier(db2package.getSchema().getName()) + "'" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String routineName = r.getString("ROUTINENAME").trim();
                String schemaName = r.getString("ROUTINESCHEMA").trim();
                Routine routine = LUWCatalogDatabasePackage.getRountine(db2package, schemaName, routineName);
                if (routine == null) continue;
                impacts.add(routine);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }

    protected static Collection getImpactedTriggers(Connection connection, DB2Package db2package) {
        ArrayList<Trigger> impacts = new ArrayList<Trigger>();
        try {
            Statement s = connection.createStatement();
            String query = "SELECT DISTINCT A.TABSCHEMA, A.TABNAME, A.TRIGNAME FROM SYSCAT.TRIGGERS A, SYSCAT.TRIGDEP B WHERE (B.BNAME='" + LUWUtil.getIdentifier(db2package.getName()) + "'" + " AND B.BSCHEMA='" + LUWUtil.getIdentifier(db2package.getSchema().getName()) + "'" + " AND BTYPE ='K'" + " AND A.TRIGNAME=B.TRIGNAME" + " AND A.TRIGSCHEMA=B.TRIGSCHEMA)" + " FOR FETCH ONLY";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String trigName = r.getString("TRIGNAME").trim();
                String tabName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Trigger trigger = LUWCatalogDatabasePackage.getTrigger(db2package, schemaName, tabName, trigName);
                if (trigger == null) continue;
                impacts.add(trigger);
            }
            r.close();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return impacts;
    }

    public static Schema getSchema(DB2Package pkg, String schemaName) {
        DB2Schema s2 = pkg.getSchema();
        if (s2.getName().equals(schemaName)) {
            return s2;
        }
        Database db = s2.getDatabase();
        if (db instanceof LUWCatalogDatabase && (s2 = ((LUWCatalogDatabase)db).getSchema(schemaName)) != null) {
            return s2;
        }
        for (DB2Schema s2 : db.getSchemas()) {
            if (!s2.getName().equals(schemaName)) continue;
            return s2;
        }
        LUWCatalogSchema schema = new LUWCatalogSchema();
        schema.setName(schemaName);
        schema.setDatabase(db);
        if (db instanceof LUWCatalogDatabase) {
            ((LUWCatalogDatabase)db).cacheSchema((Schema)schema);
        }
        return schema;
    }

    public static Table getTable(DB2Package pkg, String schemaName, String tableName) {
        Table t;
        Schema schema = LUWCatalogDatabasePackage.getSchema(pkg, schemaName);
        if (schema instanceof LUWCatalogSchema && (t = ((LUWCatalogSchema)schema).getTable(schemaName, tableName)) != null) {
            return t;
        }
        for (Table table : schema.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public static Routine getRountine(DB2Package pkg, String schemaName, String specificName) {
        Schema schema = LUWCatalogDatabasePackage.getSchema(pkg, schemaName);
        for (Routine r : schema.getRoutines()) {
            if (!specificName.equals(r.getSpecificName())) continue;
            return r;
        }
        return null;
    }

    public static Trigger getTrigger(DB2Package pkg, String schemaName, String tabName, String triggerName) {
        Table table = LUWCatalogDatabasePackage.getTable(pkg, schemaName, tabName);
        if (table != null) {
            for (Trigger r : table.getTriggers()) {
                if (!r.getName().equals(triggerName)) continue;
                return r;
            }
        }
        return null;
    }
}

