/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.AttributeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.ReferenceDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.StructuredUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCUDTAttributeLoader
extends JDBCBaseLoader {
    public static final String COLUMN_ATTR_NAME = "ATTR_NAME";
    public static final String COLUMN_DATA_TYPE = "DATA_TYPE";
    public static final String COLUMN_ATTR_TYPE_NAME = "ATTR_TYPE_NAME";
    public static final String COLUMN_ATTR_SIZE = "ATTR_SIZE";
    public static final String COLUMN_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    public static final String COLUMN_NULLABLE = "NULLABLE";
    public static final String COLUMN_REMARKS = "REMARKS";
    public static final String COLUMN_ATTR_DEF = "ATTR_DEF";
    public static final String COLUMN_SCOPE_CATALOG = "SCOPE_CATALOG";
    public static final String COLUMN_SCOPE_SCHEMA = "SCOPE_SCHEMA";
    public static final String COLUMN_SCOPE_TABLE = "SCOPE_TABLE";
    private Pattern mUDTNameMatcherPattern;
    private boolean mCatalogAtStart;

    public JDBCUDTAttributeLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCUDTAttributeLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (catalogObject != null) assert (catalogObject instanceof UserDefinedType);
    }

    public List loadAttributeDefinitions() throws SQLException {
        ArrayList<AttributeDefinition> retVal = new ArrayList<AttributeDefinition>();
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createResultSet();
            while (rs.next()) {
                AttributeDefinition attrDef = this.processRow(rs);
                if (attrDef == null) continue;
                retVal.add(attrDef);
            }
            ArrayList<AttributeDefinition> arrayList = retVal;
            return arrayList;
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearAttributeDefinitions(List attrDefs) {
        attrDefs.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            UserDefinedType udt = this.getUserDefinedType();
            Schema schema = udt.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getAttributes(schema.getCatalog().getName(), schema.getName(), udt.getName(), "%");
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getAttributes()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected AttributeDefinition processRow(ResultSet rs) throws SQLException {
        String attrDefName = rs.getString(COLUMN_ATTR_NAME);
        if (attrDefName == null || this.isFiltered(attrDefName)) {
            return null;
        }
        AttributeDefinition attrDef = this.createAttributeDefinition();
        this.initialize(attrDef, rs);
        return attrDef;
    }

    protected AttributeDefinition createAttributeDefinition() {
        return SQLDataTypesFactory.eINSTANCE.createAttributeDefinition();
    }

    protected void initialize(AttributeDefinition attrDef, ResultSet rs) throws SQLException {
        attrDef.setName(rs.getString(COLUMN_ATTR_NAME));
        attrDef.setDescription(rs.getString(COLUMN_REMARKS));
        attrDef.setDefaultValue(rs.getString(COLUMN_ATTR_DEF));
        this.initAttributeDefinitionType(attrDef, rs);
    }

    protected void initAttributeDefinitionType(AttributeDefinition attrDef, ResultSet rs) throws SQLException {
        String typeName = rs.getString(COLUMN_ATTR_TYPE_NAME).toUpperCase();
        int typeCode = rs.getInt(COLUMN_DATA_TYPE);
        List pdtds = this.getDatabaseDefinition().getPredefinedDataTypeDefinitionsByJDBCEnumType(typeCode);
        if (pdtds.size() > 0) {
            PredefinedDataTypeDefinition pdtd = null;
            Iterator it = pdtds.iterator();
            block0: while (pdtd == null && it.hasNext()) {
                PredefinedDataTypeDefinition curPDTD = (PredefinedDataTypeDefinition)it.next();
                for (String name : curPDTD.getName()) {
                    if (!typeName.equals(name)) continue;
                    pdtd = curPDTD;
                    continue block0;
                }
            }
            if (pdtd == null) {
                pdtd = this.getDatabaseDefinition().getPredefinedDataTypeDefinition(typeName);
            }
            if (pdtd != null || pdtd == null && typeCode != 1111 && typeCode != 2006) {
                EStructuralFeature feature;
                if (pdtd == null) {
                    pdtd = (PredefinedDataTypeDefinition)pdtds.get(0);
                }
                PredefinedDataType pdt = this.getDatabaseDefinition().getPredefinedDataType(pdtd);
                if (pdtd.isLengthSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("length");
                    pdt.eSet(feature, (Object)new Integer(rs.getInt(COLUMN_ATTR_SIZE)));
                }
                if (pdtd.isPrecisionSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("precision");
                    pdt.eSet(feature, (Object)new Integer(rs.getInt(COLUMN_ATTR_SIZE)));
                }
                if (pdtd.isScaleSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("scale");
                    pdt.eSet(feature, (Object)new Integer(rs.getInt(COLUMN_DECIMAL_DIGITS)));
                }
                attrDef.setDataType((DataType)pdt);
                return;
            }
        }
        if (typeName == null) {
            return;
        }
        if (2006 == typeCode) {
            ReferenceDataType ref = this.createReferenceDataType();
            if (ref == null) {
                return;
            }
            UserDefinedType udt = this.findUserDefinedType(typeName);
            Table table = this.findScopedTable(rs.getString(COLUMN_SCOPE_CATALOG), rs.getString(COLUMN_SCOPE_SCHEMA), rs.getString(COLUMN_SCOPE_TABLE));
            this.initReferenceDataType(ref, udt, table);
            attrDef.setDataType((DataType)ref);
        } else {
            UserDefinedType udt = this.findUserDefinedType(typeName);
            attrDef.setDataType((DataType)udt);
        }
    }

    protected ReferenceDataType createReferenceDataType() {
        return null;
    }

    protected void initReferenceDataType(ReferenceDataType ref, UserDefinedType udt, Table scopeTable) {
        if (udt instanceof StructuredUserDefinedType) {
            ref.setReferencedType((StructuredUserDefinedType)udt);
        }
        ref.setScopeTable(scopeTable);
    }

    protected UserDefinedType getUserDefinedType() {
        return (UserDefinedType)this.getCatalogObject();
    }

    protected DatabaseDefinition getDatabaseDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogObject().getCatalogDatabase());
    }

    protected Matcher getUDTNameMatcher(String name) throws SQLException {
        if (this.mUDTNameMatcherPattern == null) {
            DatabaseMetaData dbmd = this.getCatalogObject().getConnection().getMetaData();
            String namePattern = "([a-zA-Z0-9_" + dbmd.getExtraNameCharacters() + "]*)";
            String catalogSeparator = dbmd.getCatalogSeparator();
            String regex = String.valueOf(namePattern) + "." + namePattern;
            if (name.indexOf(catalogSeparator) < 0) {
                regex = String.valueOf(regex) + "()";
            } else if (dbmd.isCatalogAtStart()) {
                this.mCatalogAtStart = true;
                regex = String.valueOf(namePattern) + catalogSeparator + regex;
            } else {
                regex = String.valueOf(regex) + catalogSeparator + namePattern;
            }
            this.mUDTNameMatcherPattern = Pattern.compile(regex);
        }
        return this.mUDTNameMatcherPattern.matcher(name);
    }

    protected UserDefinedType findUserDefinedType(String typeName) {
        Matcher matcher;
        try {
            matcher = this.getUDTNameMatcher(typeName);
        }
        catch (SQLException sQLException) {
            return null;
        }
        if (matcher.matches()) {
            String udtName;
            String schemaName;
            String catalogName;
            if (this.mCatalogAtStart) {
                catalogName = matcher.group(1);
                schemaName = matcher.group(2);
                udtName = matcher.group(3);
            } else {
                schemaName = matcher.group(1);
                udtName = matcher.group(2);
                catalogName = matcher.group(3);
            }
            if (udtName == null) {
                return null;
            }
            if (catalogName == null) {
                catalogName = new String();
            }
            if (schemaName == null) {
                schemaName = new String();
            }
            Database db = this.getCatalogObject().getCatalogDatabase();
            for (Catalog catalog : db.getCatalogs()) {
                if (!catalogName.equals(catalog.getName())) continue;
                for (Schema schema : catalog.getSchemas()) {
                    if (!schemaName.equals(schema.getName())) continue;
                    for (UserDefinedType udt : schema.getUserDefinedTypes()) {
                        if (!udtName.equals(udt.getName())) continue;
                        return udt;
                    }
                }
            }
        }
        return null;
    }

    protected Table findScopedTable(String catalogScope, String schemaScope, String tableScope) {
        if (tableScope == null) {
            return null;
        }
        if (catalogScope == null) {
            catalogScope = new String();
        }
        if (schemaScope == null) {
            schemaScope = new String();
        }
        Database db = this.getCatalogObject().getCatalogDatabase();
        for (Catalog catalog : db.getCatalogs()) {
            if (!catalogScope.equals(catalog.getName())) continue;
            for (Schema schema : catalog.getSchemas()) {
                if (!schemaScope.equals(schema.getName())) continue;
                for (Table table : schema.getTables()) {
                    if (!tableScope.equals(table.getName())) continue;
                    return table;
                }
            }
        }
        return null;
    }
}

