/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.internal.LoggingUtils;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesUpdateStatus;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICacheEntry;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ICachingVMProviderExtension2;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IElementUpdateTester;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IElementUpdateTesterExtension;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IVMUpdatePolicyExtension;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ManualUpdatePolicy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;

public class AbstractCachingVMProvider
extends AbstractVMProvider
implements ICachingVMProvider,
IElementPropertiesProvider,
ICachingVMProviderExtension2 {
    private static final String PROP_UPDATE_STATUS = "org.eclipse.cdt.dsf.ui.viewmodel.update.update_status";
    private static final int LENGTH_PROP_IS_CHANGED_PREFIX = "is_changed.".length();
    private boolean fDelayEventHandleForViewUpdate = false;
    static boolean DEBUG_CACHE = false;
    private static final int MAX_CACHE_SIZE = 1000;
    protected static String SELECTED_UPDATE_MODE;
    protected static String SELECTED_UPDATE_SCOPE;
    private IVMUpdatePolicy[] fAvailableUpdatePolicies;
    public Map<Object, RootElementMarkerKey> fRootMarkers = new HashMap<Object, RootElementMarkerKey>();
    private final Map<Object, Entry> fCacheData = Collections.synchronizedMap(new HashMap(200, 0.75f));
    private final Entry fCacheListHead;

    static {
        DEBUG_CACHE = DsfUIPlugin.DEBUG && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf.ui/debug/vm/cache"));
        SELECTED_UPDATE_MODE = "org.eclipse.cdt.dsf.ui.viewmodel.update.selectedUpdateMode";
        SELECTED_UPDATE_SCOPE = "org.eclipse.cdt.dsf.ui.viewmodel.update.selectedUpdateScope";
    }

    public AbstractCachingVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext) {
        super(adapter, presentationContext);
        this.fCacheListHead.fNext = this.fCacheListHead = new Entry(null){

            public String toString() {
                return "HEAD";
            }
        };
        this.fCacheListHead.fPrevious = this.fCacheListHead;
        this.fAvailableUpdatePolicies = this.createUpdateModes();
    }

    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new AutomaticUpdatePolicy()};
    }

    @Override
    public IVMUpdatePolicy[] getAvailableUpdatePolicies() {
        return this.fAvailableUpdatePolicies;
    }

    @Override
    public IVMUpdatePolicy getActiveUpdatePolicy() {
        String updateModeId = (String)this.getPresentationContext().getProperty(SELECTED_UPDATE_MODE);
        if (updateModeId != null) {
            IVMUpdatePolicy[] iVMUpdatePolicyArray = this.getAvailableUpdatePolicies();
            int n = iVMUpdatePolicyArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMUpdatePolicy updateMode = iVMUpdatePolicyArray[n2];
                if (updateMode.getID().equals(updateModeId)) {
                    return updateMode;
                }
                ++n2;
            }
        }
        return this.getAvailableUpdatePolicies()[0];
    }

    @Override
    public void setActiveUpdatePolicy(IVMUpdatePolicy updatePolicy) {
        this.getPresentationContext().setProperty(SELECTED_UPDATE_MODE, (Object)updatePolicy.getID());
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            if (proxyStrategy.isDisposed()) continue;
            proxyStrategy.fireModelChanged((IModelDelta)new ModelDelta(proxyStrategy.getRootElement(), 1024));
        }
    }

    @Override
    public void refresh() {
        IElementUpdateTester elementTester = this.getActiveUpdatePolicy().getElementUpdateTester(ManualUpdatePolicy.REFRESH_EVENT);
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            this.flush(new FlushMarkerKey(proxyStrategy.getRootElement(), elementTester));
        }
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            if (proxyStrategy.isDisposed()) continue;
            proxyStrategy.fireModelChanged((IModelDelta)new ModelDelta(proxyStrategy.getRootElement(), 1024));
        }
    }

    @Override
    public ICacheEntry getCacheEntry(IVMNode node, Object viewerInput, TreePath path) {
        ElementDataKey key = this.makeEntryKey(node, viewerInput, path);
        return this.getElementDataEntry(key, false);
    }

    @Override
    public void updateNode(final IVMNode node, IHasChildrenUpdate[] updates) {
        LinkedList<VMHasChildrenUpdate> missUpdates = new LinkedList<VMHasChildrenUpdate>();
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
            final ElementDataEntry entry = this.getElementDataEntry(key, true);
            this.updateRootElementMarker(key.fRootElement, node, (IViewerUpdate)update);
            if (entry.fHasChildren != null) {
                if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                    DsfUIPlugin.debug("cacheHitHasChildren(node = " + node + ", update = " + update + ", " + entry.fHasChildren + ")");
                }
                update.setHasChilren(entry.fHasChildren.booleanValue());
                update.done();
            } else {
                final int flushCounter = entry.fFlushCounter;
                missUpdates.add(new VMHasChildrenUpdate((IViewerUpdate)update, (DataRequestMonitor<Boolean>)new ViewerDataRequestMonitor<Boolean>(this.getExecutor(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            if (flushCounter == entry.fFlushCounter) {
                                if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                                    DsfUIPlugin.debug("cacheSavedHasChildren(node = " + node + ", update = " + update + ", " + this.getData() + ")");
                                }
                                entry.fHasChildren = (Boolean)this.getData();
                            }
                            update.setHasChilren(((Boolean)this.getData()).booleanValue());
                        } else {
                            update.setStatus(this.getStatus());
                        }
                        update.done();
                    }
                }));
            }
            ++n2;
        }
        if (!missUpdates.isEmpty()) {
            super.updateNode(node, missUpdates.toArray(new IHasChildrenUpdate[missUpdates.size()]));
        }
    }

    @Override
    public void updateNode(final IVMNode node, final IChildrenCountUpdate update) {
        ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
        final ElementDataEntry entry = this.getElementDataEntry(key, true);
        this.updateRootElementMarker(key.fRootElement, node, (IViewerUpdate)update);
        if (entry.fChildrenCount != null) {
            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("cacheHitChildrenCount(node = " + node + ", update = " + update + ", " + entry.fChildrenCount + ")");
            }
            update.setChildCount(entry.fChildrenCount.intValue());
            update.done();
        } else {
            final int flushCounter = entry.fFlushCounter;
            VMChildrenCountUpdate updateProxy = new VMChildrenCountUpdate((IViewerUpdate)update, (DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        if (flushCounter == entry.fFlushCounter) {
                            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                                DsfUIPlugin.debug("cacheSavedChildrenCount(node = " + node + ", update = " + update + ", " + this.getData() + ")");
                            }
                            entry.fChildrenCount = (Integer)this.getData();
                        }
                        update.setChildCount(((Integer)this.getData()).intValue());
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    update.done();
                }
            });
            super.updateNode(node, updateProxy);
        }
    }

    @Override
    public void updateNode(final IVMNode node, final IChildrenUpdate update) {
        ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
        final ElementDataEntry entry = this.getElementDataEntry(key, true);
        this.updateRootElementMarker(key.fRootElement, node, (IViewerUpdate)update);
        final int flushCounter = entry.fFlushCounter;
        if (entry.fChildren == null || update.getOffset() < 0 && !entry.fAllChildrenKnown) {
            VMChildrenUpdate updateProxy = new VMChildrenUpdate((IViewerUpdate)update, update.getOffset(), update.getLength(), (DataRequestMonitor<List<Object>>)new ViewerDataRequestMonitor<List<Object>>(this.getExecutor(), (IViewerUpdate)update){

                @Override
                protected void handleSuccess() {
                    int updateOffset = update.getOffset();
                    if (updateOffset < 0) {
                        updateOffset = 0;
                        if (entry.fFlushCounter == flushCounter) {
                            entry.fAllChildrenKnown = true;
                        }
                    }
                    if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                        DsfUIPlugin.debug("cacheSavedChildren(node = " + node + ", update = " + update + ", children = {" + updateOffset + "->" + (updateOffset + ((List)this.getData()).size()) + "})");
                    }
                    if (flushCounter == entry.fFlushCounter) {
                        entry.ensureChildrenMap();
                    }
                    int j = 0;
                    while (j < ((List)this.getData()).size()) {
                        int offset = updateOffset + j;
                        Object child = ((List)this.getData()).get(j);
                        if (child != null) {
                            if (flushCounter == entry.fFlushCounter) {
                                entry.fChildren.put(offset, child);
                            }
                            update.setChild(child, offset);
                        }
                        ++j;
                    }
                    update.done();
                }

                @Override
                protected void handleCancel() {
                    if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                        DsfUIPlugin.debug("cacheCanceledChildren(node = " + node + ", update = " + update + ")");
                    }
                    super.handleCancel();
                }
            });
            super.updateNode(node, updateProxy);
        } else if (update.getOffset() < 0) {
            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("cacheHitChildren(node = " + node + ", update = " + update + ", children = " + entry.fChildren.keySet() + ")");
            }
            assert (entry.fAllChildrenKnown);
            int position = 0;
            while (position < entry.fChildren.size()) {
                update.setChild(entry.fChildren.get(position), position);
                ++position;
            }
            update.done();
        } else {
            LinkedList<Integer> childrenMissingFromCache = new LinkedList<Integer>();
            int i = update.getOffset();
            while (i < update.getOffset() + update.getLength()) {
                childrenMissingFromCache.add(i);
                ++i;
            }
            Integer position = update.getOffset();
            while (position < update.getOffset() + update.getLength()) {
                Object child = entry.fChildren.get(position);
                if (child != null) {
                    update.setChild(entry.fChildren.get(position), position.intValue());
                    childrenMissingFromCache.remove(position);
                }
                position = position + 1;
            }
            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("cachePartialHitChildren(node = " + node + ", update = " + update + ", missing = " + childrenMissingFromCache + ")");
            }
            if (!childrenMissingFromCache.isEmpty()) {
                ArrayList<VMChildrenUpdate> partialUpdates = new ArrayList<VMChildrenUpdate>(2);
                final ViewerCountingRequestMonitor multiRm = new ViewerCountingRequestMonitor(this.getExecutor(), (IViewerUpdate)update);
                while (!childrenMissingFromCache.isEmpty()) {
                    final int n = (Integer)childrenMissingFromCache.get(0);
                    childrenMissingFromCache.remove(0);
                    int length = 1;
                    while (!childrenMissingFromCache.isEmpty() && (Integer)childrenMissingFromCache.get(0) == n + length) {
                        ++length;
                        childrenMissingFromCache.remove(0);
                    }
                    partialUpdates.add(new VMChildrenUpdate((IViewerUpdate)update, n, length, new DataRequestMonitor<List<Object>>(this.getExecutor(), (RequestMonitor)multiRm){

                        protected void handleSuccess() {
                            if (flushCounter == entry.fFlushCounter) {
                                if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                                    DsfUIPlugin.debug("cachePartialSaveChildren(node = " + node + ", update = " + update + ", saved = {" + n + "->" + (n + ((List)this.getData()).size()) + "})");
                                }
                                entry.ensureChildrenMap();
                            }
                            int i = 0;
                            while (i < ((List)this.getData()).size()) {
                                if (((List)this.getData()).get(i) != null) {
                                    update.setChild(((List)this.getData()).get(i), n + i);
                                    if (flushCounter == entry.fFlushCounter) {
                                        entry.fChildren.put(n + i, ((List)this.getData()).get(i));
                                    }
                                }
                                ++i;
                            }
                            multiRm.done();
                        }
                    }));
                }
                for (IChildrenUpdate iChildrenUpdate : partialUpdates) {
                    super.updateNode(node, iChildrenUpdate);
                }
                multiRm.setDoneCount(partialUpdates.size());
            } else {
                update.done();
            }
        }
    }

    private void flush(FlushMarkerKey flushKey) {
        if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
            DsfUIPlugin.debug("cacheFlushing(" + flushKey + ")");
        }
        Entry entry = this.fCacheListHead.fPrevious;
        while (entry != this.fCacheListHead) {
            if (entry.fKey instanceof FlushMarkerKey) {
                FlushMarkerKey entryFlushKey = (FlushMarkerKey)entry.fKey;
                if (flushKey.includes(entryFlushKey)) {
                    this.fCacheData.remove(entryFlushKey);
                    entry.remove();
                }
                if (entryFlushKey.includes(flushKey)) {
                    break;
                }
            } else if (entry instanceof ElementDataEntry) {
                ElementDataEntry elementDataEntry = (ElementDataEntry)entry;
                ElementDataKey elementDataKey = (ElementDataKey)elementDataEntry.fKey;
                int updateFlags = flushKey.getUpdateFlags(elementDataKey);
                if ((updateFlags & 1) != 0) {
                    if ((updateFlags & 3) == 3) {
                        if (elementDataEntry.fProperties != null) {
                            elementDataEntry.fArchiveProperties = elementDataEntry.fProperties;
                        }
                        elementDataEntry.fProperties = null;
                        if (elementDataEntry.fArchiveProperties == null) {
                            this.fCacheData.remove(entry.fKey);
                            entry.remove();
                        }
                    } else if (elementDataEntry.fArchiveProperties != null) {
                        elementDataEntry.fProperties = null;
                    } else {
                        this.fCacheData.remove(entry.fKey);
                        entry.remove();
                    }
                    ++elementDataEntry.fFlushCounter;
                    elementDataEntry.fHasChildren = null;
                    elementDataEntry.fChildrenCount = null;
                    elementDataEntry.fChildren = null;
                    elementDataEntry.fAllChildrenKnown = false;
                    elementDataEntry.fDirty = false;
                } else if ((updateFlags & 0x10) != 0) {
                    elementDataEntry.fProperties = null;
                } else if ((updateFlags & 8) != 0) {
                    Collection<String> propertiesToFlush = flushKey.getPropertiesToFlush(elementDataKey, elementDataEntry.fDirty);
                    if (propertiesToFlush != null && elementDataEntry.fProperties != null) {
                        elementDataEntry.fProperties.keySet().removeAll(propertiesToFlush);
                    }
                } else if ((updateFlags & 4) != 0) {
                    elementDataEntry.fDirty = true;
                    if (elementDataEntry.fProperties != null) {
                        elementDataEntry.fProperties.put("cache_entry_dirty", Boolean.TRUE);
                    }
                }
            }
            entry = entry.fPrevious;
        }
        Entry flushMarkerEntry = new Entry(flushKey);
        this.fCacheData.put(flushKey, flushMarkerEntry);
        flushMarkerEntry.insert(this.fCacheListHead);
    }

    @Override
    protected void handleEvent(final IVMModelProxy proxyStrategy, final Object event, final RequestMonitor rm) {
        IElementUpdateTester elementTester = this.getActiveUpdatePolicy().getElementUpdateTester(event);
        this.flush(new FlushMarkerKey(proxyStrategy.getRootElement(), elementTester));
        if (!proxyStrategy.isDisposed()) {
            if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                this.trace(event, null, proxyStrategy, EventHandlerAction.processing);
            }
            proxyStrategy.createDelta(event, new DataRequestMonitor<IModelDelta>(this.getExecutor(), rm){

                public void handleSuccess() {
                    if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                        AbstractCachingVMProvider.this.trace(event, null, proxyStrategy, EventHandlerAction.firedDeltaFor);
                    }
                    if (AbstractCachingVMProvider.this.fDelayEventHandleForViewUpdate) {
                        ITreeModelViewer viewer = (ITreeModelViewer)proxyStrategy.getViewer();
                        new ViewUpdateFinishedListener(viewer).start(rm);
                    }
                    proxyStrategy.fireModelChanged((IModelDelta)this.getData());
                    if (!AbstractCachingVMProvider.this.fDelayEventHandleForViewUpdate) {
                        rm.done();
                    }
                }

                public String toString() {
                    return "Result of a delta for event: '" + event.toString() + "' in VMP: '" + AbstractCachingVMProvider.this + "'" + "\n" + ((IModelDelta)this.getData()).toString();
                }
            });
        } else {
            rm.done();
        }
    }

    @Override
    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IVMModelProxy proxy = null;
        for (IVMModelProxy next : this.getActiveModelProxies()) {
            if (next == null || !next.getRootElement().equals(element) || !next.isDisposed()) continue;
            proxy = next;
            break;
        }
        if (proxy == null) {
            proxy = this.createModelProxyStrategy(element);
            this.getActiveModelProxies().add(proxy);
        } else if (proxy.isDisposed()) {
            proxy.init(context);
        }
        return proxy;
    }

    protected void rootElementRemovedFromCache(Object rootElement) {
        this.fRootMarkers.remove(rootElement);
        Iterator<IVMModelProxy> proxiesItr = this.getActiveModelProxies().iterator();
        while (proxiesItr.hasNext()) {
            IVMModelProxy proxy = proxiesItr.next();
            if (!proxy.isDisposed() || !proxy.getRootElement().equals(rootElement)) continue;
            proxiesItr.remove();
        }
    }

    private ElementDataKey makeEntryKey(IVMNode node, IViewerUpdate update) {
        return this.makeEntryKey(node, update.getViewerInput(), update.getElementPath());
    }

    private ElementDataKey makeEntryKey(IVMNode node, Object viewerInput, TreePath path) {
        Object rootElement = viewerInput;
        block0: for (IVMModelProxy proxy : this.getActiveModelProxies()) {
            Object proxyRoot = proxy.getRootElement();
            if (proxyRoot.equals(viewerInput)) {
                rootElement = proxyRoot;
                break;
            }
            int i = 0;
            while (i < path.getSegmentCount()) {
                if (proxyRoot.equals(path.getSegment(i))) {
                    rootElement = proxyRoot;
                    break block0;
                }
                ++i;
            }
        }
        return new ElementDataKey(rootElement, node, viewerInput, path);
    }

    private ElementDataEntry getElementDataEntry(ElementDataKey key, boolean create) {
        assert (key != null);
        ElementDataEntry entry = (ElementDataEntry)this.fCacheData.get(key);
        if (entry != null) {
            entry.reinsert(this.fCacheListHead);
        } else if (create) {
            entry = new ElementDataEntry(key);
            this.addEntry(key, entry);
        }
        return entry;
    }

    private void updateRootElementMarker(Object rootElement, IVMNode node, IViewerUpdate update) {
        Entry rootMarkerEntry;
        boolean created = false;
        RootElementMarkerKey rootMarker = this.fRootMarkers.get(rootElement);
        if (rootMarker == null) {
            rootMarker = new RootElementMarkerKey(rootElement);
            this.fRootMarkers.put(rootElement, rootMarker);
            created = true;
        }
        if ((rootMarkerEntry = this.fCacheData.get(rootMarker)) == null) {
            rootMarkerEntry = new RootElementMarkerEntry(rootMarker);
            this.addEntry(rootMarker, rootMarkerEntry);
        } else if (rootMarkerEntry.fNext != this.fCacheListHead) {
            rootMarkerEntry.reinsert(this.fCacheListHead);
        }
        if (created) {
            Map<String, Object> rootElementProperties;
            ElementDataKey rootElementDataKey = new ElementDataKey(rootElement, node, update.getViewerInput(), update.getElementPath());
            ElementDataEntry entry = this.getElementDataEntry(rootElementDataKey, false);
            Object[] rootElementChildren = this.getActiveUpdatePolicy().getInitialRootElementChildren(rootElement);
            if (rootElementChildren != null) {
                entry.fHasChildren = rootElementChildren.length > 0;
                entry.fChildrenCount = rootElementChildren.length;
                entry.fChildren = new HashMap<Integer, Object>(entry.fChildrenCount * 4 / 3);
                int i = 0;
                while (i < rootElementChildren.length) {
                    entry.fChildren.put(i, rootElementChildren[i]);
                    ++i;
                }
                entry.fAllChildrenKnown = true;
                entry.fDirty = true;
            }
            if ((rootElementProperties = this.getActiveUpdatePolicy().getInitialRootElementProperties(rootElement)) != null) {
                entry.fProperties = new HashMap<String, Object>((rootElementProperties.size() + 1) * 4 / 3);
                entry.fProperties.putAll(rootElementProperties);
                entry.fProperties.put("cache_entry_dirty", true);
                entry.fDirty = true;
            }
        }
    }

    private void addEntry(Object key, Entry entry) {
        this.fCacheData.put(key, entry);
        entry.insert(this.fCacheListHead);
        if (this.fCacheData.size() > 1000) {
            this.fCacheData.remove(this.fCacheListHead.fNext.fKey);
            this.fCacheListHead.fNext.remove();
        }
    }

    @Override
    public void update(IPropertiesUpdate[] updates) {
        if (updates.length == 0) {
            return;
        }
        boolean allNodesTheSame = true;
        IVMNode firstNode = this.getNodeForElement(updates[0].getElement());
        int i = 1;
        while (i < updates.length) {
            if (firstNode != this.getNodeForElement(updates[i].getElement())) {
                allNodesTheSame = false;
                break;
            }
            ++i;
        }
        if (allNodesTheSame) {
            if (!(firstNode instanceof IElementPropertiesProvider)) {
                IPropertiesUpdate[] iPropertiesUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertiesUpdate update = iPropertiesUpdateArray[n2];
                    update.setStatus(DsfUIPlugin.newErrorStatus(10002, "Element is not a VM Context or its node is not a properties provider.", null));
                    update.done();
                    ++n2;
                }
            } else {
                this.updateNode(firstNode, updates);
            }
        } else {
            HashMap nodeUpdatesMap = new HashMap();
            IPropertiesUpdate[] iPropertiesUpdateArray = updates;
            int n = updates.length;
            int n3 = 0;
            while (n3 < n) {
                IPropertiesUpdate update = iPropertiesUpdateArray[n3];
                IVMNode node = this.getNodeForElement(update.getElement());
                if (node == null || !(node instanceof IElementPropertiesProvider)) {
                    update.setStatus(DsfUIPlugin.newErrorStatus(10002, "Element is not a VM Context or its node is not a properties provider.", null));
                    update.done();
                } else {
                    if (!nodeUpdatesMap.containsKey(node)) {
                        nodeUpdatesMap.put(node, new ArrayList());
                    }
                    ((List)nodeUpdatesMap.get(node)).add(update);
                }
                ++n3;
            }
            for (IVMNode node : nodeUpdatesMap.keySet()) {
                this.updateNode(node, ((List)nodeUpdatesMap.get(node)).toArray(new IPropertiesUpdate[((List)nodeUpdatesMap.get(node)).size()]));
            }
        }
    }

    private IVMNode getNodeForElement(Object element) {
        if (element instanceof IVMContext) {
            return ((IVMContext)element).getVMNode();
        }
        return null;
    }

    protected void updateNode(final IVMNode node, IPropertiesUpdate[] updates) {
        LinkedList<VMPropertiesUpdate> missUpdates = new LinkedList<VMPropertiesUpdate>();
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            ElementDataKey key = this.makeEntryKey(node, update);
            final ElementDataEntry entry = this.getElementDataEntry(key, true);
            this.updateRootElementMarker(key.fRootElement, node, update);
            if (entry.fProperties != null && entry.fProperties.keySet().containsAll(update.getProperties())) {
                if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                    DsfUIPlugin.debug("cacheHitProperties(node = " + node + ", update = " + update + ", " + entry.fProperties + ")");
                }
                if (entry.fProperties.containsKey("update_policy_id")) {
                    entry.fProperties.put("update_policy_id", this.getActiveUpdatePolicy().getID());
                }
                update.setAllProperties(entry.fProperties);
                update.setStatus((IStatus)entry.fProperties.get(PROP_UPDATE_STATUS));
                update.done();
            } else {
                Set<String> missingProperties = null;
                if (entry.fProperties != null) {
                    missingProperties = new HashSet<String>(update.getProperties().size() * 4 / 3);
                    missingProperties.addAll(update.getProperties());
                    missingProperties.removeAll(entry.fProperties.keySet());
                    if (entry.fDirty.booleanValue()) {
                        if (this.getActiveUpdatePolicy() instanceof IVMUpdatePolicyExtension) {
                            IVMUpdatePolicyExtension updatePolicyExt = (IVMUpdatePolicyExtension)this.getActiveUpdatePolicy();
                            Iterator<String> itr = missingProperties.iterator();
                            while (itr.hasNext()) {
                                String missingProperty = itr.next();
                                if (updatePolicyExt.canUpdateDirtyProperty(entry, missingProperty)) continue;
                                itr.remove();
                                PropertiesUpdateStatus.getPropertiesStatus(update).setStatus(missingProperty, DsfUIPlugin.newErrorStatus(10001, "Cache contains stale data.  Refresh view.", null));
                            }
                        } else {
                            PropertiesUpdateStatus.getPropertiesStatus(update).setStatus(missingProperties.toArray(new String[missingProperties.size()]), DsfUIPlugin.newErrorStatus(10001, "Cache contains stale data.  Refresh view.", null));
                            missingProperties.clear();
                        }
                        if (missingProperties.isEmpty()) {
                            if (entry.fProperties.containsKey("update_policy_id")) {
                                entry.fProperties.put("update_policy_id", this.getActiveUpdatePolicy().getID());
                            }
                            update.setAllProperties(entry.fProperties);
                            update.done();
                            return;
                        }
                    }
                } else {
                    missingProperties = update.getProperties();
                }
                final Set<String> _missingProperties = missingProperties;
                final int flushCounter = entry.fFlushCounter;
                missUpdates.add(new VMPropertiesUpdate(missingProperties, update, (DataRequestMonitor<Map<String, Object>>)new ViewerDataRequestMonitor<Map<String, Object>>(this.getExecutor(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        PropertiesUpdateStatus cachedStatus;
                        Map<String, Object> cachedProperties;
                        PropertiesUpdateStatus missUpdateStatus = PropertiesUpdateStatus.makePropertiesStatus(this.getStatus());
                        if (!this.isCanceled() && flushCounter == entry.fFlushCounter) {
                            if (entry.fProperties == null) {
                                entry.fProperties = new HashMap<String, Object>((((Map)this.getData()).size() + 3) * 4 / 3);
                                if (update.getProperties().contains("cache_entry_dirty")) {
                                    entry.fProperties.put("cache_entry_dirty", entry.fDirty);
                                }
                                entry.fProperties.put(AbstractCachingVMProvider.PROP_UPDATE_STATUS, (Object)new PropertiesUpdateStatus());
                            }
                            cachedProperties = entry.fProperties;
                            cachedProperties.putAll((Map)this.getData());
                            for (String property : _missingProperties) {
                                if (((Map)this.getData()).containsKey(property)) continue;
                                cachedProperties.put(property, null);
                            }
                            cachedStatus = (PropertiesUpdateStatus)((Object)cachedProperties.get(AbstractCachingVMProvider.PROP_UPDATE_STATUS));
                            cachedStatus = PropertiesUpdateStatus.mergePropertiesStatus(cachedStatus, missUpdateStatus, _missingProperties);
                            cachedProperties.put(AbstractCachingVMProvider.PROP_UPDATE_STATUS, (Object)cachedStatus);
                        } else {
                            if (entry.fProperties != null) {
                                cachedProperties = new HashMap<String, Object>((entry.fProperties.size() + ((Map)this.getData()).size() + 3) * 4 / 3);
                                cachedProperties.putAll(entry.fProperties);
                                cachedStatus = PropertiesUpdateStatus.mergePropertiesStatus((PropertiesUpdateStatus)((Object)cachedProperties.get(AbstractCachingVMProvider.PROP_UPDATE_STATUS)), missUpdateStatus, _missingProperties);
                            } else {
                                cachedProperties = new HashMap<String, Object>((((Map)this.getData()).size() + 3) * 4 / 3);
                                cachedStatus = missUpdateStatus;
                            }
                            cachedProperties.putAll((Map)this.getData());
                            cachedProperties.put(AbstractCachingVMProvider.PROP_UPDATE_STATUS, (Object)missUpdateStatus);
                            if (update.getProperties().contains("cache_entry_dirty")) {
                                cachedProperties.put("cache_entry_dirty", Boolean.TRUE);
                            }
                        }
                        if (update.getProperties().contains("update_policy_id")) {
                            cachedProperties.put("update_policy_id", AbstractCachingVMProvider.this.getActiveUpdatePolicy().getID());
                        }
                        if (entry.fArchiveProperties != null && flushCounter == entry.fFlushCounter) {
                            for (String updateProperty : update.getProperties()) {
                                if (!updateProperty.startsWith("is_changed.")) continue;
                                String changedPropertyName = updateProperty.substring(LENGTH_PROP_IS_CHANGED_PREFIX);
                                Object newValue = cachedProperties.get(changedPropertyName);
                                Object oldValue = entry.fArchiveProperties.get(changedPropertyName);
                                if (oldValue == null) continue;
                                cachedProperties.put(updateProperty, !oldValue.equals(newValue));
                            }
                        }
                        if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                            DsfUIPlugin.debug("cacheSavedProperties(node = " + node + ", update = " + update + ", " + this.getData() + ")");
                        }
                        for (String property : update.getProperties()) {
                            update.setProperty(property, cachedProperties.get(property));
                        }
                        PropertiesUpdateStatus updateStatus = PropertiesUpdateStatus.makePropertiesStatus(update.getStatus());
                        updateStatus = PropertiesUpdateStatus.mergePropertiesStatus(updateStatus, cachedStatus, update.getProperties());
                        update.setStatus((IStatus)updateStatus);
                        update.done();
                    }
                }));
            }
            ++n2;
        }
        if (!missUpdates.isEmpty()) {
            ((IElementPropertiesProvider)((Object)node)).update(missUpdates.toArray(new IPropertiesUpdate[missUpdates.size()]));
        }
    }

    @Override
    public boolean shouldWaitHandleEventToComplete() {
        return this.fDelayEventHandleForViewUpdate;
    }

    protected void setDelayEventHandleForViewUpdate(boolean on) {
        this.fDelayEventHandleForViewUpdate = on;
    }

    private void trace(Object event, Object skippedOrCanceledEvent, IVMModelProxy proxy, EventHandlerAction action) {
        assert (DEBUG_DELTA);
        StringBuilder str = new StringBuilder();
        str.append(DsfPlugin.getDebugTime());
        str.append(' ');
        if (action == EventHandlerAction.skipped || action == EventHandlerAction.canceled) {
            str.append(LoggingUtils.toString((Object)this)).append(' ').append((Object)action).append(" event ").append(LoggingUtils.toString((Object)skippedOrCanceledEvent)).append(" because of event ").append(LoggingUtils.toString((Object)event));
        } else {
            str.append(LoggingUtils.toString((Object)this)).append(' ').append((Object)action).append(" event ").append(LoggingUtils.toString((Object)event));
        }
        if (action != EventHandlerAction.received) {
            str.append(" for proxy ").append(LoggingUtils.toString((Object)proxy)).append(", whose root is ").append(LoggingUtils.toString((Object)proxy.getRootElement()));
        }
        DsfUIPlugin.debug(str.toString());
    }

    private static class ElementDataEntry
    extends Entry
    implements ICacheEntry {
        int fFlushCounter = 0;
        Boolean fDirty = false;
        Boolean fHasChildren = null;
        Integer fChildrenCount = null;
        boolean fAllChildrenKnown = false;
        Map<Integer, Object> fChildren = null;
        Map<String, Object> fProperties = null;
        Map<String, Object> fArchiveProperties = null;

        ElementDataEntry(ElementDataKey key) {
            super(key);
        }

        void ensureChildrenMap() {
            if (this.fChildren == null) {
                Integer childrenCount = this.fChildrenCount;
                childrenCount = childrenCount != null ? childrenCount : 0;
                int capacity = Math.max(childrenCount * 4 / 3, 32);
                this.fChildren = new HashMap<Integer, Object>(capacity);
            }
        }

        public String toString() {
            return String.valueOf(this.fKey.toString()) + " = " + "[hasChildren=" + this.fHasChildren + ", " + "childrenCount=" + this.fChildrenCount + ", children=" + this.fChildren + ", properties=" + this.fProperties + ", oldProperties=" + this.fArchiveProperties + "]";
        }

        @Override
        public IVMNode getNode() {
            return ((ElementDataKey)this.fKey).fNode;
        }

        @Override
        public Object getViewerInput() {
            return ((ElementDataKey)this.fKey).fViewerInput;
        }

        @Override
        public TreePath getElementPath() {
            return ((ElementDataKey)this.fKey).fPath;
        }

        @Override
        public boolean isDirty() {
            return this.fDirty;
        }

        @Override
        public Boolean getHasChildren() {
            return this.fHasChildren;
        }

        @Override
        public Integer getChildCount() {
            return this.fChildrenCount;
        }

        @Override
        public Map<Integer, Object> getChildren() {
            return this.fChildren;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.fProperties;
        }

        @Override
        public Map<String, Object> getArchiveProperties() {
            return this.fArchiveProperties;
        }
    }

    private static class ElementDataKey {
        final Object fRootElement;
        final IVMNode fNode;
        final Object fViewerInput;
        final TreePath fPath;

        ElementDataKey(Object rootElement, IVMNode node, Object viewerInput, TreePath path) {
            this.fRootElement = rootElement;
            this.fNode = node;
            this.fViewerInput = viewerInput;
            this.fPath = path;
        }

        public String toString() {
            return String.valueOf(this.fNode.toString()) + " " + (this.fPath.getSegmentCount() == 0 ? this.fViewerInput.toString() : this.fPath.getLastSegment().toString());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ElementDataKey)) {
                return false;
            }
            ElementDataKey key = (ElementDataKey)obj;
            return (this.fNode == null && key.fNode == null || this.fNode != null && this.fNode.equals(key.fNode)) && (this.fRootElement == null && key.fRootElement == null || this.fRootElement != null && this.fRootElement.equals(key.fRootElement)) && (this.fViewerInput == null && key.fViewerInput == null || this.fViewerInput != null && this.fViewerInput.equals(key.fViewerInput)) && (this.fPath == null && key.fPath == null || this.fPath != null && this.fPath.equals((Object)key.fPath));
        }

        public int hashCode() {
            return (this.fRootElement != null ? this.fRootElement.hashCode() : 0) + (this.fNode != null ? this.fNode.hashCode() : 0) + (this.fViewerInput != null ? this.fViewerInput.hashCode() : 0) + (this.fPath != null ? this.fPath.hashCode() : 0);
        }
    }

    private static class Entry {
        final Object fKey;
        Entry fNext;
        Entry fPrevious;

        Entry(Object key) {
            this.fKey = key;
        }

        void insert(Entry nextEntry) {
            this.fNext = nextEntry;
            this.fPrevious = nextEntry.fPrevious;
            this.fPrevious.fNext = this;
            this.fNext.fPrevious = this;
        }

        void remove() {
            this.fPrevious.fNext = this.fNext;
            this.fNext.fPrevious = this.fPrevious;
        }

        void reinsert(Entry nextEntry) {
            this.fPrevious.fNext = this.fNext;
            this.fNext.fPrevious = this.fPrevious;
            this.fNext = nextEntry;
            this.fPrevious = nextEntry.fPrevious;
            this.fPrevious.fNext = this;
            this.fNext.fPrevious = this;
        }
    }

    private static enum EventHandlerAction {
        received,
        queued,
        processing,
        firedDeltaFor,
        skipped,
        canceled;

    }

    private static class FlushMarkerKey {
        private Object fRootElement;
        private IElementUpdateTester fElementTester;

        FlushMarkerKey(Object rootElement, IElementUpdateTester pathTester) {
            this.fRootElement = rootElement;
            this.fElementTester = pathTester;
        }

        boolean includes(FlushMarkerKey key) {
            return this.fRootElement.equals(key.fRootElement) && this.fElementTester.includes(key.fElementTester);
        }

        int getUpdateFlags(ElementDataKey key) {
            if (this.fRootElement.equals(key.fRootElement)) {
                return this.fElementTester.getUpdateFlags(key.fViewerInput, key.fPath);
            }
            return 0;
        }

        Collection<String> getPropertiesToFlush(ElementDataKey key, boolean isDirty) {
            if (this.fRootElement.equals(key.fRootElement) && this.fElementTester instanceof IElementUpdateTesterExtension) {
                return ((IElementUpdateTesterExtension)this.fElementTester).getPropertiesToFlush(key.fViewerInput, key.fPath, isDirty);
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.fElementTester.toString()) + " " + this.fRootElement.toString();
        }
    }

    class RootElementMarkerEntry
    extends Entry {
        RootElementMarkerEntry(RootElementMarkerKey key) {
            super(key);
        }

        @Override
        void remove() {
            super.remove();
            AbstractCachingVMProvider.this.rootElementRemovedFromCache(((RootElementMarkerKey)this.fKey).fRootElement);
        }

        public String toString() {
            return "ROOT MARKER " + this.fKey;
        }
    }

    private static class RootElementMarkerKey {
        private Object fRootElement;

        RootElementMarkerKey(Object rootElement) {
            this.fRootElement = rootElement;
        }

        public boolean equals(Object obj) {
            return obj instanceof RootElementMarkerKey && ((RootElementMarkerKey)obj).fRootElement.equals(this.fRootElement);
        }

        public int hashCode() {
            return this.fRootElement.hashCode();
        }

        public String toString() {
            return this.fRootElement.toString();
        }
    }

    private class ViewUpdateFinishedListener
    implements IViewerUpdateListener,
    IModelChangedListener {
        private final ITreeModelViewer fViewer;
        private boolean fViewerChangeStarted = false;
        private RequestMonitor fRm;

        ViewUpdateFinishedListener(ITreeModelViewer viewer) {
            this.fViewer = viewer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void start(RequestMonitor rm) {
            ViewUpdateFinishedListener viewUpdateFinishedListener = this;
            synchronized (viewUpdateFinishedListener) {
                this.fViewer.addModelChangedListener((IModelChangedListener)this);
                this.fViewer.addViewerUpdateListener((IViewerUpdateListener)this);
                this.fRm = rm;
            }
        }

        public synchronized void viewerUpdatesComplete() {
            this.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(IModelDelta delta, IModelProxy proxy) {
            ViewUpdateFinishedListener viewUpdateFinishedListener = this;
            synchronized (viewUpdateFinishedListener) {
                if (!this.fViewerChangeStarted) {
                    this.done();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewerUpdatesBegin() {
            ViewUpdateFinishedListener viewUpdateFinishedListener = this;
            synchronized (viewUpdateFinishedListener) {
                this.fViewerChangeStarted = true;
            }
        }

        private synchronized void done() {
            if (this.fRm != null) {
                this.fRm.done();
                this.fViewer.removeViewerUpdateListener((IViewerUpdateListener)this);
                this.fViewer.removeModelChangedListener((IModelChangedListener)this);
            }
        }

        public void updateStarted(IViewerUpdate update) {
        }

        public void updateComplete(IViewerUpdate update) {
        }
    }
}

