/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers;

import java.util.List;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultMoveBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class MoveContainerFeature
extends DefaultMoveBPMNShapeFeature {
    protected List<PictogramElement> children;

    public MoveContainerFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected void preMoveShape(IMoveShapeContext context) {
        Shape shape = context.getShape();
        if (!FeatureSupport.isLabelShape((PictogramElement)shape) && shape instanceof ContainerShape) {
            ContainerShape rootContainer = FeatureSupport.getRootContainer((ContainerShape)shape);
            this.children = FeatureSupport.getPoolAndLaneDescendants(rootContainer);
        }
        super.preMoveShape(context);
    }

    @Override
    protected void postMoveShape(IMoveShapeContext context) {
        Shape shape = context.getShape();
        if (!FeatureSupport.isLabelShape((PictogramElement)shape) && shape instanceof ContainerShape) {
            for (PictogramElement pe : this.children) {
                if (pe instanceof Connection) {
                    FeatureSupport.updateConnection(this.getFeatureProvider(), (Connection)pe, true);
                    continue;
                }
                DIUtils.updateDIShape(pe);
                FeatureSupport.updateLabel(this.getFeatureProvider(), pe, null);
            }
        }
        super.postMoveShape(context);
    }
}

