/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class FaultHandlersValidator
extends CValidator {
    int fCatches;
    int fCatchAll;
    public static IFilter<INode> PARENTS = Filters.SCOPE_OR_PROCESS;
    static IFilter<INode> CATCHES = new NodeNameFilter(ND_CATCH, ND_CATCH_ALL);

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.fCatches = this.checkChild(ND_CATCH, 0, Integer.MAX_VALUE);
        this.fCatchAll = this.checkChild(ND_CATCH_ALL, 0, 1);
    }

    @Override
    protected void start() {
        super.start();
    }

    @ARule(date="01/10/2007", author="michal.chmielewski@oracle.com", desc="At least one catch or catchAll must be present in fault handlers.", sa=80, errors="BPELC__AT_LEAST_ONE")
    public void rule_CheckHandlerCount_1() {
        int count = this.fCatchAll + this.fCatches;
        if (count < 1) {
            IProblem problem = this.createError();
            problem.fill("BPELC__AT_LEAST_ONE", this.toString(this.mNode.nodeName()), 0, CATCHES, 0);
        }
    }
}

