/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class IncludedCssStyleSheetValidator
extends AbstractElementValidator {
    private static IncludedCssStyleSheetValidator instance = new IncludedCssStyleSheetValidator();

    public static IncludedCssStyleSheetValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        List<CssStyleSheet> cssStyle = null;
        Iterator iter = null;
        if (element instanceof AbstractTheme) {
            AbstractThemeHandle themeHandle = (AbstractThemeHandle)element.getHandle(module);
            iter = themeHandle.includeCssesIterator();
            cssStyle = ((AbstractTheme)element).getCsses();
        } else if (element instanceof ReportDesign) {
            ReportDesignHandle handle = (ReportDesignHandle)element.getHandle(module);
            iter = handle.includeCssesIterator();
            cssStyle = ((ReportDesign)element).getCsses();
        } else {
            assert (false);
            return Collections.emptyList();
        }
        ArrayList<String> cssFileNameList = new ArrayList<String>();
        if (cssStyle != null) {
            int i = 0;
            while (i < cssStyle.size()) {
                CssStyleSheet css = cssStyle.get(i);
                cssFileNameList.add(css.getFileName());
                ++i;
            }
        }
        ArrayList<SemanticException> errorList = new ArrayList<SemanticException>();
        while (iter.hasNext()) {
            IncludedCssStyleSheetHandle includedCssStyleSheet = (IncludedCssStyleSheetHandle)iter.next();
            String fileName = includedCssStyleSheet.getFileName();
            String externalCSSURI = includedCssStyleSheet.getExternalCssURI();
            if (externalCSSURI != null || cssFileNameList.contains(fileName)) continue;
            CssException ex = new CssException(module, (IncludedCssStyleSheet)includedCssStyleSheet.getStructure(), new String[]{fileName}, "Error.CSSException.CSS_NOT_FOUND");
            errorList.add(ex);
        }
        return errorList;
    }
}

