/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value;

import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class RGBColorValue
extends Value
implements RGBColor {
    protected CSSPrimitiveValue red;
    protected CSSPrimitiveValue green;
    protected CSSPrimitiveValue blue;

    public RGBColorValue(CSSPrimitiveValue r, CSSPrimitiveValue g, CSSPrimitiveValue b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    @Override
    public short getPrimitiveType() {
        return 25;
    }

    @Override
    public String getCssText() {
        return "rgb(" + this.red.getCssText() + ", " + this.green.getCssText() + ", " + this.blue.getCssText() + ")";
    }

    @Override
    public CSSPrimitiveValue getRed() throws DOMException {
        return this.red;
    }

    @Override
    public CSSPrimitiveValue getGreen() throws DOMException {
        return this.green;
    }

    @Override
    public CSSPrimitiveValue getBlue() throws DOMException {
        return this.blue;
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        return this;
    }

    public String toString() {
        return this.getCssText();
    }

    public boolean equals(Object value) {
        if (value instanceof RGBColorValue) {
            RGBColorValue color = (RGBColorValue)value;
            if (this.red.equals(color.red) && this.blue.equals(color.blue) && this.green.equals(color.green)) {
                return true;
            }
        }
        return false;
    }
}

