/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DataDefinitionTextManager;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class AggregateEditorComposite
extends Composite
implements MouseListener {
    protected static final String AGG_DISPLAY_NONE = Messages.getString("AggregateEditorComposite.AggregateDisplayName.None");
    protected static final String AGG_DISPLAY_DEFAULT = Messages.getString("AggregateEditorComposite.AggregateDisplayName.Default");
    protected static final String AGG_FUNC_NONE = "None";
    private ToolBar fBtnDropDown;
    private AggregateDropDownEditorComposite fAggregateEditor;
    private SeriesDefinition fSeriesDefi;
    private ChartWizardContext fChartContext;
    private SeriesGrouping fGrouping;
    private Query query;
    private boolean fEnabled;
    private static final int BLOCK_WIDTH = 200;
    private static final int BLOCK_HEIGHT = 120;
    private static final int DEFAULT_BUTTON_WIDTH = 50;

    public AggregateEditorComposite(Composite parent, SeriesDefinition sd, ChartWizardContext context, boolean enabled) {
        super(parent, 0);
        this.setSeriesDefinition(sd);
        this.fChartContext = context;
        this.fEnabled = enabled;
        this.placeComponents();
    }

    public AggregateEditorComposite(Composite parent, SeriesDefinition sd, ChartWizardContext context, boolean enabled, Query query) {
        super(parent, 0);
        this.setAggregation(query, sd);
        this.fChartContext = context;
        this.fEnabled = enabled;
        this.placeComponents();
    }

    public void setSeriesDefinition(SeriesDefinition sd) {
        this.fSeriesDefi = sd;
        this.fGrouping = sd.getGrouping() != null ? sd.getGrouping().copyInstance() : SeriesGroupingImpl.create();
    }

    public void setAggregation(Query query, SeriesDefinition sd) {
        this.query = query;
        this.fSeriesDefi = sd;
        this.fGrouping = null;
        if (sd != null && sd.getGrouping() != null && sd.getGrouping().isEnabled()) {
            this.fGrouping = sd.getGrouping().copyInstance();
        }
        if (query.getGrouping() != null && query.getGrouping().isEnabled()) {
            this.fGrouping = query.getGrouping().copyInstance();
        }
        if (this.fGrouping == null) {
            this.fGrouping = SeriesGroupingImpl.create();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fBtnDropDown.setEnabled(enabled);
    }

    private void placeComponents() {
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.fBtnDropDown = new ToolBar((Composite)this, 0x800000);
        ChartUIUtil.addScreenReaderAccessbility((Control)this.fBtnDropDown, (String)"Aggregation");
        if (this.fEnabled && this.isEnabled()) {
            this.fBtnDropDown.setToolTipText(Messages.getString("AggregateEditorComposite.Tooltip.SetAggregateFunction"));
        }
        ToolBarManager toolManager = new ToolBarManager(this.fBtnDropDown);
        toolManager.add((IAction)new AggregationAction(this.fEnabled));
        toolManager.update(true);
        this.fBtnDropDown.addMouseListener((MouseListener)this);
        this.fBtnDropDown.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AggregateEditorComposite.this.toggleDropDown();
                }
            }
        });
    }

    private void toggleDropDown() {
        if (!this.fEnabled || !this.isEnabled()) {
            return;
        }
        if (this.fAggregateEditor == null || this.fAggregateEditor.isDisposed()) {
            this.createDropDownComponent();
        } else {
            this.fAggregateEditor.getShell().close();
        }
    }

    private void createDropDownComponent() {
        Point pLoc = UIHelper.getScreenLocation((Composite)this.fBtnDropDown.getParent());
        int iXLoc = pLoc.x;
        int iYLoc = pLoc.y + this.fBtnDropDown.getParent().getSize().y;
        int iShellWidth = 200;
        int iShellHeight = 120;
        if ((this.getStyle() & 0x4000000) != 0) {
            iXLoc -= iShellWidth;
        }
        if (iXLoc + iShellWidth > this.getDisplay().getClientArea().width) {
            iXLoc = this.getDisplay().getClientArea().width - iShellWidth;
        }
        Shell shell = new Shell(this.getShell(), 0);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(iShellWidth, iShellHeight);
        shell.setLocation(iXLoc, iYLoc);
        if (this.query != null) {
            this.setAggregation(this.query, this.fSeriesDefi);
        } else {
            this.setSeriesDefinition(this.fSeriesDefi);
        }
        this.fAggregateEditor = new AggregateDropDownEditorComposite((Composite)shell, 0, null);
        shell.layout();
        shell.open();
    }

    private boolean isSetAggregate() {
        return this.fGrouping.isEnabled();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.toggleDropDown();
    }

    public void mouseUp(MouseEvent e) {
    }

    private void closeAggregateEditor(Shell shell) {
        if (shell != null && !shell.isDisposed()) {
            shell.close();
        }
    }

    protected boolean shouldEnableAllAggregations() {
        return this.isBaseGroupingDefined();
    }

    private boolean isBaseGroupingDefined() {
        SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.fChartContext.getModel()).get(0);
        return baseSD.getGrouping() != null && baseSD.getGrouping().isEnabled();
    }

    protected void populateAggregationCombo(Combo aggregationCombo) {
        String[] aggDisplayNames = null;
        String[] aggFunctions = null;
        if (this.shouldEnableAllAggregations()) {
            try {
                String noneItem;
                String[] names = aggDisplayNames = PluginSettings.instance().getRegisteredAggregateFunctionDisplayNames();
                String[] funcs = PluginSettings.instance().getRegisteredAggregateFunctions();
                aggDisplayNames = new String[names.length + 1];
                aggFunctions = new String[names.length + 1];
                SeriesDefinition baseSD = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.fChartContext.getModel()).get(0);
                String aggFunc = baseSD.getGrouping().getAggregateExpression();
                int index = 0;
                int i = 0;
                while (i < funcs.length) {
                    if (funcs[i].equals(aggFunc)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                aggDisplayNames[0] = noneItem = String.valueOf(AGG_DISPLAY_DEFAULT) + "(" + names[index] + ")";
                aggFunctions[0] = AGG_FUNC_NONE;
                int i2 = 1;
                while (i2 < aggDisplayNames.length) {
                    aggDisplayNames[i2] = names[i2 - 1];
                    aggFunctions[i2] = funcs[i2 - 1];
                    ++i2;
                }
            }
            catch (ChartException e) {
                WizardBase.displayException((Throwable)e);
            }
        } else {
            try {
                String[] names = PluginSettings.instance().getRegisteredAggregateFunctionDisplayNames(1);
                String[] funcs = PluginSettings.instance().getRegisteredAggregateFunctions(1);
                aggDisplayNames = new String[names.length + 1];
                aggFunctions = new String[names.length + 1];
                aggDisplayNames[0] = AGG_DISPLAY_NONE;
                aggFunctions[0] = AGG_FUNC_NONE;
                int i = 1;
                while (i < aggDisplayNames.length) {
                    aggDisplayNames[i] = names[i - 1];
                    aggFunctions[i] = funcs[i - 1];
                    ++i;
                }
            }
            catch (ChartException e) {
                WizardBase.displayException((Throwable)e);
            }
        }
        aggregationCombo.setItems(aggDisplayNames);
        aggregationCombo.setData(aggFunctions);
    }

    private class AggregateDropDownEditorComposite
    extends Composite
    implements PaintListener,
    Listener,
    SelectionListener {
        private Composite fCmpAggregate;
        private Label fLabelAggregate;
        private Combo fCmbAggregate;
        private Composite fAggParameterComposite;
        private List<Text> fAggParamtersTextWidgets;
        private Map<Button, Text> fExprBuilderWidgetsMap;
        private boolean isPressingKey;
        private String fTitle;
        private Button fBtnOK;
        private Button fBtnCancel;

        AggregateDropDownEditorComposite(Composite parent, int style, String title) {
            super(parent, style);
            this.fAggParamtersTextWidgets = new ArrayList<Text>();
            this.fExprBuilderWidgetsMap = new HashMap<Button, Text>();
            this.isPressingKey = false;
            this.fTitle = null;
            this.placeComponents();
            this.fTitle = title == null || title.length() == 0 ? Messages.getString("AggregateEditorComposite.AggregateParameterDefinition.Title") : title;
        }

        private void placeComponents() {
            GridLayout glDropDown = new GridLayout();
            this.setLayout((Layout)glDropDown);
            this.fCmpAggregate = new Composite((Composite)this, 0);
            GridData gdCMPAggregate = new GridData(768);
            gdCMPAggregate.horizontalSpan = 2;
            this.fCmpAggregate.setLayoutData((Object)gdCMPAggregate);
            GridLayout glAggregate = new GridLayout();
            glAggregate.numColumns = 2;
            glAggregate.marginHeight = 0;
            glAggregate.marginWidth = 0;
            glAggregate.horizontalSpacing = 5;
            glAggregate.verticalSpacing = 5;
            this.fCmpAggregate.setLayout((Layout)glAggregate);
            this.fLabelAggregate = new Label(this.fCmpAggregate, 0);
            GridData gdLBLAggregate = new GridData();
            this.fLabelAggregate.setLayoutData((Object)gdLBLAggregate);
            this.fLabelAggregate.setText(Messages.getString("SeriesGroupingComposite.Lbl.AggregateExpression"));
            this.fCmbAggregate = new Combo(this.fCmpAggregate, 12);
            this.fCmbAggregate.setLayoutData((Object)new GridData(768));
            this.fCmbAggregate.addSelectionListener((SelectionListener)this);
            this.fCmbAggregate.addListener(16, (Listener)this);
            this.fCmbAggregate.addListener(31, (Listener)this);
            this.fAggParameterComposite = new Composite(this.fCmpAggregate, 0);
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = 0;
            gridData.horizontalSpan = 2;
            gridData.exclude = true;
            this.fAggParameterComposite.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            this.fAggParameterComposite.setLayout((Layout)layout);
            ((GridData)this.fAggParameterComposite.getLayoutData()).heightHint = 0;
            this.populateAggFuncNames();
            this.setAggregatesState();
            Composite btnComposite = new Composite(this.fCmpAggregate, 0);
            gridData = new GridData(132);
            gridData.horizontalIndent = 0;
            gridData.horizontalSpan = 2;
            btnComposite.setLayoutData((Object)gridData);
            GridLayout glBtn = new GridLayout();
            glBtn.numColumns = 2;
            glBtn.marginHeight = 0;
            glBtn.marginWidth = 0;
            glBtn.horizontalSpacing = 5;
            glBtn.verticalSpacing = 5;
            btnComposite.setLayout((Layout)glBtn);
            this.fBtnOK = new Button(btnComposite, 0);
            this.fBtnOK.setText(Messages.getString("AggregateEditorComposite.Button.OK"));
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.minimumWidth = 50;
            this.fBtnOK.setLayoutData((Object)gd);
            this.fBtnOK.addSelectionListener((SelectionListener)this);
            this.fBtnCancel = new Button(btnComposite, 0);
            this.fBtnCancel.setText(Messages.getString("AggregateEditorComposite.Button.Cancel"));
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.minimumWidth = 50;
            this.fBtnCancel.setLayoutData((Object)gd);
            this.fBtnCancel.addSelectionListener((SelectionListener)this);
            this.getShell().pack();
            this.populateAggFuncNames();
            this.setAggregatesState();
        }

        void focusLost(FocusEvent e) {
            Control currentControl = this.isPressingKey ? Display.getCurrent().getFocusControl() : Display.getCurrent().getCursorControl();
            this.isPressingKey = false;
            if (currentControl != AggregateEditorComposite.this.fBtnDropDown && !this.isChildrenOfThis(currentControl)) {
                AggregateEditorComposite.this.closeAggregateEditor(this.getShell());
            }
        }

        private boolean isChildrenOfThis(Control control) {
            while (control != null) {
                if (control == this) {
                    return true;
                }
                control = control.getParent();
            }
            return false;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 16: {
                    this.focusLost(new FocusEvent(event));
                    break;
                }
                case 31: {
                    switch (event.detail) {
                        case 8: 
                        case 16: {
                            event.doit = true;
                            this.isPressingKey = true;
                        }
                    }
                }
            }
        }

        private void populateAggFuncNames() {
            String aggFuncName = null;
            this.fCmbAggregate.removeAll();
            AggregateEditorComposite.this.populateAggregationCombo(this.fCmbAggregate);
            this.fCmbAggregate.setVisibleItemCount(30);
            if (AggregateEditorComposite.this.fGrouping.isEnabled() && AggregateEditorComposite.this.fGrouping.getAggregateExpression() != null) {
                int idx = this.getAggregateIndexByName(AggregateEditorComposite.this.fGrouping.getAggregateExpression());
                if (this.fCmbAggregate.getItemCount() > idx) {
                    this.fCmbAggregate.select(idx);
                }
            } else if (this.fCmbAggregate.getItemCount() > 0) {
                this.fCmbAggregate.select(0);
            }
            aggFuncName = ((String[])this.fCmbAggregate.getData())[this.fCmbAggregate.getSelectionIndex()];
            this.showAggregateParameters(aggFuncName);
        }

        private int getAggregateIndexByName(String name) {
            String[] names = (String[])this.fCmbAggregate.getData();
            int i = 0;
            while (i < names.length) {
                if (name.equals(names[i])) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        private void showAggregateParameters(String aggFuncName) {
            Control[] children = this.fAggParameterComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
            this.fAggParamtersTextWidgets.clear();
            this.fExprBuilderWidgetsMap.clear();
            IAggregateFunction aFunc = null;
            try {
                if (aggFuncName != null && !AggregateEditorComposite.AGG_FUNC_NONE.equals(aggFuncName)) {
                    aFunc = PluginSettings.instance().getAggregateFunction(aggFuncName);
                }
            }
            catch (ChartException chartException) {}
            String[] args = null;
            if (aFunc != null) {
                args = aFunc.getDisplayParameters();
            }
            if (aFunc != null && args != null && args.length > 0) {
                ((GridData)this.fAggParameterComposite.getLayoutData()).exclude = false;
                ((GridData)this.fAggParameterComposite.getLayoutData()).heightHint = -1;
                int i2 = 0;
                while (i2 < args.length) {
                    Label lblArg = new Label(this.fAggParameterComposite, 0);
                    lblArg.setText(String.valueOf(args[i2]) + ":");
                    GridData gd = new GridData();
                    lblArg.setLayoutData((Object)gd);
                    Text txtArg = new Text(this.fAggParameterComposite, 2048);
                    GridData gridData = new GridData(768);
                    gridData.horizontalIndent = 0;
                    txtArg.setLayoutData((Object)gridData);
                    this.fAggParamtersTextWidgets.add(txtArg);
                    txtArg.addSelectionListener((SelectionListener)this);
                    txtArg.addListener(16, (Listener)this);
                    txtArg.addListener(31, (Listener)this);
                    txtArg.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            AggregateDropDownEditorComposite.this.setAggParameter((Text)e.getSource());
                        }
                    });
                    txtArg.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            AggregateDropDownEditorComposite.this.setAggParameter((Text)e.getSource());
                        }
                    });
                    Button btnBuilder = new Button(this.fAggParameterComposite, 8);
                    this.fExprBuilderWidgetsMap.put(btnBuilder, txtArg);
                    GridData gdBTNBuilder = new GridData();
                    ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gdBTNBuilder);
                    btnBuilder.setLayoutData((Object)gdBTNBuilder);
                    btnBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
                    btnBuilder.setToolTipText(Messages.getString("DataDefinitionComposite.Tooltip.InvokeExpressionBuilder"));
                    btnBuilder.getImage().setBackground(btnBuilder.getBackground());
                    btnBuilder.setEnabled(AggregateEditorComposite.this.fChartContext.getUIServiceProvider().isInvokingSupported());
                    btnBuilder.setVisible(AggregateEditorComposite.this.fChartContext.getUIServiceProvider().isEclipseModeSupported());
                    btnBuilder.addSelectionListener((SelectionListener)this);
                    btnBuilder.addListener(16, (Listener)this);
                    btnBuilder.addListener(31, (Listener)this);
                    ++i2;
                }
            } else {
                ((GridData)this.fAggParameterComposite.getLayoutData()).heightHint = 0;
            }
            this.fAggParameterComposite.layout();
            this.fCmpAggregate.layout();
            Composite c = this.fAggParameterComposite;
            while (c != this.getShell()) {
                c.layout();
                c = c.getParent();
            }
            this.getShell().pack();
            this.populateAggParameters();
        }

        private void setAggParameter(Text oSource) {
            String text = oSource.getText();
            int index = this.fAggParamtersTextWidgets.indexOf(oSource);
            EList parameters = AggregateEditorComposite.this.fGrouping.getAggregateParameters();
            int i = parameters.size();
            while (i < this.fAggParamtersTextWidgets.size()) {
                parameters.add(null);
                ++i;
            }
            parameters.set(index, (Object)text);
        }

        private void populateAggParameters() {
            SeriesGrouping grouping = AggregateEditorComposite.this.fGrouping;
            EList aggPars = grouping.getAggregateParameters();
            if (aggPars.size() > 0) {
                int size = aggPars.size() > this.fAggParamtersTextWidgets.size() ? this.fAggParamtersTextWidgets.size() : aggPars.size();
                int i = 0;
                while (i < size) {
                    String value = (String)aggPars.get(i);
                    if (value != null) {
                        this.fAggParamtersTextWidgets.get(i).setText(value);
                    }
                    ++i;
                }
            }
        }

        private void setAggregatesState() {
            if (AggregateEditorComposite.this.isSetAggregate()) {
                int i = 0;
                while (i < this.fAggParamtersTextWidgets.size()) {
                    this.fAggParamtersTextWidgets.get(i).setEnabled(true);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.fAggParamtersTextWidgets.size()) {
                    this.fAggParamtersTextWidgets.get(i).setEnabled(false);
                    ++i;
                }
            }
        }

        private boolean isAggParametersWidget(Object source) {
            return this.fAggParamtersTextWidgets.contains(source);
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == this.fCmbAggregate) {
                String aggFunc = ((String[])this.fCmbAggregate.getData())[this.fCmbAggregate.getSelectionIndex()];
                this.showAggregateParameters(aggFunc);
                if (AggregateEditorComposite.AGG_FUNC_NONE.equals(aggFunc)) {
                    AggregateEditorComposite.this.fGrouping.setEnabled(false);
                    AggregateEditorComposite.this.fGrouping.setAggregateExpression(null);
                } else {
                    AggregateEditorComposite.this.fGrouping.setEnabled(true);
                    AggregateEditorComposite.this.fGrouping.setAggregateExpression(aggFunc);
                }
            } else if (this.isAggParametersWidget(source)) {
                this.setAggParameter((Text)source);
            } else if (this.isBuilderBtnWidget(source)) {
                try {
                    Text txtArg = this.fExprBuilderWidgetsMap.get(source);
                    String sExpr = AggregateEditorComposite.this.fChartContext.getUIServiceProvider().invoke(1, txtArg.getText(), AggregateEditorComposite.this.fChartContext.getExtendedItem(), this.fTitle);
                    txtArg.setText(sExpr);
                    this.setAggParameter(txtArg);
                }
                catch (ChartException e1) {
                    WizardBase.displayException((Throwable)e1);
                }
            } else if (source == this.fBtnOK) {
                if (AggregateEditorComposite.this.query != null) {
                    AggregateEditorComposite.this.query.setGrouping(AggregateEditorComposite.this.fGrouping);
                    AggregateEditorComposite.this.query.getGrouping().eAdapters().addAll((Collection)AggregateEditorComposite.this.query.eAdapters());
                    if (AggregateEditorComposite.this.fSeriesDefi != null) {
                        AggregateEditorComposite.this.fSeriesDefi.setGrouping(null);
                    }
                } else {
                    AggregateEditorComposite.this.fSeriesDefi.setGrouping(AggregateEditorComposite.this.fGrouping);
                    AggregateEditorComposite.this.fSeriesDefi.getGrouping().eAdapters().addAll((Collection)AggregateEditorComposite.this.fSeriesDefi.eAdapters());
                }
                ChartUIUtil.checkAggregateType((ChartWizardContext)AggregateEditorComposite.this.fChartContext);
                DataDefinitionTextManager.getInstance().updateTooltip();
                AggregateEditorComposite.this.closeAggregateEditor(this.getShell());
            } else if (source == this.fBtnCancel) {
                AggregateEditorComposite.this.closeAggregateEditor(this.getShell());
            }
        }

        private boolean isBuilderBtnWidget(Object source) {
            return this.fExprBuilderWidgetsMap.containsKey(source);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void paintControl(PaintEvent e) {
        }
    }

    static class AggregationAction
    extends Action {
        public AggregationAction(boolean enabled) {
            super("", 4);
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)UIHelper.getURL((String)"icons/obj16/sigma.gif")));
            this.setEnabled(enabled);
        }
    }
}

