/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.ArrayList;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierComposite;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FormatSpecifierDialog
extends TrayDialog {
    private transient FormatSpecifierComposite editor = null;
    private transient FormatSpecifier formatspecifier = null;
    private AxisType[] axisTypes = null;

    public FormatSpecifierDialog(Shell shellParent, FormatSpecifier formatspecifier, String sTitle) {
        super(shellParent);
        this.setHelpAvailable(false);
        if (formatspecifier != null) {
            this.formatspecifier = formatspecifier.copyInstance();
        }
    }

    public FormatSpecifierDialog(Shell shellParent, FormatSpecifier formatspecifier, AxisType axisType, String sTitle) {
        this(shellParent, formatspecifier, new AxisType[]{axisType}, sTitle);
    }

    public FormatSpecifierDialog(Shell shellParent, FormatSpecifier formatspecifier, AxisType[] axisTypes, String sTitle) {
        this(shellParent, formatspecifier, sTitle);
        this.axisTypes = axisTypes != null && axisTypes.length == 1 && axisTypes[0] == null ? null : axisTypes;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
    }

    protected Control createContents(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatData_ID");
        this.getShell().setText(Messages.getString("FormatSpecifierDialog.Title.EditFormat"));
        UIHelper.centerOnScreen((Shell)this.getShell());
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.axisTypes == null) {
            this.editor = new FormatSpecifierComposite(parent, 0, this.formatspecifier);
        } else {
            ArrayList<String> supportedList = new ArrayList<String>();
            int i = 0;
            while (i < this.axisTypes.length) {
                String type = this.getSupportedType(this.axisTypes[i]);
                if (!supportedList.contains(type)) {
                    supportedList.add(type);
                }
                ++i;
            }
            this.editor = new FormatSpecifierComposite(parent, 0, this.formatspecifier, supportedList.toArray(new String[supportedList.size()]));
        }
        GridData gdEditor = new GridData(1808);
        this.editor.setLayoutData(gdEditor);
        return this.editor;
    }

    public FormatSpecifier getFormatSpecifier() {
        return this.formatspecifier;
    }

    protected void okPressed() {
        this.formatspecifier = this.editor.getFormatSpecifier();
        super.okPressed();
    }

    String getSupportedType(AxisType axisType) {
        if (axisType == AxisType.DATE_TIME_LITERAL) {
            return FormatSpecifierComposite.DATA_TYPE_DATETIME;
        }
        if (axisType == AxisType.LINEAR_LITERAL || axisType == AxisType.LOGARITHMIC_LITERAL) {
            return FormatSpecifierComposite.DATA_TYPE_NUMBER;
        }
        if (axisType == AxisType.TEXT_LITERAL) {
            return FormatSpecifierComposite.DATA_TYPE_STRING;
        }
        return FormatSpecifierComposite.DATA_TYPE_NONE;
    }
}

