/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.launching.AcceleoMainMethodSearchEngine;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AcceleoApplicationLaunchShortcut
extends JavaLaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IJavaElement je = (IJavaElement)input.getAdapter(IJavaElement.class);
        if (je != null) {
            super.launch(editor, mode);
        } else {
            IFile mtlFile = (IFile)input.getAdapter(IFile.class);
            IFile javaFile = this.findJavaFileForMTLFile(mtlFile);
            if (javaFile != null) {
                StructuredSelection selection = new StructuredSelection((Object)javaFile);
                this.launch((ISelection)selection, mode);
            }
        }
    }

    private IJavaElement[] getJavaElements(Object[] objects) {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(objects.length);
        int i = 0;
        while (i < objects.length) {
            IJavaElement element;
            Object object = objects[i];
            if (object instanceof IFile && "mtl".equals(((IFile)object).getFileExtension())) {
                object = this.findJavaFileForMTLFile((IFile)object);
            }
            if (object instanceof IAdaptable && (element = (IJavaElement)((IAdaptable)object).getAdapter(IJavaElement.class)) != null) {
                if (element instanceof IMember && ((IMember)element).getDeclaringType() != null) {
                    element = ((IMember)element).getDeclaringType();
                }
                list.add(element);
            }
            ++i;
        }
        return list.toArray(new IJavaElement[list.size()]);
    }

    private IFile findJavaFileForMTLFile(IFile mtlFile) {
        if (!"mtl".equals(mtlFile.getFileExtension())) {
            throw new IllegalArgumentException();
        }
        try {
            String name1 = new Path(mtlFile.getName()).removeFileExtension().lastSegment().toLowerCase();
            IResource[] members = mtlFile.getParent().members();
            IFile javaFile = null;
            int j = 0;
            while (j < members.length && javaFile == null) {
                String name2;
                IResource resource = members[j];
                if (resource != mtlFile && resource instanceof IFile && "java".equals(((IFile)resource).getFileExtension()) && name1.equals(name2 = new Path(((IFile)resource).getName()).removeFileExtension().lastSegment().toLowerCase())) {
                    javaFile = (IFile)resource;
                }
                ++j;
            }
            if (javaFile == null) {
                javaFile = mtlFile.getParent().getFile(new Path(mtlFile.getName()).removeFileExtension().addFileExtension("java"));
            }
            if (javaFile != null && javaFile.exists()) {
                return javaFile;
            }
        }
        catch (CoreException e) {
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
            config = wc.doSave();
            StructuredSelection selection = config == null ? new StructuredSelection() : new StructuredSelection((Object)config);
            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)selection, (String)"org.eclipse.debug.ui.launchGroup.run");
        }
        catch (CoreException e) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                MessageDialog.openError((Shell)window.getShell(), (String)AcceleoUIMessages.getString("AcceleoApplicationLaunchShortcut.Error"), (String)e.getStatus().getMessage());
            }
            AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
        }
        return config;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.acceleo.ide.ui.launching.launchConfigurationType");
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        try {
            IType type;
            if (elements.length == 1 && (type = this.isMainMethod(elements[0])) != null) {
                return new IType[]{type};
            }
            IJavaElement[] javaElements = this.getJavaElements(elements);
            AcceleoMainMethodSearchEngine engine = new AcceleoMainMethodSearchEngine();
            int constraints = 1;
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (int)(constraints |= 2));
            return engine.searchMainMethods(context, scope, true);
        }
        catch (InvocationTargetException e) {
            throw (CoreException)e.getTargetException();
        }
    }

    private IType isMainMethod(Object o) {
        IAdaptable adapt;
        IJavaElement element;
        if (o instanceof IAdaptable && (element = (IJavaElement)(adapt = (IAdaptable)o).getAdapter(IJavaElement.class)) != null && element.getElementType() == 9) {
            try {
                IMethod method = (IMethod)element;
                if (method.isMainMethod()) {
                    return method.getDeclaringType();
                }
            }
            catch (JavaModelException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
        return null;
    }

    protected String getTypeSelectionTitle() {
        return AcceleoUIMessages.getString("AcceleoApplicationLaunchShortcut.getTypeSelectionTitle");
    }

    protected String getEditorEmptyMessage() {
        return AcceleoUIMessages.getString("AcceleoApplicationLaunchShortcut.getEditorEmptyMessage");
    }

    protected String getSelectionEmptyMessage() {
        return AcceleoUIMessages.getString("AcceleoApplicationLaunchShortcut.getSelectionEmptyMessage");
    }
}

