/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultModelRepository;
import java.util.Map;
import org.gradle.internal.Factory;

public final class DefaultModelRepositoryProvider
implements ModelRepositoryProvider {
    private final ToolingClient toolingClient;
    private final Factory<EventBus> eventBusFactory;
    private final Map<FixedRequestAttributes, ModelRepository> modelRepositories;

    public DefaultModelRepositoryProvider(ToolingClient toolingClient) {
        this(toolingClient, DefaultEventBusFactory.INSTANCE);
    }

    public DefaultModelRepositoryProvider(ToolingClient toolingClient, Factory<EventBus> eventBusFactory) {
        this.toolingClient = (ToolingClient)Preconditions.checkNotNull((Object)toolingClient);
        this.eventBusFactory = (Factory)Preconditions.checkNotNull(eventBusFactory);
        this.modelRepositories = Maps.newHashMap();
    }

    @Override
    public ModelRepository getModelRepository(FixedRequestAttributes fixedRequestAttributes) {
        Preconditions.checkNotNull((Object)fixedRequestAttributes);
        return this.getOrCreateModelRepository(fixedRequestAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelRepository getOrCreateModelRepository(FixedRequestAttributes fixedRequestAttributes) {
        ModelRepository modelRepository;
        Map<FixedRequestAttributes, ModelRepository> map = this.modelRepositories;
        synchronized (map) {
            if (!this.modelRepositories.containsKey(fixedRequestAttributes)) {
                modelRepository = new DefaultModelRepository(fixedRequestAttributes, this.toolingClient, (EventBus)this.eventBusFactory.create());
                this.modelRepositories.put(fixedRequestAttributes, modelRepository);
            } else {
                modelRepository = this.modelRepositories.get(fixedRequestAttributes);
            }
        }
        return modelRepository;
    }

    private static enum DefaultEventBusFactory implements Factory<EventBus>
    {
        INSTANCE;


        public EventBus create() {
            return new EventBus();
        }
    }
}

