/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.buildship.core.workspace.internal.ManagedModelMergingStrategy;
import org.eclipse.buildship.core.workspace.internal.PersistentModelBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

final class ProjectNatureUpdater {
    private ProjectNatureUpdater() {
    }

    public static void update(IProject project, Optional<List<OmniEclipseProjectNature>> projectNatures, PersistentModelBuilder persistentModel, IProgressMonitor monitor) throws CoreException {
        PersistentModel previousPersistentModel = persistentModel.getPrevious();
        LinkedHashSet managedNatures = previousPersistentModel.isPresent() ? Sets.newLinkedHashSet(previousPersistentModel.getManagedNatures()) : Sets.newLinkedHashSet();
        Set<String> modelNatures = ProjectNatureUpdater.toNatures(projectNatures);
        IProjectDescription description = project.getDescription();
        LinkedHashSet existingNatures = Sets.newLinkedHashSet(Arrays.asList(description.getNatureIds()));
        ManagedModelMergingStrategy.Result<String> result = ManagedModelMergingStrategy.calculate(existingNatures, modelNatures, managedNatures);
        description.setNatureIds(result.getNextElements().toArray(new String[0]));
        project.setDescription(description, monitor);
        persistentModel.managedNatures(result.getNextManaged());
    }

    private static Set<String> toNatures(Optional<List<OmniEclipseProjectNature>> projectNatures) {
        LinkedHashSet natures = Sets.newLinkedHashSet();
        if (projectNatures.isPresent()) {
            natures.addAll(ProjectNatureUpdater.toNatures((List)projectNatures.get()));
        }
        natures.add("org.eclipse.buildship.core.gradleprojectnature");
        return natures;
    }

    private static Set<? extends String> toNatures(List<OmniEclipseProjectNature> projectNatures) {
        LinkedHashSet natures = Sets.newLinkedHashSet();
        for (OmniEclipseProjectNature projectNature : projectNatures) {
            String id = projectNature.getId();
            if (!CorePlugin.workspaceOperations().isNatureRecognizedByEclipse(id)) continue;
            natures.add(id);
        }
        return natures;
    }
}

