/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.macro.file.MutableFileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.generator.FileSystemAccessQueue;
import org.eclipse.xtext.xbase.lib.Extension;

public class ParallelFileSystemSupport
implements MutableFileSystemSupport {
    private final URI uri;
    private final MutableFileSystemSupport delegate;
    @Extension
    private final FileSystemAccessQueue queue;

    public ParallelFileSystemSupport(URI uri, MutableFileSystemSupport delegate, FileSystemAccessQueue queue) {
        this.uri = uri;
        this.delegate = delegate;
        this.queue = queue;
    }

    public void delete(Path path) {
        Runnable _function = () -> this.delegate.delete(path);
        this.queue.sendAsync(this.uri, _function);
    }

    @Deprecated
    public void mkdir(Path path) {
        Runnable _function = () -> this.delegate.mkdir(path);
        this.queue.sendAsync(this.uri, _function);
    }

    public void setContents(Path path, CharSequence contents) {
        Runnable _function = () -> this.delegate.setContents(path, contents);
        this.queue.sendAsync(this.uri, _function);
    }

    public void setContentsAsStream(Path path, InputStream source) {
        Runnable _function = () -> this.delegate.setContentsAsStream(path, source);
        this.queue.sendAsync(this.uri, _function);
    }

    public boolean exists(Path path) {
        boolean _xblockexpression = false;
        this.queue.waitForEmptyQueue();
        _xblockexpression = this.delegate.exists(path);
        return _xblockexpression;
    }

    public String getCharset(Path path) {
        String _xblockexpression = null;
        this.queue.waitForEmptyQueue();
        _xblockexpression = this.delegate.getCharset(path);
        return _xblockexpression;
    }

    public Iterable<? extends Path> getChildren(Path path) {
        Iterable _xblockexpression = null;
        this.queue.waitForEmptyQueue();
        _xblockexpression = this.delegate.getChildren(path);
        return _xblockexpression;
    }

    public CharSequence getContents(Path path) {
        CharSequence _xblockexpression = null;
        this.queue.waitForEmptyQueue();
        _xblockexpression = this.delegate.getContents(path);
        return _xblockexpression;
    }

    public InputStream getContentsAsStream(Path path) {
        InputStream _xblockexpression = null;
        this.queue.waitForEmptyQueue();
        _xblockexpression = this.delegate.getContentsAsStream(path);
        return _xblockexpression;
    }

    public long getLastModification(Path path) {
        long _xblockexpression = 0L;
        this.queue.waitForEmptyQueue();
        _xblockexpression = this.delegate.getLastModification(path);
        return _xblockexpression;
    }

    public boolean isFile(Path path) {
        boolean _xblockexpression = false;
        this.queue.waitForEmptyQueue();
        _xblockexpression = this.delegate.isFile(path);
        return _xblockexpression;
    }

    public boolean isFolder(Path path) {
        boolean _xblockexpression = false;
        this.queue.waitForEmptyQueue();
        _xblockexpression = this.delegate.isFolder(path);
        return _xblockexpression;
    }

    public java.net.URI toURI(Path path) {
        java.net.URI _xblockexpression = null;
        this.queue.waitForEmptyQueue();
        _xblockexpression = this.delegate.toURI(path);
        return _xblockexpression;
    }
}

