/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.internal.ChartLayout;
import org.eclipse.swtchart.internal.ChartLayoutData;
import org.eclipse.swtchart.internal.ChartTitle;
import org.eclipse.swtchart.internal.Legend;
import org.eclipse.swtchart.internal.PlotArea;
import org.eclipse.swtchart.internal.Title;
import org.eclipse.swtchart.internal.axis.AxisSet;
import org.eclipse.swtchart.internal.series.SeriesSet;

public class Chart
extends Composite
implements Listener {
    public static final int NO_AXIS_POSITION_UPDATE = 0x40000000;
    protected SeriesSet seriesSet;
    private final Title title;
    private final Legend legend;
    private final AxisSet axisSet;
    private IPlotArea plotArea;
    private int orientation = 256;
    private boolean compressEnabled = true;
    private boolean updateSuspended = false;
    private final List<PaintListener> paintListener = new ArrayList<PaintListener>();

    public Chart(Composite parent, int style) {
        this(parent, style, null);
        this.plotArea = new PlotArea(this, 0);
        if ((style & 0x40000000) != 0x40000000) {
            this.plotArea.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    IAxis[] iAxisArray = Chart.this.axisSet.getAxes();
                    int n = iAxisArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAxis axis = iAxisArray[n2];
                        axis.updatePositionMarker(e);
                        ++n2;
                    }
                    Chart.this.redraw();
                }
            });
        }
        this.setData("org.eclipse.e4.ui.css.CssClassName", "Chart");
    }

    public Chart(Composite parent, int style, Void justNull) {
        super(parent, style | 0x20000000);
        parent.layout();
        this.setLayout(new ChartLayout());
        this.seriesSet = new SeriesSet(this);
        this.title = new ChartTitle(this);
        this.title.setLayoutData(new ChartLayoutData(-1, 100));
        this.legend = new Legend(this, 0);
        this.legend.setLayoutData(new ChartLayoutData(200, -1));
        this.axisSet = new AxisSet(this);
        this.addListener(11, this);
    }

    public ITitle getTitle() {
        return this.title;
    }

    public ILegend getLegend() {
        return this.legend;
    }

    public IAxisSet getAxisSet() {
        return this.axisSet;
    }

    public IPlotArea getPlotArea() {
        return this.plotArea;
    }

    public void setPlotArea(IPlotArea area) {
        this.plotArea = area;
        this.updateLayout();
    }

    public ISeriesSet getSeriesSet() {
        return this.seriesSet;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!(child instanceof IPlotArea) && !(child instanceof Legend)) {
                child.setBackground(color);
            }
            ++n2;
        }
    }

    @Deprecated
    public Color getBackgroundInPlotArea() {
        return this.getPlotArea().getBackground();
    }

    @Deprecated
    public void setBackgroundInPlotArea(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.getPlotArea().setBackground(color);
    }

    public void setOrientation(int orientation) {
        if (orientation == 256 || orientation == 512) {
            this.orientation = orientation;
        }
        this.updateLayout();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void enableCompress(boolean enabled) {
        this.compressEnabled = enabled;
    }

    public boolean isCompressEnabled() {
        return this.compressEnabled;
    }

    public void suspendUpdate(boolean suspend) {
        if (this.updateSuspended == suspend) {
            return;
        }
        this.updateSuspended = suspend;
        if (!suspend) {
            this.updateLayout();
            ((SeriesSet)this.getSeriesSet()).updateStackAndRiserData();
        }
    }

    public boolean isUpdateSuspended() {
        return this.updateSuspended;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 11: {
                this.updateLayout();
                this.redraw();
                break;
            }
        }
    }

    public void updateLayout() {
        if (this.updateSuspended) {
            return;
        }
        if (this.legend != null) {
            this.legend.updateLayoutData();
        }
        if (this.title != null) {
            this.title.updateLayoutData();
        }
        if (this.axisSet != null) {
            this.axisSet.updateLayoutData();
        }
        this.layout();
        if (this.axisSet != null) {
            this.axisSet.refresh();
        }
    }

    public void update() {
        super.update();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.update();
            ++n2;
        }
    }

    public void dispose() {
        this.title.dispose();
        this.legend.dispose();
        this.axisSet.dispose();
        super.dispose();
    }

    public void redraw() {
        super.redraw();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.redraw();
            ++n2;
        }
    }

    public void save(String filename, int format) {
        Rectangle bounds = this.getBounds();
        Image image = new Image((Device)Display.getDefault(), bounds.width, bounds.height);
        GC gc = new GC((Drawable)image);
        this.print(gc);
        gc.dispose();
        ImageData data = image.getImageData();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{data};
        loader.save(filename, format);
        image.dispose();
    }

    public void renderOffscreenImage(Image image) {
        GC gc = new GC((Drawable)image);
        this.print(gc);
        gc.dispose();
    }

    public void printChart(GC gc, Rectangle clientArea) {
        Transform oldTransform = new Transform(gc.getDevice());
        try {
            gc.getTransform(oldTransform);
            Point oldSize = this.getSize();
            try {
                this.setSize(clientArea.width, clientArea.height);
                Event e = new Event();
                e.gc = gc;
                e.widget = this;
                PaintEvent paintEvent = new PaintEvent(e);
                Control[] controlArray = this.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    Rectangle bounds = child.getBounds();
                    if (child instanceof PaintListener) {
                        Event subEvent = new Event();
                        subEvent.gc = gc;
                        subEvent.widget = child;
                        Rectangle oldClipping = gc.getClipping();
                        try {
                            gc.setClipping(bounds);
                            PaintEvent subPaint = new PaintEvent(subEvent);
                            Transform transform = new Transform(gc.getDevice());
                            try {
                                transform.translate((float)bounds.x, (float)bounds.y);
                                gc.setTransform(transform);
                                ((PaintListener)child).paintControl(subPaint);
                            }
                            finally {
                                transform.dispose();
                                gc.setTransform(oldTransform);
                            }
                        }
                        finally {
                            gc.setClipping(oldClipping);
                        }
                    }
                    ++n2;
                }
                for (PaintListener listener : this.paintListener) {
                    listener.paintControl(paintEvent);
                }
            }
            finally {
                this.setSize(oldSize);
            }
        }
        finally {
            oldTransform.dispose();
        }
    }

    public void addPaintListener(PaintListener listener) {
        this.paintListener.add(listener);
        super.addPaintListener(listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.paintListener.remove(listener);
        super.removePaintListener(listener);
    }
}

