/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.layout;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceElementQuery;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.ext.base.Option;

public class EventEndToPositionFunction
implements Function<EventEnd, Integer> {
    private final Function<EventEnd, Collection<ISequenceEvent>> eventEndToSequenceEvents;
    private final Function<ISequenceEvent, Option<Range>> ranges;

    public EventEndToPositionFunction(Function<EventEnd, Collection<ISequenceEvent>> eventEndToSequenceEvents, Function<ISequenceEvent, Option<Range>> ranges) {
        this.eventEndToSequenceEvents = eventEndToSequenceEvents;
        this.ranges = ranges;
    }

    public Integer apply(EventEnd from) {
        return this.getOldPosition(from, (Collection)this.eventEndToSequenceEvents.apply((Object)from));
    }

    private Integer getOldPosition(EventEnd end, Collection<ISequenceEvent> ises) {
        SingleEventEnd see = null;
        ISequenceEvent ise = null;
        if (end instanceof SingleEventEnd && !ises.isEmpty()) {
            see = (SingleEventEnd)end;
            ise = ises.iterator().next();
        } else if (end instanceof CompoundEventEnd && !ises.isEmpty()) {
            CompoundEventEnd cee = (CompoundEventEnd)end;
            if (EventEndHelper.PUNCTUAL_COMPOUND_EVENT_END.apply((Object)cee)) {
                ise = this.getSafeEvent(ises);
            } else {
                ise = this.getSafeEvent(ises);
                see = ise == null ? null : EventEndHelper.getSingleEventEnd(end, ((DDiagramElement)ise.getNotationView().getElement()).getTarget());
            }
        }
        return this.getOldPositionFromRange(see, ise);
    }

    private ISequenceEvent getSafeEvent(Collection<ISequenceEvent> ises) {
        ISequenceEvent ise = null;
        Predicate safe = Predicates.or((Predicate)Predicates.instanceOf(AbstractNodeEvent.class), (Predicate)Predicates.instanceOf(AbstractFrame.class));
        Iterable safeEvents = Iterables.filter(ises, (Predicate)safe);
        ise = !Iterables.isEmpty((Iterable)safeEvents) ? (ISequenceEvent)safeEvents.iterator().next() : (Iterables.size((Iterable)Iterables.filter(ises, Operand.class)) == 2 ? this.getSafeOperandEnd(ises) : ises.iterator().next());
        return ise;
    }

    private ISequenceEvent getSafeOperandEnd(Collection<ISequenceEvent> ises) {
        ISequenceEvent ise = null;
        Iterator<ISequenceEvent> iterator = ises.iterator();
        ISequenceEvent pot1 = iterator.next();
        ISequenceEvent pot2 = iterator.next();
        if (new ISequenceElementQuery(pot1).hasAbsoluteBoundsFlag()) {
            ise = pot1;
        } else if (new ISequenceElementQuery(pot2).hasAbsoluteBoundsFlag()) {
            ise = pot2;
        }
        return ise;
    }

    protected Integer getOldPositionFromRange(SingleEventEnd see, ISequenceEvent ise) {
        Integer oldPosition = 0;
        Option oldRange = (Option)this.ranges.apply((Object)ise);
        if (ise != null && oldRange.some()) {
            if (see != null) {
                oldPosition = see.isStart() ? ((Range)oldRange.get()).getLowerBound() : ((Range)oldRange.get()).getUpperBound();
            } else if (see == null && ise.isLogicallyInstantaneous()) {
                oldPosition = ((Range)oldRange.get()).middleValue();
            }
        }
        return oldPosition;
    }
}

