/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.filters.dialogs.SystemChangeFilterDialog;
import org.eclipse.swt.widgets.Shell;

public class SystemChangeFilterAction
extends SystemBaseDialogAction {
    private SystemChangeFilterDialog dlg = null;
    private String dlgTitle = null;
    private SystemFilterStringEditPane editPane;

    public SystemChangeFilterAction(Shell parent) {
        this(parent, SystemResources.ACTION_UPDATEFILTER_LABEL, SystemResources.ACTION_UPDATEFILTER_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.editfilterIcon"));
    }

    public SystemChangeFilterAction(Shell parent, String label, String tooltip) {
        this(parent, label, tooltip, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.editfilterIcon"));
    }

    public SystemChangeFilterAction(Shell parent, String label, String tooltip, ImageDescriptor image) {
        super(label, tooltip, image, parent);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.change");
        this.setHelp("org.eclipse.rse.ui.acfr0000");
    }

    public void setHelpContextId(String id) {
        this.setHelp(id);
    }

    public void setDialogTitle(String title) {
        this.dlgTitle = title;
    }

    public void setDialogHelpContextId(String id) {
        this.setDialogHelp(id);
    }

    public void setFilterStringEditPane(SystemFilterStringEditPane editPane) {
        this.editPane = editPane;
    }

    public SystemFilterStringEditPane getFilterStringEditPane() {
        return this.editPane;
    }

    public boolean checkObjectType(Object selectedObject) {
        if (selectedObject instanceof ISystemFilter) {
            return !((ISystemFilter)selectedObject).isNonChangable();
        }
        if (selectedObject instanceof ISystemFilterReference) {
            return !((ISystemFilterReference)selectedObject).getReferencedFilter().isNonChangable();
        }
        return false;
    }

    public Dialog createDialog(Shell shell) {
        this.dlg = this.getFilterDialog(shell);
        this.dlg.setSystemFilterPoolReferenceManagerProvider(this.getSystemFilterPoolReferenceManagerProvider());
        this.dlg.setSystemFilterPoolManagerProvider(this.getSystemFilterPoolManagerProvider());
        if (this.editPane != null) {
            this.dlg.setFilterStringEditPane(this.editPane);
        }
        this.configureFilterDialog(this.dlg);
        ISystemFilter filter = this.getSelectedFilter();
        if (filter != null && filter.isSingleFilterStringOnly()) {
            this.dlg.setSupportsMultipleStrings(false);
        }
        return this.dlg;
    }

    protected SystemChangeFilterDialog getFilterDialog(Shell shell) {
        if (this.dlgTitle == null) {
            return new SystemChangeFilterDialog(shell);
        }
        return new SystemChangeFilterDialog(shell, this.dlgTitle);
    }

    public void callConfigureFilterDialog(SystemChangeFilterDialog dlg) {
        this.configureFilterDialog(dlg);
    }

    protected void configureFilterDialog(SystemChangeFilterDialog dlg) {
        Shell shell = dlg.getShell();
        if (shell == null) {
            shell = dlg.getParentShell();
        }
    }

    protected Object getDialogValue(Dialog dlg) {
        return null;
    }

    public ISystemFilterPoolReferenceManagerProvider getSystemFilterPoolReferenceManagerProvider() {
        Object firstSelection = this.getFirstSelection();
        if (firstSelection != null) {
            if (firstSelection instanceof ISystemFilterReference) {
                return ((ISystemFilterReference)firstSelection).getProvider();
            }
            if (firstSelection instanceof ISystemFilterPoolReference) {
                return ((ISystemFilterPoolReference)firstSelection).getProvider();
            }
            if (firstSelection instanceof ISystemFilterPoolReferenceManagerProvider) {
                return (ISystemFilterPoolReferenceManagerProvider)firstSelection;
            }
        }
        return null;
    }

    public ISystemFilterPoolManagerProvider getSystemFilterPoolManagerProvider() {
        Object firstSelection = this.getFirstSelection();
        if (firstSelection != null) {
            if (firstSelection instanceof ISystemFilterReference) {
                return ((ISystemFilterReference)firstSelection).getReferencedFilter().getProvider();
            }
            if (firstSelection instanceof ISystemFilter) {
                return ((ISystemFilter)firstSelection).getProvider();
            }
            if (firstSelection instanceof ISystemFilterPoolReference) {
                return ((ISystemFilterPoolReference)firstSelection).getReferencedFilterPool().getProvider();
            }
            if (firstSelection instanceof ISystemFilterPool) {
                return ((ISystemFilterPool)firstSelection).getProvider();
            }
            if (firstSelection instanceof ISystemFilterPoolManagerProvider) {
                return (ISystemFilterPoolManagerProvider)firstSelection;
            }
        }
        return null;
    }

    public ISystemFilter getSelectedFilter() {
        Object firstSelection = this.getFirstSelection();
        if (firstSelection != null) {
            if (firstSelection instanceof ISystemFilterReference) {
                return ((ISystemFilterReference)firstSelection).getReferencedFilter();
            }
            if (firstSelection instanceof ISystemFilter) {
                return (ISystemFilter)firstSelection;
            }
        }
        return null;
    }
}

