/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.uml.AnyType;
import org.eclipse.ocl.uml.InvalidType;
import org.eclipse.ocl.uml.MessageType;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.ocl.uml.TypeType;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.uml.UMLEnvironmentFactory;
import org.eclipse.ocl.uml.UMLFactory;
import org.eclipse.ocl.uml.UMLPackage;
import org.eclipse.ocl.uml.VoidType;
import org.eclipse.ocl.uml.internal.OCLFactoryImpl;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.util.UMLUtil;

public final class OCLStandardLibraryImpl
implements OCLStandardLibrary<Classifier> {
    private static final String NS_URI = "http://www.eclipse.org/ocl/1.1.0/oclstdlib.uml";
    private static final String ITERATOR_KEYWORD = "iterator";
    private static Classifier OCL_ANY;
    private static Classifier OCL_ELEMENT;
    private static Classifier OCL_BOOLEAN;
    private static Classifier OCL_INTEGER;
    private static Classifier OCL_UNLIMITED_NATURAL;
    private static Classifier OCL_REAL;
    private static Classifier OCL_STRING;
    private static Classifier OCL_VOID;
    private static Classifier OCL_MESSAGE;
    private static Classifier OCL_TYPE;
    private static Classifier OCL_INVALID;
    private static Classifier OCL_T;
    private static Classifier OCL_T2;
    private static Classifier OCL_SET;
    private static Classifier OCL_ORDERED_SET;
    private static Classifier OCL_BAG;
    private static Classifier OCL_SEQUENCE;
    private static Classifier OCL_COLLECTION;
    private static Classifier STATE;
    private static Classifier OCL_EXPRESSION;
    public static final OCLStandardLibraryImpl INSTANCE;
    public static Object INVALID;
    public static Package stdlibPackage;

    static {
        INSTANCE = new OCLStandardLibraryImpl();
        INVALID = org.eclipse.uml2.uml.UMLFactory.eINSTANCE.createInstanceSpecification();
        stdlibPackage = OCLStandardLibraryImpl.init();
    }

    private OCLStandardLibraryImpl() {
    }

    public Classifier getBoolean() {
        return OCL_BOOLEAN;
    }

    public Classifier getInteger() {
        return OCL_INTEGER;
    }

    public Classifier getUnlimitedNatural() {
        return OCL_UNLIMITED_NATURAL;
    }

    public Classifier getOclInvalid() {
        return OCL_INVALID;
    }

    public Classifier getReal() {
        return OCL_REAL;
    }

    public Classifier getString() {
        return OCL_STRING;
    }

    public Classifier getOclAny() {
        return OCL_ANY;
    }

    public Classifier getOclElement() {
        return OCL_ELEMENT;
    }

    public Object getInvalid() {
        return INVALID;
    }

    public Classifier getState() {
        return STATE;
    }

    public Classifier getOclMessage() {
        return OCL_MESSAGE;
    }

    public Classifier getOclType() {
        return OCL_TYPE;
    }

    public Classifier getOclVoid() {
        return OCL_VOID;
    }

    public Classifier getT() {
        return OCL_T;
    }

    public Classifier getT2() {
        return OCL_T2;
    }

    public Classifier getSet() {
        return OCL_SET;
    }

    public Classifier getOrderedSet() {
        return OCL_ORDERED_SET;
    }

    public Classifier getBag() {
        return OCL_BAG;
    }

    public Classifier getSequence() {
        return OCL_SEQUENCE;
    }

    public Classifier getCollection() {
        return OCL_COLLECTION;
    }

    public Classifier getOclExpression() {
        return OCL_EXPRESSION;
    }

    private static Package init() {
        if (stdlibPackage != null) {
            return stdlibPackage;
        }
        ResourceSetImpl rset = new ResourceSetImpl();
        OCL.initialize(null);
        Resource res = null;
        try {
            res = rset.getResource(URI.createURI((String)NS_URI), true);
            stdlibPackage = (Package)res.getContents().get(0);
            OCL_ANY = (Classifier)stdlibPackage.getOwnedType("OclAny");
            OCL_ELEMENT = (Classifier)stdlibPackage.getOwnedType("OclElement");
            OCL_BOOLEAN = (Classifier)stdlibPackage.getOwnedType("Boolean");
            OCL_INTEGER = (Classifier)stdlibPackage.getOwnedType("Integer");
            OCL_UNLIMITED_NATURAL = (Classifier)stdlibPackage.getOwnedType("UnlimitedNatural");
            OCL_REAL = (Classifier)stdlibPackage.getOwnedType("Real");
            OCL_STRING = (Classifier)stdlibPackage.getOwnedType("String");
            OCL_VOID = (Classifier)stdlibPackage.getOwnedType("OclVoid");
            OCL_MESSAGE = (Classifier)stdlibPackage.getOwnedType("OclMessage");
            OCL_INVALID = (Classifier)stdlibPackage.getOwnedType("OclInvalid");
            OCL_T = (Classifier)stdlibPackage.getOwnedType("T");
            OCL_T2 = (Classifier)stdlibPackage.getOwnedType("T2");
            OCL_TYPE = (Classifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getOwnedTypes(), (EClassifier)UMLPackage.Literals.TYPE_TYPE);
            OCL_SET = (Classifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getOwnedTypes(), (EClassifier)UMLPackage.Literals.SET_TYPE);
            OCL_ORDERED_SET = (Classifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getOwnedTypes(), (EClassifier)UMLPackage.Literals.ORDERED_SET_TYPE);
            OCL_BAG = (Classifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getOwnedTypes(), (EClassifier)UMLPackage.Literals.BAG_TYPE);
            OCL_SEQUENCE = (Classifier)EcoreUtil.getObjectByType((Collection)stdlibPackage.getOwnedTypes(), (EClassifier)UMLPackage.Literals.SEQUENCE_TYPE);
            OCL_COLLECTION = (Classifier)stdlibPackage.getOwnedType("Collection(T)");
            STATE = (Classifier)stdlibPackage.getOwnedType("State");
            OCL_EXPRESSION = (Classifier)stdlibPackage.getOwnedType("OclExpression");
            ((InstanceSpecification)INVALID).getClassifiers().add((Object)OCL_INVALID);
            ((InstanceSpecification)INVALID).setName("invalid");
            OCLStandardLibraryImpl.addToPackageRegistry(stdlibPackage);
            Package package_ = stdlibPackage;
            return package_;
        }
        catch (Exception e) {
            Package package_ = OCLStandardLibraryImpl.build();
            return package_;
        }
        finally {
            if (res != null) {
                rset.getResources().remove((Object)res);
            }
        }
    }

    private static Package build() {
        if (stdlibPackage != null) {
            return stdlibPackage;
        }
        stdlibPackage = org.eclipse.uml2.uml.UMLFactory.eINSTANCE.createPackage();
        stdlibPackage.setName("oclstdlib");
        Resource res = UMLResource.Factory.INSTANCE.createResource(URI.createURI((String)NS_URI));
        res.getContents().add((Object)stdlibPackage);
        Environment old = Environment.Registry.INSTANCE.getEnvironmentFor((Object)EcorePackage.Literals.ECLASS);
        Environment.Registry.INSTANCE.deregisterEnvironment(old);
        UMLEnvironment env = (UMLEnvironment)new UMLEnvironmentFactory().loadEnvironment(res);
        Environment.Registry.INSTANCE.registerEnvironment((Environment)env);
        OCL_ANY = UMLFactory.eINSTANCE.createAnyType();
        OCL_ELEMENT = UMLFactory.eINSTANCE.createElementType();
        OCL_BOOLEAN = UMLFactory.eINSTANCE.createPrimitiveType();
        OCL_BOOLEAN.setName("Boolean");
        OCL_INTEGER = UMLFactory.eINSTANCE.createPrimitiveType();
        OCL_INTEGER.setName("Integer");
        OCL_UNLIMITED_NATURAL = UMLFactory.eINSTANCE.createPrimitiveType();
        OCL_UNLIMITED_NATURAL.setName("UnlimitedNatural");
        OCL_REAL = UMLFactory.eINSTANCE.createPrimitiveType();
        OCL_REAL.setName("Real");
        OCL_STRING = UMLFactory.eINSTANCE.createPrimitiveType();
        OCL_STRING.setName("String");
        OCL_VOID = UMLFactory.eINSTANCE.createVoidType();
        OCL_MESSAGE = UMLFactory.eINSTANCE.createMessageType();
        OCL_INVALID = UMLFactory.eINSTANCE.createInvalidType();
        OCL_T = UMLFactory.eINSTANCE.createAnyType();
        OCL_T.setName("T");
        OCL_T2 = UMLFactory.eINSTANCE.createAnyType();
        OCL_T2.setName("T2");
        OCL_TYPE = (Classifier)OCLFactoryImpl.INSTANCE.createTypeType((Object)OCL_T);
        OCL_SET = (Classifier)OCLFactoryImpl.INSTANCE.createSetType((Object)OCL_T);
        OCL_ORDERED_SET = (Classifier)OCLFactoryImpl.INSTANCE.createOrderedSetType((Object)OCL_T);
        OCL_BAG = (Classifier)OCLFactoryImpl.INSTANCE.createBagType((Object)OCL_T);
        OCL_SEQUENCE = (Classifier)OCLFactoryImpl.INSTANCE.createSequenceType((Object)OCL_T);
        OCL_COLLECTION = (Classifier)OCLFactoryImpl.INSTANCE.createCollectionType((Object)OCL_T);
        STATE = UMLFactory.eINSTANCE.createElementType();
        STATE.setName("State");
        OCL_EXPRESSION = UMLFactory.eINSTANCE.createElementType();
        OCL_EXPRESSION.setName("OclExpression");
        ((InstanceSpecification)INVALID).getClassifiers().add((Object)OCL_INVALID);
        ((InstanceSpecification)INVALID).setName("invalid");
        OCLStandardLibraryImpl.register(OCL_ANY).addAll(OCLStandardLibraryUtil.createAnyTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_VOID).addAll(OCLStandardLibraryUtil.createAnyTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_INVALID).addAll(OCLStandardLibraryUtil.createAnyTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_BOOLEAN).addAll(OCLStandardLibraryUtil.createBooleanOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_INTEGER).addAll(OCLStandardLibraryUtil.createIntegerOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_UNLIMITED_NATURAL).addAll(OCLStandardLibraryUtil.createUnlimitedNaturalOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_REAL).addAll(OCLStandardLibraryUtil.createRealOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_STRING).addAll(OCLStandardLibraryUtil.createStringOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_TYPE).addAll(OCLStandardLibraryUtil.createTypeTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_MESSAGE).addAll(OCLStandardLibraryUtil.createMessageTypeOperations((Environment)env));
        OCLStandardLibraryImpl.register(OCL_ELEMENT);
        OCLStandardLibraryImpl.register(STATE);
        OCLStandardLibraryImpl.register(OCL_EXPRESSION);
        List<Operation> operations = OCLStandardLibraryImpl.register(OCL_COLLECTION);
        operations.addAll(OCLStandardLibraryUtil.createCollectionOperations((Environment)env));
        List iterators = OCLStandardLibraryUtil.createCollectionIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_SET);
        operations.addAll(OCLStandardLibraryUtil.createSetOperations((Environment)env));
        iterators = OCLStandardLibraryUtil.createSetIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_ORDERED_SET);
        operations.addAll(OCLStandardLibraryUtil.createOrderedSetOperations((Environment)env));
        iterators = OCLStandardLibraryUtil.createOrderedSetIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_BAG);
        operations.addAll(OCLStandardLibraryUtil.createBagOperations((Environment)env));
        iterators = OCLStandardLibraryUtil.createBagIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        operations = OCLStandardLibraryImpl.register(OCL_SEQUENCE);
        operations.addAll(OCLStandardLibraryUtil.createSequenceOperations((Environment)env));
        iterators = OCLStandardLibraryUtil.createSequenceIterators((Environment)env);
        OCLStandardLibraryImpl.stereotypeAsIterator(iterators);
        operations.addAll(iterators);
        OCLStandardLibraryImpl.register(OCL_T);
        OCLStandardLibraryImpl.register(OCL_T2);
        OCLStandardLibraryImpl.addToPackageRegistry(stdlibPackage);
        Environment.Registry.INSTANCE.registerEnvironment(old);
        return stdlibPackage;
    }

    private static void addToPackageRegistry(Package pkg) {
        EAnnotation ann = pkg.createEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
        Collection ecore = UMLUtil.convertToEcore((Package)pkg, null);
        ann.getContents().addAll(ecore);
        if (!ecore.isEmpty()) {
            EPackage epackage = (EPackage)ecore.iterator().next();
            epackage.setNsURI(pkg.eResource().getURI().toString());
            EPackage.Registry.INSTANCE.put((Object)epackage.getNsURI(), (Object)epackage);
        }
    }

    private static List<Operation> register(Classifier stdType) {
        EList<Operation> result = null;
        if (stdType instanceof DataType) {
            result = ((DataType)stdType).getOwnedOperations();
        } else if (stdType instanceof AnyType) {
            result = ((AnyType)stdType).getOwnedOperations();
        } else if (stdType instanceof InvalidType) {
            result = ((InvalidType)stdType).getOwnedOperations();
        } else if (stdType instanceof VoidType) {
            result = ((VoidType)stdType).getOwnedOperations();
        } else if (stdType instanceof MessageType) {
            result = ((MessageType)stdType).getOwnedOperations();
        } else if (stdType instanceof TypeType) {
            result = ((TypeType)stdType).getOwnedOperations();
        }
        stdlibPackage.getOwnedTypes().add((Object)stdType);
        return result;
    }

    public static Class findShadowClass(Classifier classifier, Package pkg) {
        for (Type next : pkg.getOwnedTypes()) {
            Class clazz;
            if (!(next instanceof Class) || OCLStandardLibraryImpl.getRealClassifier(clazz = (Class)next) != classifier) continue;
            return clazz;
        }
        return null;
    }

    public static Classifier getRealClassifier(Class shadow) {
        Substitution sub = shadow.getSubstitution("realOwner", null);
        return sub == null ? null : sub.getContract();
    }

    public static void stereotypeAsIterator(Collection<Operation> operations) {
        for (Operation oper : operations) {
            oper.addKeyword(ITERATOR_KEYWORD);
        }
    }

    public static EList<Operation> selectIterators(Collection<Operation> operations) {
        BasicEList.FastCompare result = new BasicEList.FastCompare();
        for (Operation oper : operations) {
            if (!oper.hasKeyword(ITERATOR_KEYWORD)) continue;
            result.add((Object)oper);
        }
        return result;
    }

    public static Collection<Operation> createCollectionTypeOperations(Environment<?, Classifier, Operation, ?, ?, Parameter, ?, ?, ?, ?, ?, ?> env, CollectionKind kind) {
        List iterators;
        List operations;
        switch (kind) {
            case BAG_LITERAL: {
                operations = OCLStandardLibraryUtil.createBagOperations(env);
                iterators = OCLStandardLibraryUtil.createBagIterators(env);
                break;
            }
            case SET_LITERAL: {
                operations = OCLStandardLibraryUtil.createSetOperations(env);
                iterators = OCLStandardLibraryUtil.createSetIterators(env);
                break;
            }
            case ORDERED_SET_LITERAL: {
                operations = OCLStandardLibraryUtil.createOrderedSetOperations(env);
                iterators = OCLStandardLibraryUtil.createOrderedSetIterators(env);
                break;
            }
            case SEQUENCE_LITERAL: {
                operations = OCLStandardLibraryUtil.createSequenceOperations(env);
                iterators = OCLStandardLibraryUtil.createSequenceIterators(env);
                break;
            }
            default: {
                operations = OCLStandardLibraryUtil.createCollectionOperations(env);
                iterators = OCLStandardLibraryUtil.createCollectionIterators(env);
            }
        }
        for (Operation next : iterators) {
            next.addKeyword(ITERATOR_KEYWORD);
        }
        ArrayList<Operation> result = new ArrayList<Operation>(operations.size() + iterators.size());
        result.addAll(operations);
        result.addAll(iterators);
        return result;
    }
}

