/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemLocationFactory;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IResource;

public class CommentChecker
extends AbstractIndexAstChecker {
    public static final String COMMENT_NO_LINE = "org.eclipse.cdt.codan.checkers.nolinecomment";
    public static final String COMMENT_NO_START = "org.eclipse.cdt.codan.checkers.nocommentinside";
    private boolean conly;

    public void processAst(IASTTranslationUnit ast) {
        IASTComment[] comments = ast.getComments();
        if (comments == null) {
            return;
        }
        boolean bl = this.conly = ast.getLinkage().getLinkageID() == 2;
        if (!this.conly && !this.shouldProduceProblem(this.getProblemById(COMMENT_NO_START, (IResource)this.getFile()), this.getFile().getFullPath())) {
            return;
        }
        IASTComment[] iASTCommentArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTComment comment = iASTCommentArray[n2];
            this.processComment(comment);
            ++n2;
        }
    }

    protected void processComment(IASTComment comment) {
        boolean blockComment = comment.isBlockComment();
        if (blockComment) {
            String commentStr = comment.getRawSignature();
            int pos = commentStr.indexOf("/*", 2);
            if (pos >= 0) {
                this.reportProblem(COMMENT_NO_START, this.getProblemLocation(comment.getFileLocation(), pos), new Object[0]);
            }
        } else if (this.conly) {
            this.reportProblem(COMMENT_NO_LINE, (IASTNode)comment, new Object[0]);
        }
    }

    private IProblemLocation getProblemLocation(IASTFileLocation astLocation, int pos) {
        IProblemLocationFactory locFactory = this.getRuntime().getProblemLocationFactory();
        int newPosition = astLocation.getNodeOffset() + pos;
        return locFactory.createProblemLocation(this.getFile(), newPosition, newPosition + 2, -1);
    }
}

