/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class GenerationCompareEditorInput
extends CompareEditorInput {
    private Map<URI, String> preview;
    private IContainer target;
    private boolean hasDifferences = false;
    private DiffNode diffRoot;

    public GenerationCompareEditorInput(CompareConfiguration configuration, Map<URI, String> preview, IContainer target) {
        super(configuration);
        configuration.setLeftEditable(false);
        Image acceleoImage = AcceleoUIPlugin.getDefault().getImageRegistry().get("AcceleoEditor");
        configuration.setLeftImage(acceleoImage);
        configuration.setLeftLabel("Acceleo generation");
        configuration.setRightEditable(true);
        Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        configuration.setRightImage(folderImage);
        configuration.setRightLabel("Workdspace");
        this.setTitle("Generation comparison");
        this.preview = preview;
        this.target = target;
        this.computeDiff();
    }

    private void computeDiff() {
        DiffNode res;
        NullProgressMonitor monitor = new NullProgressMonitor();
        HashSet<Object> knownResources = new HashSet<Object>();
        LinkedHashMap<IResource, DiffNode> nodes = new LinkedHashMap<IResource, DiffNode>();
        knownResources.add(this.target);
        for (Map.Entry<URI, String> entry : this.preview.entrySet()) {
            IFile file;
            URI uri = entry.getKey();
            String generatedContents = entry.getValue();
            IFile currentResource = file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.path()));
            while (currentResource != null && !knownResources.contains(currentResource)) {
                DiffNode diffNode;
                knownResources.add(currentResource);
                GeneratedResourceNode left = new GeneratedResourceNode(this.preview, (IResource)currentResource);
                CommitResourceNode right = new CommitResourceNode((IResource)currentResource, (IProgressMonitor)monitor);
                if (currentResource instanceof IContainer) {
                    diffNode = currentResource.exists() ? new DiffNode(0, null, (ITypedElement)left, (ITypedElement)right) : new DiffNode(1, null, (ITypedElement)left, (ITypedElement)right);
                    nodes.put((IResource)currentResource, diffNode);
                    currentResource = currentResource.getParent();
                    continue;
                }
                if (currentResource instanceof IFile) {
                    if (currentResource.exists()) {
                        String fileContent = null;
                        try {
                            Throwable throwable = null;
                            Object var15_18 = null;
                            try (InputStream inputStream = currentResource.getContents(true);){
                                fileContent = AcceleoUtil.getContent((InputStream)inputStream, (String)file.getCharset());
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException | CoreException e) {
                            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Can't read the content of " + String.valueOf(currentResource.getFullPath()) + ".", e));
                        }
                        if (!generatedContents.equals(fileContent)) {
                            diffNode = new DiffNode(3, null, (ITypedElement)left, (ITypedElement)right);
                            nodes.put((IResource)currentResource, diffNode);
                            this.hasDifferences = true;
                            currentResource = currentResource.getParent();
                            continue;
                        }
                        currentResource = null;
                        continue;
                    }
                    right.setContent(generatedContents.getBytes());
                    currentResource = null;
                    continue;
                }
                throw new IllegalStateException("An IResource should be an IContainer or an IFile.");
            }
        }
        if (this.hasDifferences) {
            GeneratedResourceNode left = new GeneratedResourceNode(this.preview, (IResource)this.target);
            ResourceNode right = new ResourceNode((IResource)this.target);
            res = new DiffNode(0, null, (ITypedElement)left, (ITypedElement)right);
            try {
                this.addChildren(this.target, res, nodes);
                for (IResource resource : nodes.keySet()) {
                    if (!(resource instanceof IContainer)) continue;
                    this.addChildren((IContainer)resource, (DiffNode)nodes.get(resource), nodes);
                }
            }
            catch (CoreException e) {
                AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Couldn't compare target folder " + String.valueOf(this.target.getFullPath()) + ".", (Throwable)e));
            }
        } else {
            res = null;
        }
        this.diffRoot = res;
    }

    protected void addChildren(IContainer parentResource, DiffNode parentNode, Map<IResource, DiffNode> nodes) throws CoreException {
        IResource[] iResourceArray = parentResource.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            DiffNode node = nodes.get(child);
            if (node != null) {
                parentNode.add((IDiffElement)node);
                node.setAncestor((ITypedElement)parentNode);
                node.setParent((IDiffContainer)parentNode);
            }
            ++n2;
        }
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return this.diffRoot;
    }

    public boolean hasDifferences() {
        return this.hasDifferences;
    }

    private static class CommitResourceNode
    extends ResourceNode {
        private final IProgressMonitor monitor;

        public CommitResourceNode(IResource resource, IProgressMonitor monitor) {
            super(resource);
            this.monitor = monitor;
        }

        public void setContent(byte[] contents) {
            super.setContent(contents);
            try {
                IFile file = (IFile)this.getResource();
                if (file.exists()) {
                    file.setContents((InputStream)new ByteArrayInputStream(contents), true, true, this.monitor);
                } else {
                    file.create((InputStream)new ByteArrayInputStream(contents), true, this.monitor);
                }
            }
            catch (CoreException e) {
                AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Can't write the content of " + String.valueOf(this.getResource().getFullPath()) + ".", (Throwable)e));
            }
        }
    }

    private static class GeneratedResourceNode
    extends ResourceNode {
        private final Map<URI, String> preview;

        public GeneratedResourceNode(Map<URI, String> preview, IResource resource) {
            super(resource);
            this.preview = preview;
            URI uri = URI.createFileURI((String)resource.getLocation().toString());
            String contents = preview.get(uri);
            if (contents != null) {
                this.setContent(contents.getBytes());
            }
        }

        public boolean isEditable() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        protected IStructureComparator createChild(IResource child) {
            return new GeneratedResourceNode(this.preview, child);
        }
    }
}

