/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;

public class ServersViewDropAdapter
extends ViewerDropAdapter {
    protected ServersViewDropAdapter(Viewer viewer) {
        super(viewer);
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = 1;
        }
        super.dragEnter(event);
    }

    public boolean performDrop(Object data) {
        Object target = this.getCurrentTarget();
        IServer server = null;
        if (target instanceof IServer) {
            server = (IServer)target;
        }
        if (server == null) {
            return false;
        }
        Iterator iterator = null;
        if (data instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)data;
            iterator = sel.iterator();
        }
        if (iterator == null) {
            return false;
        }
        boolean b = true;
        while (iterator.hasNext()) {
            Object data2 = iterator.next();
            if (this.doSel(server, data2)) continue;
            b = false;
        }
        return b;
    }

    protected boolean doSel(IServer server, Object data) {
        IModule[] modules;
        IProject project = (IProject)Platform.getAdapterManager().getAdapter(data, IProject.class);
        if (project != null && (modules = ServerUtil.getModules((IProject)project)) != null && modules.length == 1) {
            IModule[] parents;
            IServerWorkingCopy wc;
            block7: {
                block6: {
                    try {
                        wc = server.createWorkingCopy();
                        parents = wc.getRootModules(modules[0], null);
                        if (parents != null && parents.length != 0) break block6;
                        return false;
                    }
                    catch (CoreException ce) {
                        final Shell shell = this.getViewer().getControl().getShell();
                        shell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                EclipseUtil.openError(shell, ce.getLocalizedMessage());
                            }
                        });
                        return true;
                    }
                }
                if (!ServerUtil.containsModule((IServer)server, (IModule)parents[0], null)) break block7;
                return false;
            }
            IModule[] add = new IModule[]{parents[0]};
            if (wc.canModifyModules(add, null, null).getSeverity() != 4) {
                wc.modifyModules(modules, null, null);
                wc.save(false, null);
                return true;
            }
        }
        final IServer finalServer = server;
        RunOnServerActionDelegate ros = new RunOnServerActionDelegate(){

            @Override
            public IServer getServer(IModule module, IModuleArtifact moduleArtifact, IProgressMonitor monitor) throws CoreException {
                if (!ServerUIPlugin.isCompatibleWithLaunchMode(finalServer, this.launchMode)) {
                    return null;
                }
                if (!ServerUtil.containsModule((IServer)finalServer, (IModule)module, (IProgressMonitor)monitor)) {
                    IServerWorkingCopy wc = finalServer.createWorkingCopy();
                    ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[]{module}, (IModule[])new IModule[0], (IProgressMonitor)monitor);
                    wc.save(false, monitor);
                }
                return finalServer;
            }
        };
        Action action = new Action(){};
        ros.selectionChanged((IAction)action, (ISelection)new StructuredSelection(data));
        ros.run((IAction)action);
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (target == null) {
            return false;
        }
        if (Trace.FINER) {
            Trace.trace("/finer", "Drop target: " + String.valueOf(target) + " " + operation + " " + String.valueOf(transferType));
        }
        if (FileTransfer.getInstance().isSupportedType(transferType)) {
            return true;
        }
        if (ResourceTransfer.getInstance().isSupportedType(transferType)) {
            return true;
        }
        return LocalSelectionTransfer.getTransfer().isSupportedType(transferType);
    }
}

