/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.library;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.ExplicitNavigationProperty;
import org.eclipse.ocl.pivot.uml.internal.messages.UMLPivotMessages;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class UMLRedefinedNavigationProperty
extends ExplicitNavigationProperty {
    @Deprecated
    protected final @NonNull Property baseProperty;
    protected final @NonNull Property redefiningProperty;

    private static @NonNull Property getBaseProperty(@NonNull CompleteModel completeModel, @NonNull Property redefiningProperty) {
        CompleteClass baseCompleteClass = completeModel.getCompleteClass((Type)PivotUtil.getOwningClass((Property)redefiningProperty));
        Property baseProperty = redefiningProperty;
        for (Property aProperty : PivotUtil.getRedefinedProperties((Property)redefiningProperty)) {
            CompleteClass aCompleteClass = completeModel.getCompleteClass((Type)PivotUtil.getOwningClass((Property)aProperty));
            if (!baseCompleteClass.conformsTo(aCompleteClass)) continue;
            baseCompleteClass = aCompleteClass;
            baseProperty = aProperty;
        }
        return baseProperty;
    }

    public UMLRedefinedNavigationProperty(@NonNull CompleteModel completeModel, @NonNull Property redefiningProperty) {
        super(UMLRedefinedNavigationProperty.getBaseProperty(completeModel, redefiningProperty));
        this.baseProperty = this.property;
        this.redefiningProperty = redefiningProperty;
    }

    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        Object unredefinedResult = super.evaluate(executor, returnTypeId, sourceValue);
        Type baseType = this.property.getType();
        Type redefiningType = this.redefiningProperty.getType();
        if (baseType instanceof CollectionType) {
            if (!(redefiningType instanceof CollectionType)) {
                CollectionValue asCollectionValue = ValueUtil.asCollectionValue((Object)unredefinedResult);
                int intSize = asCollectionValue.intSize();
                switch (intSize) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return asCollectionValue.getElements().iterator().next();
                    }
                }
                throw new InvalidValueException(UMLPivotMessages.TooManyValuesForRedefinedProperty, new Object[]{this.property});
            }
            return unredefinedResult;
        }
        if (redefiningType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)redefiningType;
            CollectionTypeId typeId = collectionType.getTypeId();
            List<Object> valueAsList = Collections.singletonList(unredefinedResult);
            return executor.getIdResolver().createCollectionOfAll(typeId, valueAsList);
        }
        return unredefinedResult;
    }
}

