/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.JptWorkspace;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.PathTools;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;

public class ContentTypeTools {
    public static JptResourceType getResourceType(IContentType contentType) {
        JptWorkspace jptWorkspace = ContentTypeTools.getJptWorkspace();
        return jptWorkspace == null ? null : jptWorkspace.getResourceTypeManager().getResourceType(contentType);
    }

    public static JptResourceType getResourceType(IContentType contentType, String version) {
        JptWorkspace jptWorkspace = ContentTypeTools.getJptWorkspace();
        return jptWorkspace == null ? null : jptWorkspace.getResourceTypeManager().getResourceType(contentType, version);
    }

    private static JptWorkspace getJptWorkspace() {
        return PlatformTools.getAdapter(PathTools.getWorkspace(), JptWorkspace.class);
    }

    public static IContentType contentType(IFile file) {
        String fileName = file.getName();
        InputStream fileContents = null;
        try {
            fileContents = file.getContents();
        }
        catch (CoreException coreException) {
            return ContentTypeTools.findContentTypeFor(fileName);
        }
        IContentType contentType = null;
        try {
            try {
                contentType = ContentTypeTools.findContentTypeFor(fileContents, fileName);
            }
            catch (IOException ex) {
                JptCommonCorePlugin.instance().logError(ex);
                try {
                    fileContents.close();
                }
                catch (IOException ex2) {
                    JptCommonCorePlugin.instance().logError(ex2);
                }
            }
        }
        finally {
            try {
                fileContents.close();
            }
            catch (IOException ex) {
                JptCommonCorePlugin.instance().logError(ex);
            }
        }
        return contentType;
    }

    private static IContentType findContentTypeFor(InputStream fileContents, String fileName) throws IOException {
        return ContentTypeTools.getContentTypeManager().findContentTypeFor(fileContents, fileName);
    }

    private static IContentType findContentTypeFor(String fileName) {
        return ContentTypeTools.getContentTypeManager().findContentTypeFor(fileName);
    }

    private static IContentTypeManager getContentTypeManager() {
        return Platform.getContentTypeManager();
    }

    private ContentTypeTools() {
        throw new UnsupportedOperationException();
    }
}

