/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.swt.widgets.Display;

public class DefaultMarkerBehavior {
    protected DiagramBehavior diagramBehavior;
    private MarkerHelper markerHelper = new EditUIMarkerHelper();
    private Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    private boolean updateProblemIndication = true;
    private EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = DefaultMarkerBehavior.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            DefaultMarkerBehavior.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            DefaultMarkerBehavior.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!DefaultMarkerBehavior.this.updateProblemIndication) return;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                DefaultMarkerBehavior.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };

    public DefaultMarkerBehavior(DiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    public void initialize() {
        this.diagramBehavior.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public EContentAdapter getProblemIndicationAdapter() {
        return this.problemIndicationAdapter;
    }

    public void disableProblemIndicationUpdate() {
        this.updateProblemIndication = false;
    }

    public void enableProblemIndicationUpdate() {
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    void updateProblemIndication() {
        if (this.diagramBehavior == null) {
            return;
        }
        TransactionalEditingDomain editingDomain = this.diagramBehavior.getEditingDomain();
        if (this.updateProblemIndication && editingDomain != null) {
            ResourceSet resourceSet = editingDomain.getResourceSet();
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.graphiti.ui", 0, null, new Object[]{resourceSet});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            if (this.markerHelper.hasMarkers((Object)resourceSet)) {
                this.markerHelper.deleteMarkers((Object)resourceSet);
            }
            if (diagnostic.getSeverity() != 0) {
                try {
                    this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    T.racer().info(diagnostic.toString());
                }
                catch (CoreException exception) {
                    T.racer().error(exception.getMessage(), exception);
                }
            }
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!(resource.getErrors().isEmpty() && resource.getWarnings().isEmpty() || !this.updateProblemIndication)) {
            IFile file = GraphitiUiInternal.getEmfService().getFile(resource.getURI());
            String fileName = file != null ? file.getFullPath().toString() : "unknown name";
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.graphiti.ui", 0, "Problems encountered in file " + fileName, new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.graphiti.ui", 0, "Problems encountered in file", new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void dispose() {
        ResourceSet resourceSet;
        this.disableProblemIndicationUpdate();
        if (this.diagramBehavior != null && (resourceSet = this.diagramBehavior.getResourceSet()) != null) {
            resourceSet.eAdapters().remove((Object)this.problemIndicationAdapter);
        }
        this.problemIndicationAdapter = null;
        this.markerHelper = null;
        this.diagramBehavior = null;
        this.resourceToDiagnosticMap.clear();
        this.resourceToDiagnosticMap = null;
    }
}

