/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;

public class EDEFProperties
extends Properties {
    private static final long serialVersionUID = -7351470248095230347L;
    private static int nextInt = 0;
    private static long nextLong = 0L;
    private static short nextShort = 0;
    private static byte nextByte = 0;
    private static final String[] typelist = new String[]{"array", "set", "list", "uuid", "string", "long", "double", "float", "short", "int", "integer", "char", "character", "byte", "char", "boolean", "short", "byte"};
    private static List<String> TYPES = null;
    private static final char[] hexDigit;

    static {
        TYPES = Arrays.asList(typelist);
        hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    static synchronized int getNextInteger() {
        if (nextInt == Integer.MAX_VALUE) {
            nextInt = 0;
        }
        return ++nextInt;
    }

    static synchronized long getNextLong() {
        if (nextLong == Long.MAX_VALUE) {
            nextLong = 0L;
        }
        return ++nextLong;
    }

    static synchronized short getNextShort() {
        if (nextShort == Short.MAX_VALUE) {
            nextShort = 0;
        }
        nextShort = (short)(nextShort + 1);
        return nextShort;
    }

    static synchronized byte getNextByte() {
        if (nextByte == 127) {
            nextByte = 0;
        }
        nextByte = (byte)(nextByte + 1);
        return nextByte;
    }

    public EDEFProperties() {
    }

    public EDEFProperties(Map<String, Object> properties) {
        this.putEDEFProperties(properties);
    }

    @Override
    public Object put(Object key, Object value) {
        if (key instanceof String && value instanceof String) {
            Value oldValue = (Value)this.get(key);
            Value newValue = new Value((String)value);
            return super.put(key, oldValue == null ? newValue : oldValue.addPropertyValue(newValue));
        }
        return super.put(key, value);
    }

    public Value getValue(String name) {
        Object result = this.get(name);
        return (Value)(result instanceof Value ? result : null);
    }

    public Object putEDEFProperty(String name, Object value) {
        if (name != null && value != null) {
            return super.put(name, new Value(value));
        }
        return null;
    }

    public Map<String, Object> getEDEFPropertiesAsMap() {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put((String)k, ((Value)v).getValueObject())));
        return result;
    }

    private static void writeComments0(BufferedWriter bw, String comments) throws IOException {
        bw.write("#");
        int len = comments.length();
        int current = 0;
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        while (current < len) {
            char c = comments.charAt(current);
            if (c > '\u00ff' || c == '\n' || c == '\r') {
                if (last != current) {
                    bw.write(comments.substring(last, current));
                }
                if (c > '\u00ff') {
                    uu[2] = EDEFProperties.toHex(c >> 12 & 0xF);
                    uu[3] = EDEFProperties.toHex(c >> 8 & 0xF);
                    uu[4] = EDEFProperties.toHex(c >> 4 & 0xF);
                    uu[5] = EDEFProperties.toHex(c & 0xF);
                    bw.write(new String(uu));
                } else {
                    bw.newLine();
                    if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                        ++current;
                    }
                    if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                        bw.write("#");
                    }
                }
                last = current + 1;
            }
            ++current;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public synchronized void loadEDEFProperties(InputStream ins) throws IOException {
        this.load(ins);
    }

    public void loadEDEFProperties(Reader reader) throws IOException {
        this.load(reader);
    }

    public void storeEDEFProperties(Writer writer, String comments) throws IOException {
        this.storeEDEFProperties(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeEDEFProperties(BufferedWriter bufferedWriter, String comments) throws IOException {
        if (comments != null) {
            EDEFProperties.writeComments0(bufferedWriter, comments);
        }
        bufferedWriter.write("#" + new Date().toString());
        bufferedWriter.newLine();
        EDEFProperties eDEFProperties = this;
        synchronized (eDEFProperties) {
            Enumeration<Object> e = this.keys();
            while (e.hasMoreElements()) {
                String key;
                Object elemValue;
                Object k = e.nextElement();
                if (!(k instanceof String) || !((elemValue = this.get(key = (String)k)) instanceof Value)) continue;
                bufferedWriter.write(key + ((Value)elemValue).getValueString());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
        }
    }

    public synchronized void putEDEFProperties(Map<String, Object> properties) {
        properties.forEach((? super K k, ? super V v) -> {
            if (k instanceof String) {
                this.putEDEFProperty((String)k, v);
            }
        });
    }

    public class Value {
        private String type1 = "string";
        private String type2 = "string";
        private String valueString;
        private Object valueObject;

        boolean isArray() {
            return this.type1.equalsIgnoreCase("array");
        }

        boolean isSet() {
            return this.type1.equalsIgnoreCase("set");
        }

        boolean isList() {
            return this.type1.equalsIgnoreCase("list");
        }

        boolean isCollection() {
            return this.isSet() || this.isList();
        }

        boolean isSimpleType() {
            return !this.isCollection() && !this.isArray();
        }

        boolean hasTypeAgreement(Value otherValue) {
            String otherType = otherValue.isArray() || otherValue.isCollection() ? otherValue.type2 : otherValue.type1;
            return this.isArray() || this.isCollection() ? this.type2.equalsIgnoreCase(otherType) : this.type1.equalsIgnoreCase(otherType);
        }

        Value addPropertyValue(Value newValue) {
            if (!this.hasTypeAgreement(newValue)) {
                LogUtility.logError("addEDEFPropertyValue", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "type disagreement between property values for old type1=" + this.type1 + ",type2=" + this.type2 + ", and new type1=" + newValue.type1 + ",type2=" + newValue.type2);
                return this;
            }
            Object ov = this.getValueObject();
            Object nv = newValue.getValueObject();
            if (this.isCollection()) {
                Collection oldVs = (Collection)ov;
                if (newValue.isCollection()) {
                    oldVs.addAll((Collection)nv);
                } else if (newValue.isSimpleType()) {
                    oldVs.add(nv);
                }
            } else if (this.isArray()) {
                int oldLength = Array.getLength(ov);
                Object newResultValue = null;
                if (newValue.isArray()) {
                    int newLength = Array.getLength(nv);
                    newResultValue = Array.newInstance(ov.getClass().getComponentType(), oldLength + newLength);
                    System.arraycopy(ov, 0, newResultValue, 0, oldLength);
                    System.arraycopy(nv, 0, newResultValue, oldLength, newLength);
                } else if (newValue.isSimpleType()) {
                    newResultValue = Array.newInstance(ov.getClass().getComponentType(), oldLength + 1);
                    System.arraycopy(ov, 0, newResultValue, 0, oldLength);
                    Array.set(newResultValue, oldLength, nv);
                }
                if (newResultValue != null) {
                    this.valueObject = newResultValue;
                }
            }
            return this;
        }

        Value(String value) {
            String[] valueArr = value.split("=");
            if (TYPES.contains(valueArr[0].split(":")[0].toLowerCase())) {
                if (valueArr.length > 1) {
                    String[] firstSplit = valueArr[0].split(":");
                    if (firstSplit.length > 1) {
                        this.type2 = firstSplit[1];
                    }
                    this.type1 = firstSplit[0];
                }
                this.valueString = valueArr[valueArr.length - 1];
            } else {
                this.valueString = value;
            }
        }

        private void setType2(Collection coll) {
            Class<?> c = coll.iterator().next().getClass();
            if (!c.equals(String.class)) {
                this.type2 = c.getSimpleName().toLowerCase();
            }
        }

        Value(Object value) {
            Class<?> clazz = value.getClass();
            if (clazz.isArray()) {
                this.type1 = "array";
                Class<?> compType = clazz.getComponentType();
                if (!compType.equals(String.class)) {
                    this.type2 = compType.getSimpleName().toLowerCase();
                }
            } else if (List.class.isInstance(value)) {
                this.type1 = "list";
                this.setType2((List)value);
            } else if (Set.class.isInstance(value)) {
                this.type1 = "set";
                this.setType2((Set)value);
            } else {
                String type = clazz.getSimpleName().toLowerCase();
                if (!type.equalsIgnoreCase("string")) {
                    this.type1 = type;
                }
            }
            this.valueObject = value;
        }

        private Object getSimpleValue(Class<?> simpleType, Object value) {
            try {
                return simpleType.getDeclaredMethod("valueOf", String.class).invoke(null, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LogUtility.logWarning("getSimpleValue", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "Cannot create instance of simpleType=" + String.valueOf(simpleType) + ", value=" + String.valueOf(value));
                return null;
            }
        }

        boolean isUnique() {
            return "unique".equals(this.type2);
        }

        Object readSimpleValue(String simpleType, String value) {
            switch (simpleType) {
                case "Long": 
                case "long": {
                    if ("unique".equalsIgnoreCase(this.type2)) {
                        return EDEFProperties.getNextLong();
                    }
                    if ("nanoTime".equalsIgnoreCase(this.type2)) {
                        return System.nanoTime();
                    }
                    if ("milliTime".equalsIgnoreCase(this.type2)) {
                        return System.currentTimeMillis();
                    }
                    return this.getSimpleValue(Long.class, value);
                }
                case "double": 
                case "Double": {
                    return this.getSimpleValue(Double.class, value);
                }
                case "Float": 
                case "float": {
                    return this.getSimpleValue(Float.class, value);
                }
                case "Integer": 
                case "int": 
                case "integer": {
                    if ("unique".equals(this.type2)) {
                        return EDEFProperties.getNextInteger();
                    }
                    return this.getSimpleValue(Integer.class, value);
                }
                case "Byte": 
                case "byte": {
                    if ("unique".equals(this.type2)) {
                        return EDEFProperties.getNextByte();
                    }
                    return this.getSimpleValue(Byte.class, value);
                }
                case "Character": 
                case "char": {
                    return this.getSimpleValue(Character.class, Character.valueOf(value.toCharArray()[0]));
                }
                case "boolean": 
                case "Boolean": {
                    return this.getSimpleValue(Boolean.class, value);
                }
                case "Short": 
                case "short": {
                    if ("unique".equals(this.type2)) {
                        return EDEFProperties.getNextShort();
                    }
                    return this.getSimpleValue(Short.class, value);
                }
                case "UUID": 
                case "Uuid": 
                case "uuid": {
                    return UUID.randomUUID().toString();
                }
                case "String": 
                case "string": {
                    return value;
                }
            }
            return null;
        }

        Object readArrayValues(String collectionValue) {
            String[] elements = this.valueString.split("\\s*,\\s*");
            Object result = null;
            int i = 0;
            while (i < elements.length) {
                Object elementValue = this.readSimpleValue(this.type2, elements[i]);
                if (elementValue == null) {
                    LogUtility.logWarning("getArrayValues", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "array element=" + elements[i] + " could not be created");
                } else {
                    if (i == 0) {
                        result = Array.newInstance(elementValue.getClass(), elements.length);
                    }
                    Array.set(result, i, elementValue);
                }
                ++i;
            }
            return result;
        }

        Collection<Object> readCollectionValues(Collection<Object> c, String collectionValue) {
            String[] elements;
            String[] stringArray = elements = this.valueString.split("\\s*,\\s*");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Object elementValue = this.readSimpleValue(this.type2, element);
                if (elementValue == null) {
                    LogUtility.logWarning("getCollectionValues", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "array element=" + element + " could not be created");
                } else {
                    c.add(elementValue);
                }
                ++n2;
            }
            return c;
        }

        public synchronized Object getValueObject() {
            block13: {
                if (this.valueObject != null) break block13;
                switch (this.type1) {
                    case "array": {
                        this.valueObject = this.readArrayValues(this.valueString);
                        break;
                    }
                    case "list": {
                        this.valueObject = this.readCollectionValues(new ArrayList<Object>(), this.valueString);
                        break;
                    }
                    case "set": {
                        this.valueObject = this.readCollectionValues(new HashSet<Object>(), this.valueString);
                        break;
                    }
                    default: {
                        this.valueObject = this.readSimpleValue(this.type1, this.valueString);
                    }
                }
            }
            return this.valueObject;
        }

        public synchronized String getValueString() {
            if (this.valueString == null) {
                StringBuffer buf = new StringBuffer();
                if (this.isSimpleType()) {
                    if (!this.type1.equalsIgnoreCase("string")) {
                        buf.append(":").append(this.type1);
                    }
                    buf.append("=").append(this.valueObject.toString());
                } else {
                    buf.append(":").append(this.type1);
                    if (!this.type2.equalsIgnoreCase("string")) {
                        buf.append(":").append(this.type2);
                    }
                    buf.append("=");
                    Object[] arr = this.isArray() ? this.valueObject : ((Collection)this.valueObject).toArray();
                    int i = 0;
                    while (i < arr.length) {
                        buf.append(arr[i].toString());
                        if (i != arr.length - 1) {
                            buf.append(",");
                        }
                        ++i;
                    }
                }
                this.valueString = buf.toString();
            }
            return this.valueString;
        }
    }
}

