/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Attribute;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.IAttributed;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class PropertyHook
extends Declaration
implements IAttributed,
IPHPDocAwareDeclaration {
    private PHPDocBlock phpDoc;
    private List<Attribute> attributes;
    private final boolean isReference;
    private final List<FormalParameter> arguments;
    private final Statement body;

    public PropertyHook(int start, int end, int modifiers, boolean isReference, String name, int nameStart, int nameEnd, List<FormalParameter> arguments, Statement body) {
        super(start, end);
        this.setModifiers(modifiers);
        this.isReference = isReference;
        this.setName(name);
        this.setNameStart(nameStart);
        this.setNameEnd(nameEnd);
        this.arguments = arguments;
        this.body = body;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Statement)this)) {
            if (this.attributes != null) {
                for (Attribute attr : this.attributes) {
                    attr.traverse(pVisitor);
                }
            }
            if (this.arguments != null) {
                for (FormalParameter arg : this.arguments) {
                    arg.traverse(pVisitor);
                }
            }
            if (this.body != null) {
                this.body.traverse(pVisitor);
            }
            pVisitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 87;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    public List<FormalParameter> getArguments() {
        return this.arguments;
    }

    public Statement getBody() {
        return this.body;
    }

    public boolean isArrow() {
        return !(this.body instanceof Block);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public PHPDocBlock getPHPDoc() {
        return this.phpDoc;
    }

    @Override
    public void setPHPDoc(PHPDocBlock block) {
        this.phpDoc = block;
    }

    public boolean isReference() {
        return this.isReference;
    }
}

