/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDForm;

public class XSDSchemaAdvancedSection
extends AbstractSection {
    IWorkbenchPart part;
    protected CLabel elementFormLabel;
    protected CLabel attributeFormLabel;
    protected CLabel blockDefaultLabel;
    protected CLabel finalDefaultLabel;
    protected CCombo elementFormCombo;
    protected CCombo attributeFormCombo;
    protected CCombo blockDefaultCombo;
    protected CCombo finalDefaultCombo;
    protected static final String emptyOption = "";
    protected static final String[] formQualification = new String[]{"", XSDForm.QUALIFIED_LITERAL.getLiteral(), XSDForm.UNQUALIFIED_LITERAL.getLiteral()};
    protected static final String[] derivedByChoicesComboValues = new String[]{"", "restriction", "extension"};
    protected static final String[] blockDefaultValues = new String[]{"", "#all", "extension", "restriction", "substitution"};
    protected static final String[] finalDefaultValues = new String[]{"", "#all", "extension", "restriction", "list", "union"};

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        this.elementFormLabel = XSDCommonUIUtils.getNewPropertiesLabel(this.composite, this.getWidgetFactory(), Messages._UI_LABEL_ELEMENTFORMDEFAULT);
        this.elementFormCombo = XSDCommonUIUtils.getNewPropertiesCombo(this.composite, this.getWidgetFactory(), this, formQualification, "org.eclipse.wst.xsd.ui.xsdup0450");
        this.attributeFormLabel = XSDCommonUIUtils.getNewPropertiesLabel(this.composite, this.getWidgetFactory(), Messages._UI_LABEL_ATTRIBUTEFORMDEFAULT);
        this.attributeFormCombo = XSDCommonUIUtils.getNewPropertiesCombo(this.composite, this.getWidgetFactory(), this, formQualification, "org.eclipse.wst.xsd.ui.xsdup0460");
        this.blockDefaultLabel = XSDCommonUIUtils.getNewPropertiesLabel(this.composite, this.getWidgetFactory(), Messages._UI_LABEL_BLOCKDEFAULT);
        this.blockDefaultCombo = XSDCommonUIUtils.getNewPropertiesCombo(this.composite, this.getWidgetFactory(), this, blockDefaultValues, "org.eclipse.wst.xsd.ui.xsdup0470");
        this.finalDefaultLabel = XSDCommonUIUtils.getNewPropertiesLabel(this.composite, this.getWidgetFactory(), Messages._UI_LABEL_FINALDEFAULT);
        this.finalDefaultCombo = XSDCommonUIUtils.getNewPropertiesCombo(this.composite, this.getWidgetFactory(), this, finalDefaultValues, "org.eclipse.wst.xsd.ui.xsdup0480");
        Dialog.applyDialogFont((Control)parent);
    }

    public void refresh() {
        super.refresh();
        this.setListenerEnabled(false);
        if (this.xsdSchema != null) {
            String text;
            if (this.elementFormCombo != null) {
                text = this.xsdSchema.getElement().hasAttribute("elementFormDefault") ? this.xsdSchema.getElementFormDefault().getName() : emptyOption;
                this.elementFormCombo.setText(text);
            }
            if (this.attributeFormCombo != null) {
                text = this.xsdSchema.getElement().hasAttribute("attributeFormDefault") ? this.xsdSchema.getAttributeFormDefault().getName() : emptyOption;
                this.attributeFormCombo.setText(text);
            }
            if (this.blockDefaultCombo != null) {
                text = this.xsdSchema.getElement().hasAttribute("blockDefault") ? this.xsdSchema.getElement().getAttribute("blockDefault") : emptyOption;
                this.blockDefaultCombo.setText(text);
            }
            if (this.finalDefaultCombo != null) {
                text = this.xsdSchema.getElement().hasAttribute("finalDefault") ? this.xsdSchema.getElement().getAttribute("finalDefault") : emptyOption;
                this.finalDefaultCombo.setText(text);
            }
        }
        this.setListenerEnabled(true);
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (this.xsdSchema != null) {
            UpdateAttributeValueCommand command;
            if (e.widget == this.elementFormCombo && this.elementFormCombo != null) {
                String valueElementForm = this.elementFormCombo.getText();
                command = new UpdateAttributeValueCommand(this.xsdSchema.getElement(), "elementFormDefault", valueElementForm, Messages._UI_LABEL_ELEMENTFORMDEFAULT);
                command.setDeleteIfEmpty(true);
                this.getCommandStack().execute((Command)command);
            }
            if (e.widget == this.attributeFormCombo && this.attributeFormCombo != null) {
                String valueAttributeForm = this.attributeFormCombo.getText();
                command = new UpdateAttributeValueCommand(this.xsdSchema.getElement(), "attributeFormDefault", valueAttributeForm, Messages._UI_LABEL_ATTRIBUTEFORMDEFAULT);
                command.setDeleteIfEmpty(true);
                this.getCommandStack().execute((Command)command);
            }
            if (e.widget == this.blockDefaultCombo && this.blockDefaultCombo != null) {
                String valueBlockDefault = this.blockDefaultCombo.getText();
                command = new UpdateAttributeValueCommand(this.xsdSchema.getElement(), "blockDefault", valueBlockDefault, Messages._UI_LABEL_BLOCKDEFAULT);
                command.setDeleteIfEmpty(true);
                this.getCommandStack().execute((Command)command);
            }
            if (e.widget == this.finalDefaultCombo && this.finalDefaultCombo != null) {
                String finalBlockDefault = this.finalDefaultCombo.getText();
                command = new UpdateAttributeValueCommand(this.xsdSchema.getElement(), "finalDefault", finalBlockDefault, Messages._UI_LABEL_FINALDEFAULT);
                command.setDeleteIfEmpty(true);
                this.getCommandStack().execute((Command)command);
            }
        }
    }
}

