/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.gef.core.tools.Tool;

public abstract class TargetingTool
extends Tool {
    private EditPart m_target;
    private Request m_request;
    private boolean m_isLockTarget;
    private boolean m_isShowingFeedback;

    @Override
    public void deactivate() {
        this.eraseTargetFeedback();
        this.m_isLockTarget = false;
        this.m_target = null;
        this.m_request = null;
        super.deactivate();
    }

    protected EditPart getTargetEditPart() {
        return this.m_target;
    }

    protected void setTargetEditPart(EditPart target) {
        if (this.m_target != target) {
            if (this.m_target != null) {
                this.handleExitingEditPart();
            }
            this.m_target = target;
            this.handleEnteredEditPart();
        }
    }

    protected void handleExitingEditPart() {
        this.eraseTargetFeedback();
    }

    protected void handleEnteredEditPart() {
        this.updateTargetRequest();
        this.showTargetFeedback();
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.setCommand(null);
        return true;
    }

    protected boolean handleViewerExited() {
        this.setTargetEditPart(null);
        return true;
    }

    protected void lockTargetEditPart(EditPart editpart) {
        if (editpart == null) {
            this.unlockTargetEditPart();
        } else {
            this.m_isLockTarget = true;
            this.setTargetEditPart(editpart);
        }
    }

    protected void unlockTargetEditPart() {
        this.m_isLockTarget = false;
        this.updateTargetUnderMouse();
    }

    protected Collection<IFigure> getExclusionSet() {
        return Collections.emptyList();
    }

    protected EditPartViewer.Conditional getTargetingConditional() {
        return target -> {
            this.updateTargetRequest(target);
            return target.getTargetEditPart(this.getTargetRequest()) != null;
        };
    }

    protected void updateTargetUnderMouse() {
        if (!this.m_isLockTarget) {
            EditPart editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
            if (editPart != null) {
                editPart = editPart.getTargetEditPart(this.getTargetRequest());
            }
            this.setTargetEditPart(editPart);
        }
    }

    protected Request getTargetRequest() {
        if (this.m_request == null) {
            this.m_request = this.createTargetRequest();
        }
        return this.m_request;
    }

    protected Request createTargetRequest() {
        return new Request();
    }

    protected void updateTargetRequest() {
    }

    protected void updateTargetRequest(EditPart target) {
    }

    @Override
    protected Command getCommand() {
        return this.m_target == null ? null : this.m_target.getCommand(this.getTargetRequest());
    }

    protected void showTargetFeedback() {
        if (this.m_target != null) {
            this.m_target.showTargetFeedback(this.getTargetRequest());
        }
        this.m_isShowingFeedback = true;
    }

    protected void eraseTargetFeedback() {
        if (this.m_isShowingFeedback) {
            this.m_isShowingFeedback = false;
            if (this.m_target != null) {
                this.m_target.eraseTargetFeedback(this.getTargetRequest());
            }
        }
    }
}

