/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.util.List;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ArrayAccess;
import org.eclipse.php.core.ast.nodes.ArrayCreation;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.CastExpression;
import org.eclipse.php.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldAccess;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.InfixExpression;
import org.eclipse.php.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.MethodInvocation;
import org.eclipse.php.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.SwitchCase;
import org.eclipse.php.core.ast.nodes.SwitchStatement;

public class ASTResolving {
    public static ITypeBinding guessBindingForReference(ASTNode node) {
        return ASTResolving.getPossibleReferenceBinding(node);
    }

    private static ITypeBinding getPossibleReferenceBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        switch (parent.getType()) {
            case 3: {
                Assignment assignment = (Assignment)parent;
                if (node.equals(assignment.getLeftHandSide())) {
                    return assignment.getRightHandSide().resolveTypeBinding();
                }
                return assignment.getLeftHandSide().resolveTypeBinding();
            }
            case 37: {
                InfixExpression infix = (InfixExpression)parent;
                int op = infix.getOperator();
                if (op == 14 || op == 13) {
                    return infix.getAST().resolveWellKnownType("boolean");
                }
                if (op == 22 || op == 23) {
                    return infix.getAST().resolveWellKnownType("int");
                }
                if (node.equals(infix.getLeft())) {
                    ITypeBinding rigthHandBinding = infix.getRight().resolveTypeBinding();
                    if (rigthHandBinding != null) {
                        return rigthHandBinding;
                    }
                } else {
                    ITypeBinding leftHandBinding = infix.getLeft().resolveTypeBinding();
                    if (leftHandBinding != null) {
                        return leftHandBinding;
                    }
                }
                if (op == 2 || op == 3) break;
                return infix.getAST().resolveWellKnownType("int");
            }
            case 39: {
                InstanceOfExpression instanceofExpression = (InstanceOfExpression)parent;
                return instanceofExpression.getExpression().resolveTypeBinding();
            }
            case 63: {
                SingleFieldDeclaration frag = (SingleFieldDeclaration)parent;
                if (!frag.getName().equals(node)) break;
                return frag.getName().resolveTypeBinding();
            }
            case 43: {
                MethodInvocation methodInvocation = (MethodInvocation)parent;
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                if (methodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, methodInvocation.getMethod().parameters(), methodBinding);
            }
            case 13: {
                ClassInstanceCreation creation = (ClassInstanceCreation)parent;
                IMethodBinding creationBinding = creation.resolveConstructorBinding();
                if (creationBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, creation.ctorParams(), creationBinding);
            }
            case 62: {
                return ASTResolving.guessBindingForReference(parent);
            }
            case 0: {
                if (((ArrayAccess)parent).getIndex().equals(node)) {
                    return parent.getAST().resolveWellKnownType("int");
                }
                ITypeBinding parentBinding = ASTResolving.getPossibleReferenceBinding(parent);
                if (parentBinding == null) {
                    parentBinding = parent.getAST().resolveWellKnownType("java.lang.Object");
                }
                return parentBinding.createArrayType(1);
            }
            case 17: {
                ConditionalExpression expression = (ConditionalExpression)parent;
                if (node.equals(expression.getCondition())) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                if (node.equals(expression.getIfFalse())) {
                    return expression.getIfTrue().resolveTypeBinding();
                }
                return expression.getIfFalse().resolveTypeBinding();
            }
            case 20: 
            case 34: 
            case 61: {
                if (!(node instanceof Expression)) break;
                return parent.getAST().resolveWellKnownType("boolean");
            }
            case 56: {
                if (!((SwitchStatement)parent).getExpression().equals(node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 8: {
                return ((CastExpression)parent).resolveTypeBinding();
            }
            case 9: 
            case 57: {
                return parent.getAST().resolveWellKnownType("Exception");
            }
            case 24: {
                if (!node.equals(((FieldAccess)parent).getField())) break;
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 55: {
                if (!node.equals(((SwitchCase)parent).getValue()) || !(parent.getParent() instanceof SwitchStatement)) break;
                return ((SwitchStatement)parent.getParent()).getExpression().resolveTypeBinding();
            }
        }
        return null;
    }

    private static ITypeBinding getParameterTypeBinding(ASTNode node, List<Expression> args, IMethodBinding binding) {
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        int index = args.indexOf(node);
        if (binding.isVarargs() && index >= paramTypes.length - 1) {
            return paramTypes[paramTypes.length - 1].getComponentType();
        }
        if (index >= 0 && index < paramTypes.length) {
            return paramTypes[index];
        }
        return null;
    }

    public static ITypeBinding guessBindingForTypeReference(ASTNode node) {
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent == Identifier.NAME_PROPERTY) {
            node = node.getParent();
        }
        return ASTResolving.getPossibleTypeBinding(node);
    }

    private static ITypeBinding getPossibleTypeBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        switch (parent.getType()) {
            case 25: {
                return ASTResolving.guessVariableType(((FieldsDeclaration)parent).fields());
            }
            case 1: {
                ArrayCreation creation = (ArrayCreation)parent;
                return creation.resolveTypeBinding();
            }
            case 13: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 8: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
        }
        return null;
    }

    private static ITypeBinding guessVariableType(List<SingleFieldDeclaration> fragments) {
        for (SingleFieldDeclaration frag : fragments) {
            if (frag.getName() == null) continue;
            return frag.getName().resolveTypeBinding();
        }
        return null;
    }

    public static MethodDeclaration findParentMethodDeclaration(ASTNode node) {
        while (node != null) {
            if (node.getType() == 42) {
                return (MethodDeclaration)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public static int getPossibleElementKinds(ASTNode node) {
        int kinds = ASTResolving.internalGetPossibleElementKinds(node);
        return kinds;
    }

    private static int internalGetPossibleElementKinds(ASTNode node) {
        int kind = 6;
        if (node.getType() == 51) {
            return 16;
        }
        ASTNode parent = node.getParent();
        if (parent.getType() == 65) {
            parent = parent.getParent();
        }
        switch (parent.getType()) {
            case 12: 
            case 40: {
                kind = 6;
                break;
            }
            case 42: {
                kind = 6;
                break;
            }
            case 39: {
                kind = 6;
                break;
            }
            case 57: {
                kind = 2;
                break;
            }
            case 13: {
                kind = 6;
                break;
            }
            case 63: {
                int superParent = parent.getParent().getType();
                if (superParent != 9) break;
                kind = 2;
                break;
            }
            case 31: {
                kind = 8;
                break;
            }
            case 82: {
                kind = 6;
            }
        }
        return kind;
    }

    public static ASTNode findParentType(ASTNode node) {
        while (node != null) {
            if (node.getType() == 12 || node.getType() == 77 || node.getType() == 40) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }
}

