/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.search.ExtensionPluginSearchScope;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.search.PluginSearchScope;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.PluginSearchQuery;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class PluginSearchPage
extends DialogPage
implements ISearchPage {
    private static ArrayList<QueryData> previousQueries = new ArrayList();
    private Button caseSensitive;
    private ISearchPageContainer container;
    private final Button[] externalScopeButtons = new Button[3];
    private boolean firstTime = true;
    private final Button[] limitToButtons = new Button[3];
    private Combo patternCombo;
    private final Button[] searchForButtons = new Button[3];

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        this.createPatternSection(result);
        this.createSettingsSection(result);
        this.hookListeners();
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.pde.doc.user.search_page");
    }

    private void createGroup(Composite parent, Button[] buttons, String groupLabel, String[] buttonLabels, int defaultEnabled) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        group.setText(groupLabel);
        int i = 0;
        while (i < buttonLabels.length) {
            buttons[i] = new Button((Composite)group, 16);
            buttons[i].setText(buttonLabels[i]);
            buttons[i].setSelection(i == defaultEnabled);
            ++i;
        }
    }

    private void createPatternSection(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        result.setLayoutData((Object)new GridData(768));
        Label label = new Label(result, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(PDEUIMessages.SearchPage_searchString);
        this.patternCombo = new Combo(result, 2052);
        this.patternCombo.setLayoutData((Object)new GridData(768));
        this.caseSensitive = new Button(result, 32);
        this.caseSensitive.setText(PDEUIMessages.SearchPage_caseSensitive);
    }

    private void createSettingsSection(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(3, true));
        result.setLayoutData((Object)new GridData(1808));
        this.createGroup(result, this.searchForButtons, PDEUIMessages.SearchPage_searchFor, new String[]{PDEUIMessages.SearchPage_plugin, PDEUIMessages.SearchPage_fragment, PDEUIMessages.SearchPage_extPt}, 2);
        this.createGroup(result, this.limitToButtons, PDEUIMessages.SearchPage_limitTo, new String[]{PDEUIMessages.SearchPage_declarations, PDEUIMessages.SearchPage_references, PDEUIMessages.SearchPage_allOccurrences}, 1);
        this.createGroup(result, this.externalScopeButtons, PDEUIMessages.SearchPage_externalScope, new String[]{PDEUIMessages.SearchPage_all, PDEUIMessages.SearchPage_enabledOnly, PDEUIMessages.SearchPage_none}, 1);
    }

    private int getExternalScope() {
        if (this.externalScopeButtons[0].getSelection()) {
            return 2;
        }
        if (this.externalScopeButtons[1].getSelection()) {
            return 1;
        }
        return 0;
    }

    private PluginSearchInput getInput() {
        PluginSearchInput input = new PluginSearchInput();
        int searchFor = this.getSearchFor();
        input.setSearchElement(searchFor);
        input.setSearchLimit(this.getLimitTo());
        PluginSearchScope scope = null;
        Object searchString = this.patternCombo.getText().trim();
        if (searchFor == 3) {
            if (((String)searchString).indexOf(46) == -1) {
                searchString = "*." + (String)searchString;
            }
            if (((String)searchString).indexOf(42) == -1) {
                scope = new ExtensionPluginSearchScope(this.getWorkspaceScope(), this.getExternalScope(), this.getSelectedResources(), input);
            }
        }
        if (scope == null) {
            scope = new PluginSearchScope(this.getWorkspaceScope(), this.getExternalScope(), this.getSelectedResources());
        }
        input.setSearchScope(scope);
        input.setSearchString((String)searchString);
        input.setCaseSensitive(this.caseSensitive.getSelection());
        return input;
    }

    private int getLimitTo() {
        if (this.limitToButtons[0].getSelection()) {
            return 1;
        }
        if (this.limitToButtons[1].getSelection()) {
            return 2;
        }
        return 3;
    }

    private int getSearchFor() {
        if (this.searchForButtons[0].getSelection()) {
            return 1;
        }
        if (this.searchForButtons[1].getSelection()) {
            return 2;
        }
        return 3;
    }

    private Set<IResource> getSelectedResources() {
        HashSet<IResource> result;
        block8: {
            IWorkingSet[] workingSets;
            int scope;
            block6: {
                block7: {
                    result = new HashSet<IResource>();
                    scope = this.container.getSelectedScope();
                    if (scope == 0) {
                        return null;
                    }
                    if (scope != 1 && scope != 3) break block6;
                    if (!(this.container.getSelection() instanceof IStructuredSelection)) break block7;
                    IStructuredSelection selection = (IStructuredSelection)this.container.getSelection();
                    for (Object item : selection) {
                        if (!(item instanceof IResource)) continue;
                        result.add((IResource)((IResource)item).getProject());
                    }
                    break block8;
                }
                if (this.container.getActiveEditorInput() == null) break block8;
                result.add((IResource)this.container.getActiveEditorInput().getAdapter(IFile.class));
                break block8;
            }
            if (scope == 2 && (workingSets = this.container.getSelectedWorkingSets()) != null) {
                IWorkingSet[] iWorkingSetArray = workingSets;
                int n = workingSets.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable[] elements;
                    IWorkingSet workingSet = iWorkingSetArray[n2];
                    IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAdaptable element = iAdaptableArray[n4];
                        IResource resource = (IResource)element.getAdapter(IResource.class);
                        if (resource != null) {
                            result.add((IResource)resource.getProject());
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    private int getWorkspaceScope() {
        return switch (this.container.getSelectedScope()) {
            case 1 -> 1;
            case 2 -> 2;
            default -> 0;
        };
    }

    private void hookListeners() {
        this.searchForButtons[1].addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean selected = this.searchForButtons[1].getSelection();
            if (selected) {
                this.limitToButtons[0].setSelection(true);
                this.limitToButtons[1].setSelection(false);
                this.limitToButtons[2].setSelection(false);
            }
            this.limitToButtons[1].setEnabled(!selected);
            this.limitToButtons[2].setEnabled(!selected);
        }));
        this.patternCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int index = previousQueries.size() - this.patternCombo.getSelectionIndex() - 1;
            if (previousQueries.size() > index) {
                QueryData data = previousQueries.get(index);
                this.resetPage(data);
            }
            this.container.setPerformActionEnabled(this.patternCombo.getText().length() > 0);
        }));
        this.patternCombo.addModifyListener(e -> this.container.setPerformActionEnabled(this.patternCombo.getText().trim().length() > 0));
    }

    public boolean performAction() {
        this.saveQueryData();
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)new PluginSearchQuery(this.getInput()));
        return true;
    }

    private void resetPage(QueryData data) {
        this.caseSensitive.setSelection(data.isCaseSensitive);
        this.searchForButtons[0].setSelection(data.searchElement == 1);
        this.searchForButtons[1].setSelection(data.searchElement == 2);
        this.searchForButtons[2].setSelection(data.searchElement == 3);
        this.limitToButtons[0].setSelection(data.limit == 1);
        this.limitToButtons[1].setSelection(data.limit == 2);
        this.limitToButtons[1].setEnabled(!this.searchForButtons[1].getSelection());
        this.limitToButtons[2].setSelection(data.limit == 3);
        this.limitToButtons[2].setEnabled(!this.searchForButtons[1].getSelection());
        this.externalScopeButtons[0].setSelection(data.externalScope == 2);
        this.externalScopeButtons[1].setSelection(data.externalScope == 1);
        this.externalScopeButtons[2].setSelection(data.externalScope == 0);
        this.container.setSelectedScope(data.workspaceScope);
        if (data.workingSets != null) {
            this.container.setSelectedWorkingSets(data.workingSets);
        }
    }

    private void saveQueryData() {
        QueryData data = new QueryData();
        data.text = this.patternCombo.getText();
        data.isCaseSensitive = this.caseSensitive.getSelection();
        data.searchElement = this.getSearchFor();
        data.limit = this.getLimitTo();
        data.externalScope = this.getExternalScope();
        data.workspaceScope = this.container.getSelectedScope();
        data.workingSets = this.container.getSelectedWorkingSets();
        if (previousQueries.contains(data)) {
            previousQueries.remove(data);
        }
        previousQueries.add(data);
        if (previousQueries.size() > 10) {
            previousQueries.remove(0);
        }
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public void setVisible(boolean visible) {
        IEditorInput editorInput;
        if (visible && this.patternCombo != null) {
            if (this.firstTime) {
                this.firstTime = false;
                String[] patterns = new String[previousQueries.size()];
                int i = previousQueries.size() - 1;
                int j = 0;
                while (i >= 0) {
                    patterns[j] = PluginSearchPage.previousQueries.get((int)i).text;
                    --i;
                    ++j;
                }
                this.patternCombo.setItems(patterns);
                this.initSelections();
                this.container.setPerformActionEnabled(this.patternCombo.getText().length() > 0);
            }
            this.patternCombo.setFocus();
        }
        this.container.setActiveEditorCanProvideScopeSelection((editorInput = this.container.getActiveEditorInput()) != null && editorInput.getAdapter(IFile.class) != null);
        super.setVisible(visible);
    }

    private void initSelections() {
        ISelection selection = this.container.getSelection();
        if (selection instanceof TextSelection) {
            this.patternCombo.setText(((TextSelection)selection).getText());
        }
    }

    static class QueryData {
        public String text;
        public boolean isCaseSensitive;
        public int searchElement;
        public int limit;
        public int externalScope;
        public int workspaceScope;
        public IWorkingSet[] workingSets;

        QueryData() {
        }

        public boolean equals(Object obj) {
            return obj instanceof QueryData && ((QueryData)obj).text.equals(this.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }
    }
}

