/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.update.configurator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.update.configurator.Configuration;
import org.eclipse.pde.internal.core.update.configurator.FeatureEntry;
import org.eclipse.pde.internal.core.update.configurator.FeatureParser;
import org.eclipse.pde.internal.core.update.configurator.IConfigurationConstants;
import org.eclipse.pde.internal.core.update.configurator.Messages;
import org.eclipse.pde.internal.core.update.configurator.PlatformConfiguration;
import org.eclipse.pde.internal.core.update.configurator.SitePolicy;
import org.eclipse.pde.internal.core.update.configurator.Utils;
import org.eclipse.pde.internal.core.update.configurator.VersionedIdentifier;

@Deprecated
public class SiteEntry
implements IConfigurationConstants {
    private static final String MAC_OS_MARKER = ".DS_Store";
    private URL url;
    private URL resolvedURL;
    private SitePolicy policy;
    private boolean updateable = true;
    private Map<String, FeatureEntry> featureEntries;
    private long changeStamp;
    private long featuresChangeStamp;
    private long pluginsChangeStamp;
    private String linkFileName;
    private boolean enabled = true;
    private Configuration config;
    private static FeatureParser featureParser = new FeatureParser();
    private static boolean isMacOS = Utils.getOS().equals("macosx");

    @Deprecated
    public SiteEntry(URL url) {
        this(url, null);
    }

    @Deprecated
    public SiteEntry(URL url, SitePolicy policy) {
        if (url == null) {
            try {
                url = new URL("platform:/base/");
            }
            catch (MalformedURLException e) {
                url = PlatformConfiguration.getInstallURL();
            }
        }
        if (policy == null) {
            policy = new SitePolicy(PlatformConfiguration.getDefaultPolicy(), DEFAULT_POLICY_LIST);
        }
        if (url.getProtocol().equals("file")) {
            try {
                this.url = new File(url.getFile()).toURL();
            }
            catch (MalformedURLException e1) {
                this.url = url;
            }
        } else {
            this.url = url;
        }
        this.policy = policy;
        this.resolvedURL = this.url;
    }

    @Deprecated
    public void setConfig(Configuration config) {
        this.config = config;
        if (this.url.getProtocol().equals("platform")) {
            try {
                if (this.url.getPath().startsWith("/config")) {
                    URL configURL = config.getURL();
                    URL config_loc = new URL(configURL, "..");
                    this.resolvedURL = PlatformConfiguration.resolvePlatformURL(this.url, config_loc);
                } else {
                    this.resolvedURL = PlatformConfiguration.resolvePlatformURL(this.url, config.getInstallURL());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public Configuration getConfig() {
        return this.config;
    }

    @Deprecated
    public URL getURL() {
        return this.url;
    }

    @Deprecated
    public SitePolicy getSitePolicy() {
        return this.policy;
    }

    @Deprecated
    public synchronized void setSitePolicy(SitePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.policy = policy;
    }

    @Deprecated
    public String[] getFeatures() {
        return this.getDetectedFeatures();
    }

    @Deprecated
    public long getChangeStamp() {
        if (this.changeStamp == 0L) {
            this.computeChangeStamp();
        }
        return this.changeStamp;
    }

    @Deprecated
    public long getFeaturesChangeStamp() {
        if (this.featuresChangeStamp == 0L) {
            this.computeFeaturesChangeStamp();
        }
        return this.featuresChangeStamp;
    }

    @Deprecated
    public long getPluginsChangeStamp() {
        if (this.pluginsChangeStamp == 0L) {
            this.computePluginsChangeStamp();
        }
        return this.pluginsChangeStamp;
    }

    @Deprecated
    public boolean isUpdateable() {
        return this.updateable;
    }

    @Deprecated
    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    @Deprecated
    public boolean isNativelyLinked() {
        return this.isExternallyLinkedSite();
    }

    @Deprecated
    public URL getResolvedURL() {
        return this.resolvedURL;
    }

    private void detectFeatures() {
        if (this.featureEntries != null) {
            this.validateFeatureEntries();
        } else {
            this.featureEntries = new HashMap<String, FeatureEntry>();
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            return;
        }
        File siteRoot = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File featuresDir = new File(siteRoot, "features");
        if (featuresDir.exists()) {
            File[] dirs;
            File[] fileArray = dirs = featuresDir.listFiles(f -> {
                boolean valid;
                if (isMacOS && f.getName().equals(MAC_OS_MARKER)) {
                    return false;
                }
                boolean bl = valid = f.isDirectory() && new File(f, "feature.xml").exists();
                if (!valid) {
                    Utils.log(NLS.bind((String)Messages.SiteEntry_cannotFindFeatureInDir, (Object[])new String[]{f.getAbsolutePath()}));
                }
                return valid;
            });
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                try {
                    URL featureURL;
                    FeatureEntry featureEntry;
                    File featureXML = new File(dir, "feature.xml");
                    if ((featureXML.lastModified() > this.featuresChangeStamp || dir.lastModified() > this.featuresChangeStamp) && (featureEntry = featureParser.parse(featureURL = featureXML.toURL())) != null) {
                        this.addFeatureEntry(featureEntry);
                    }
                }
                catch (MalformedURLException e) {
                    Utils.log(NLS.bind((String)Messages.InstalledSiteParser_UnableToCreateURLForFile, (Object[])new String[]{featuresDir.getAbsolutePath()}));
                }
                ++n2;
            }
        }
    }

    private synchronized String[] getDetectedFeatures() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        String[] features = new String[this.featureEntries.size()];
        Iterator<FeatureEntry> iterator = this.featureEntries.values().iterator();
        int i = 0;
        while (i < features.length) {
            features[i] = iterator.next().getURL();
            ++i;
        }
        return features;
    }

    private void computeChangeStamp() {
        this.changeStamp = Math.max(this.computeFeaturesChangeStamp(), this.computePluginsChangeStamp());
    }

    private synchronized long computeFeaturesChangeStamp() {
        if (this.featuresChangeStamp > 0L) {
            return this.featuresChangeStamp;
        }
        String[] features = this.getFeatures();
        long dirStamp = 0L;
        if (PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            File featuresDir = new File(root, "features");
            dirStamp = featuresDir.lastModified();
        }
        this.featuresChangeStamp = Math.max(dirStamp, this.computeStamp(features));
        return this.featuresChangeStamp;
    }

    private synchronized long computePluginsChangeStamp() {
        if (this.pluginsChangeStamp > 0L) {
            return this.pluginsChangeStamp;
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) {
            Utils.log(NLS.bind((String)Messages.SiteEntry_computePluginStamp, (Object[])new String[]{this.resolvedURL.toExternalForm()}));
            return 0L;
        }
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File pluginsDir = new File(root, "plugins");
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            return 0L;
        }
        this.pluginsChangeStamp = pluginsDir.lastModified();
        return this.pluginsChangeStamp;
    }

    private long computeStamp(String[] targets) {
        long result;
        block4: {
            block3: {
                result = 0L;
                if (PlatformConfiguration.supportsDetection(this.resolvedURL, this.config.getInstallURL())) break block3;
                String[] stringArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    String target = stringArray[n2];
                    result ^= (long)target.hashCode();
                    ++n2;
                }
                break block4;
            }
            File rootFile = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            if (!rootFile.exists()) break block4;
            File f = null;
            String[] stringArray = targets;
            int n = targets.length;
            int n3 = 0;
            while (n3 < n) {
                String target = stringArray[n3];
                f = new File(rootFile, target);
                if (f.exists()) {
                    result = Math.max(result, f.lastModified());
                }
                ++n3;
            }
        }
        return result;
    }

    @Deprecated
    public void setLinkFileName(String linkFileName) {
        this.linkFileName = linkFileName;
    }

    @Deprecated
    public String getLinkFileName() {
        return this.linkFileName;
    }

    @Deprecated
    public boolean isExternallyLinkedSite() {
        return this.linkFileName != null && !this.linkFileName.trim().isEmpty();
    }

    @Deprecated
    public void addFeatureEntry(FeatureEntry feature) {
        FeatureEntry existing;
        if (this.featureEntries == null) {
            this.featureEntries = new HashMap<String, FeatureEntry>();
        }
        if ((existing = this.featureEntries.get(feature.getFeatureIdentifier())) != null) {
            VersionedIdentifier existingVersion = new VersionedIdentifier(existing.getFeatureIdentifier(), existing.getFeatureVersion());
            VersionedIdentifier newVersion = new VersionedIdentifier(feature.getFeatureIdentifier(), feature.getFeatureVersion());
            if (existingVersion.getVersion().compareTo(newVersion.getVersion()) < 0) {
                this.featureEntries.put(feature.getFeatureIdentifier(), feature);
                this.pluginsChangeStamp = 0L;
            } else if (existingVersion.equals(newVersion) && !feature.getURL().equals(existing.getURL())) {
                Utils.log(NLS.bind((String)Messages.SiteEntry_duplicateFeature, (Object[])new String[]{this.getURL().toExternalForm(), existing.getFeatureIdentifier()}));
            }
        } else {
            this.featureEntries.put(feature.getFeatureIdentifier(), feature);
            this.pluginsChangeStamp = 0L;
        }
        feature.setSite(this);
    }

    @Deprecated
    public FeatureEntry[] getFeatureEntries() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        if (this.featureEntries == null) {
            return new FeatureEntry[0];
        }
        return this.featureEntries.values().toArray(new FeatureEntry[this.featureEntries.size()]);
    }

    private void validateFeatureEntries() {
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        Iterator<FeatureEntry> iterator = this.featureEntries.values().iterator();
        ArrayList<String> deletedFeatures = new ArrayList<String>();
        while (iterator.hasNext()) {
            FeatureEntry feature = iterator.next();
            File featureXML = new File(root, feature.getURL());
            if (featureXML.exists()) continue;
            deletedFeatures.add(feature.getFeatureIdentifier());
        }
        for (String string : deletedFeatures) {
            this.featureEntries.remove(string);
        }
    }

    @Deprecated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    @Deprecated
    public FeatureEntry getFeatureEntry(String id) {
        FeatureEntry[] featureEntryArray = this.getFeatureEntries();
        int n = featureEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry feature = featureEntryArray[n2];
            if (feature.getFeatureIdentifier().equals(id)) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    public boolean unconfigureFeatureEntry(FeatureEntry feature) {
        FeatureEntry existingFeature = this.getFeatureEntry(feature.getFeatureIdentifier());
        if (existingFeature != null) {
            this.featureEntries.remove(existingFeature.getFeatureIdentifier());
        }
        return existingFeature != null;
    }

    @Deprecated
    public void initialized() {
        if (this.featureEntries == null) {
            this.featureEntries = new HashMap<String, FeatureEntry>();
        }
    }
}

