/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IListener;

public class ContainerElementList<ELEMENT>
extends Container<ELEMENT> {
    private final IListener containerListener = new ContainerEventAdapter<Object>(){

        @Override
        protected void onAdded(IContainer<Object> container, Object object) {
            this.modify(object, ContainerElementList.this.elementList::add, ContainerElementList.this::fireElementAddedEvent);
        }

        @Override
        protected synchronized void onRemoved(IContainer<Object> container, Object object) {
            this.modify(object, ContainerElementList.this.elementList::remove, ContainerElementList.this::fireElementRemovedEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void modify(Object object, Predicate<ELEMENT> listModifier, Consumer<ELEMENT> notifier) {
            if (ContainerElementList.this.testElement(object)) {
                boolean modified;
                Object element = ContainerElementList.this.elementType.cast(object);
                List list = ContainerElementList.this.elementList;
                synchronized (list) {
                    modified = listModifier.test(element);
                    if (modified) {
                        ContainerElementList.this.elements = null;
                    }
                }
                if (modified) {
                    notifier.accept(element);
                }
            }
        }
    };
    private final IManagedContainer container;
    private final Class<ELEMENT> elementType;
    private final List<ELEMENT> elementList = new ArrayList<ELEMENT>();
    private ELEMENT[] elements;

    public ContainerElementList(Class<ELEMENT> elementType, IManagedContainer container) {
        this.elementType = elementType;
        this.container = container;
    }

    public ContainerElementList(Class<ELEMENT> elementType) {
        this(elementType, IPluginContainer.INSTANCE);
    }

    public final IManagedContainer getContainer() {
        return this.container;
    }

    public final Class<ELEMENT> getElementType() {
        return this.elementType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        this.checkActive();
        List<ELEMENT> list = this.elementList;
        synchronized (list) {
            return this.elementList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ELEMENT[] getElements() {
        this.checkActive();
        List<ELEMENT> list = this.elementList;
        synchronized (list) {
            if (this.elements == null) {
                Object[] array = (Object[])Array.newInstance(this.elementType, this.elementList.size());
                this.elementList.toArray(array);
                this.elements = this.postProcessElementArray(array);
            }
            return this.elements;
        }
    }

    public final boolean forEachElement(Predicate<ELEMENT> handler) {
        ELEMENT[] ELEMENTArray = this.getElements();
        int n = ELEMENTArray.length;
        int n2 = 0;
        while (n2 < n) {
            ELEMENT element = ELEMENTArray[n2];
            if (handler.test(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected final void initContainerElements(String productGroup, String type, String description) {
        if (type == null) {
            for (String factoryType : this.container.getFactoryTypes(productGroup)) {
                this.container.getElementOrNull(productGroup, factoryType, description);
            }
        } else {
            this.container.getElementOrNull(productGroup, type, description);
        }
    }

    protected final void initContainerElements(String productGroup, String type) {
        this.initContainerElements(productGroup, type, null);
    }

    protected final void initContainerElements(String productGroup) {
        this.initContainerElements(productGroup, null);
    }

    protected ELEMENT[] postProcessElementArray(ELEMENT[] elements) {
        if (Comparable.class.isAssignableFrom(this.elementType)) {
            Arrays.sort(elements, null);
        }
        return elements;
    }

    protected Object[] getInitialElements(IManagedContainer container) {
        return container.getElements();
    }

    protected boolean testElement(Object object) {
        return this.elementType.isInstance(object);
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        Object[] objectArray = this.getInitialElements(this.container);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (this.testElement(object)) {
                ELEMENT element = this.elementType.cast(object);
                this.elementList.add(element);
            }
            ++n2;
        }
        this.container.addListener(this.containerListener);
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.container.removeListener(this.containerListener);
        this.elementList.clear();
        this.elements = null;
        super.doDeactivate();
    }

    public static interface Prioritized
    extends Comparable<Prioritized> {
        public int getPriority();

        @Override
        default public int compareTo(Prioritized o) {
            return Integer.compare(this.getPriority(), o.getPriority());
        }
    }
}

