/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.ui.libprov.user;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.UserLibraryManager;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.ui.internal.FacetedProjectFrameworkJavaExtUiPlugin;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderOperationPanel;
import org.eclipse.jst.common.project.facet.ui.libprov.user.internal.DownloadLibraryWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;

public class UserLibraryProviderInstallPanel
extends LibraryProviderOperationPanel {
    private Composite rootComposite = null;
    private CheckboxTableViewer libsTableViewer = null;
    private MenuItem downloadLibraryMenuItem = null;
    private ToolItem downloadLibraryButton = null;
    private boolean downloadCommandEnabled = true;

    @Override
    public Control createControl(Composite parent) {
        this.rootComposite = new Composite(parent, 0);
        this.rootComposite.setLayout((Layout)GridLayoutUtil.gl((int)1, (int)0, (int)0));
        Composite tableComposite = new Composite(this.rootComposite, 0);
        tableComposite.setLayoutData((Object)GridLayoutUtil.gdhfill());
        tableComposite.setLayout((Layout)GridLayoutUtil.gl((int)2, (int)0, (int)0));
        final Table libsTable = new Table(tableComposite, 2080);
        libsTable.setLayoutData((Object)GridLayoutUtil.gdhhint((GridData)GridLayoutUtil.gdhfill(), (int)60));
        this.libsTableViewer = new CheckboxTableViewer(libsTable);
        this.libsTableViewer.setContentProvider((IContentProvider)new LibrariesContentProvider());
        this.libsTableViewer.setLabelProvider((IBaseLabelProvider)new LibrariesLabelProvider());
        this.libsTableViewer.setComparator(new ViewerComparator());
        this.libsTableViewer.setInput(new Object());
        final UserLibraryProviderInstallOperationConfig cfg = (UserLibraryProviderInstallOperationConfig)this.getOperationConfig();
        this.libsTableViewer.setCheckedElements(cfg.getLibraryNames().toArray());
        this.libsTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ArrayList<String> libs = new ArrayList<String>();
                Object[] objectArray = UserLibraryProviderInstallPanel.this.libsTableViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    libs.add((String)element);
                    ++n2;
                }
                cfg.setLibraryNames(libs);
            }
        });
        final IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChanged(String property, Object oldValue, Object newValue) {
                UserLibraryProviderInstallPanel.this.handleLibraryNamesChanged();
            }
        };
        cfg.addListener(listener, new String[]{UserLibraryProviderInstallOperationConfig.PROP_LIBRARY_NAMES});
        final Image manageLibrariesImage = FacetedProjectFrameworkJavaExtUiPlugin.getImageDescriptor("images/buttons/manage-libraries.gif").createImage();
        final Image downloadLibraryImage = FacetedProjectFrameworkJavaExtUiPlugin.getImageDescriptor("images/buttons/download.png").createImage();
        Menu menu = new Menu((Control)libsTable);
        libsTable.setMenu(menu);
        ToolBar toolBar = new ToolBar(tableComposite, 0x800200);
        toolBar.setLayoutData((Object)GridLayoutUtil.gdvfill());
        SelectionAdapter manageLibrariesListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Shell shell = libsTable.getShell();
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage", (String[])new String[]{"org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage"}, null);
                if (dialog.open() == 0) {
                    UserLibraryProviderInstallPanel.this.libsTableViewer.refresh();
                    List libNames = cfg.getLibraryNames();
                    cfg.notifyListeners("validation", (Object)libNames, (Object)libNames);
                }
            }
        };
        MenuItem manageLibrariesMenuItem = new MenuItem(menu, 8);
        manageLibrariesMenuItem.setText(Resources.manageLibrariesMenuItem);
        manageLibrariesMenuItem.setImage(manageLibrariesImage);
        manageLibrariesMenuItem.addSelectionListener((SelectionListener)manageLibrariesListener);
        ToolItem manageLibrariesButton = new ToolItem(toolBar, 8);
        manageLibrariesButton.setImage(manageLibrariesImage);
        manageLibrariesButton.setToolTipText(Resources.manageLibrariesButtonToolTip);
        manageLibrariesButton.addSelectionListener((SelectionListener)manageLibrariesListener);
        SelectionAdapter downloadLibraryListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UserLibraryProviderInstallOperationConfig cfg = (UserLibraryProviderInstallOperationConfig)UserLibraryProviderInstallPanel.this.getOperationConfig();
                String downloadedLibraryName = DownloadLibraryWizard.open(cfg);
                if (downloadedLibraryName != null) {
                    UserLibraryProviderInstallPanel.this.refreshLibrariesList();
                    cfg.addLibraryName(downloadedLibraryName);
                }
            }
        };
        this.downloadLibraryMenuItem = new MenuItem(menu, 8);
        this.downloadLibraryMenuItem.setText(Resources.downloadLibraryMenuItem);
        this.downloadLibraryMenuItem.setImage(downloadLibraryImage);
        this.downloadLibraryMenuItem.setEnabled(this.downloadCommandEnabled);
        this.downloadLibraryMenuItem.addSelectionListener((SelectionListener)downloadLibraryListener);
        this.downloadLibraryButton = new ToolItem(toolBar, 8);
        this.downloadLibraryButton.setImage(downloadLibraryImage);
        this.downloadLibraryButton.setToolTipText(Resources.downloadLibraryButtonToolTip);
        this.downloadLibraryButton.setEnabled(this.downloadCommandEnabled);
        this.downloadLibraryButton.addSelectionListener((SelectionListener)downloadLibraryListener);
        Control footerControl = this.createFooter(this.rootComposite);
        if (footerControl != null) {
            footerControl.setLayoutData((Object)GridLayoutUtil.gdhfill());
        }
        this.rootComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                cfg.removeListener(listener);
                manageLibrariesImage.dispose();
                downloadLibraryImage.dispose();
            }
        });
        return this.rootComposite;
    }

    protected Control createFooter(Composite parent) {
        return this.createControlNextToManageHyperlink(parent);
    }

    protected Control createControlNextToManageHyperlink(Composite parent) {
        return null;
    }

    protected void setDownloadCommandEnabled(boolean enabled) {
        this.downloadCommandEnabled = enabled;
        if (this.downloadLibraryButton != null) {
            this.downloadLibraryButton.setEnabled(enabled);
        }
        if (this.downloadLibraryMenuItem != null) {
            this.downloadLibraryMenuItem.setEnabled(enabled);
        }
    }

    private void handleLibraryNamesChanged() {
        if (this.rootComposite.getDisplay().getThread() != Thread.currentThread()) {
            this.rootComposite.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    UserLibraryProviderInstallPanel.this.handleLibraryNamesChanged();
                }
            });
            return;
        }
        UserLibraryProviderInstallOperationConfig cfg = (UserLibraryProviderInstallOperationConfig)this.getOperationConfig();
        this.libsTableViewer.setCheckedElements(cfg.getLibraryNames().toArray());
    }

    private void refreshLibrariesList() {
        this.libsTableViewer.refresh();
    }

    private static final class LibrariesContentProvider
    implements IStructuredContentProvider {
        private LibrariesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            UserLibraryManager userLibManager = JavaModelManager.getUserLibraryManager();
            return userLibManager.getUserLibraryNames();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static final class LibrariesLabelProvider
    extends LabelProvider {
        private final Image libraryImage = FacetedProjectFrameworkJavaExtUiPlugin.getImageDescriptor("images/objects/library.gif").createImage();

        private LibrariesLabelProvider() {
        }

        public Image getImage(Object element) {
            return this.libraryImage;
        }

        public String getText(Object element) {
            return (String)element;
        }

        public void dispose() {
            this.libraryImage.dispose();
        }
    }

    private static final class Resources
    extends NLS {
        public static String manageLibrariesMenuItem;
        public static String manageLibrariesButtonToolTip;
        public static String downloadLibraryMenuItem;
        public static String downloadLibraryButtonToolTip;

        static {
            Resources.initializeMessages((String)UserLibraryProviderInstallPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

