/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp.ssl;

import java.text.MessageFormat;
import org.eclipse.net4j.TransportConfigurator;
import org.eclipse.net4j.internal.tcp.TCPAcceptor;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.internal.tcp.ssl.SSLServerConnector;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.w3c.dom.Element;

public class SSLAcceptor
extends TCPAcceptor {
    public boolean needsBufferProvider() {
        return false;
    }

    @Override
    public String toString() {
        return MessageFormat.format("SSLAcceptor[{0}:{1}]", this.getAddress(), this.getPort());
    }

    @Override
    protected TCPConnector createConnector() {
        return new SSLServerConnector(this);
    }

    public static class DescriptionParserFactory
    extends TransportConfigurator.AcceptorDescriptionParser.Factory
    implements TransportConfigurator.AcceptorDescriptionParser {
        public DescriptionParserFactory() {
            super("ssl");
        }

        public TransportConfigurator.AcceptorDescriptionParser create(String description) throws ProductCreationException {
            return this;
        }

        public String getAcceptorDescription(Element acceptorConfig) {
            String listenAddr = acceptorConfig.getAttribute("listenAddr");
            String port = acceptorConfig.getAttribute("port");
            return String.valueOf(listenAddr == null ? "" : listenAddr) + (StringUtil.isEmpty((String)port) ? "" : ":" + port);
        }
    }
}

