/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetTransferData;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class MakeTargetTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "make-target-transfer-format";
    private static final int TYPEID = MakeTargetTransfer.registerType((String)"make-target-transfer-format");
    private static MakeTargetTransfer instance = new MakeTargetTransfer();

    private MakeTargetTransfer() {
    }

    public static MakeTargetTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (object instanceof MakeTargetTransferData) {
            MakeTargetTransferData realData = (MakeTargetTransferData)object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(out);
                dataOut.writeInt(realData.getMakeTargetDataList().size());
                for (MakeTargetTransferData.MakeTargetData mtd : realData.getMakeTargetDataList()) {
                    dataOut.writeUTF(mtd.getName());
                    dataOut.writeBoolean(mtd.runAllBuilders());
                    dataOut.writeBoolean(mtd.appendProjectEnvironment());
                    dataOut.writeUTF(mtd.getBuildTarget());
                    dataOut.writeUTF(mtd.getBuildCommand());
                    dataOut.writeUTF(mtd.getBuildArguments());
                    dataOut.writeBoolean(mtd.isStopOnError());
                    dataOut.writeBoolean(mtd.isDefaultBuildCmd());
                    dataOut.writeBoolean(mtd.appendEnvironment());
                }
                dataOut.close();
                super.javaToNative((Object)out.toByteArray(), transferData);
            }
            catch (IOException e) {
                MakeUIPlugin.log(e);
            }
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream dataIn = new DataInputStream(in);
        try {
            MakeTargetTransferData mttd = new MakeTargetTransferData();
            int size = dataIn.readInt();
            int i = 0;
            while (i < size) {
                String name = dataIn.readUTF();
                boolean runAllBuilders = dataIn.readBoolean();
                boolean appendProjectEnvironment = dataIn.readBoolean();
                String buildTarget = dataIn.readUTF();
                String buildCommand = dataIn.readUTF();
                String buildArguments = dataIn.readUTF();
                boolean stopOnError = dataIn.readBoolean();
                boolean useDefaultBuildCmd = dataIn.readBoolean();
                boolean appendEnvironment = dataIn.readBoolean();
                mttd.addMakeTarget(name, runAllBuilders, appendProjectEnvironment, buildTarget, buildCommand, buildArguments, stopOnError, useDefaultBuildCmd, appendEnvironment);
                ++i;
            }
            return mttd;
        }
        catch (IOException e) {
            MakeUIPlugin.log(e);
            return null;
        }
    }
}

