/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.engine.ConfigurationParameters;

enum LauncherPhase {
    DISCOVERY,
    EXECUTION;


    static Optional<LauncherPhase> getDiscoveryIssueFailurePhase(ConfigurationParameters configurationParameters) {
        Function<String, @Nullable LauncherPhase> stringLauncherPhaseFunction = value -> {
            try {
                return LauncherPhase.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new JUnitException("Invalid LauncherPhase '%s' set via the '%s' configuration parameter.".formatted(value, "junit.platform.discovery.issue.failure.phase"));
            }
        };
        return configurationParameters.get("junit.platform.discovery.issue.failure.phase", stringLauncherPhaseFunction);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }
}

