/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvScanner;

final class ByteChannelStream {
    private final ByteBuffer byteBuf = ByteBuffer.allocateDirect(8192);
    private final ReadableByteChannel channel;
    private final CsvScanner.CsvListener csvListener;
    private long offset = -1L;
    private int nextByte;
    private final Buffer buf = this.byteBuf;

    ByteChannelStream(ReadableByteChannel channel, CsvScanner.CsvListener csvListener) throws IOException {
        this.channel = channel;
        this.csvListener = csvListener;
        this.nextByte = this.loadData() ? (int)this.byteBuf.get() : -1;
    }

    int get() throws IOException {
        if (this.nextByte == -1) {
            return -1;
        }
        int ret = this.nextByte;
        this.nextByte = this.fetchNextByte();
        ++this.offset;
        return ret;
    }

    boolean consumeIfNextEq(int val) throws IOException {
        if (this.nextByte != val) {
            return false;
        }
        this.nextByte = this.fetchNextByte();
        ++this.offset;
        return true;
    }

    boolean hasData() {
        return this.nextByte != -1;
    }

    long getOffset() {
        return this.offset;
    }

    private int fetchNextByte() throws IOException {
        return this.buf.hasRemaining() || this.loadData() ? (int)this.byteBuf.get() : -1;
    }

    private boolean loadData() throws IOException {
        this.buf.clear();
        int readCnt = this.channel.read(this.byteBuf);
        this.buf.flip();
        if (readCnt != -1) {
            this.csvListener.onReadBytes(readCnt);
            return true;
        }
        return false;
    }
}

