/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model.ui;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.ErrorMessageTextField;

public final class DimensionSpecificationComposite
extends Composite {
    private MigDimensionInfo m_dimension;
    private final ErrorMessageTextField m_field;
    private final Text m_textWidget;
    private boolean m_updatingDimension;
    private final Listener m_listener = new Listener(){

        public void handleEvent(Event e) {
            String s = DimensionSpecificationComposite.this.m_textWidget.getText();
            DimensionSpecificationComposite.this.toDimension(s);
        }
    };

    public DimensionSpecificationComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.m_field = new ErrorMessageTextField(this, 2048);
        this.m_textWidget = (Text)this.m_field.getControl();
        this.m_textWidget.addListener(24, this.m_listener);
    }

    public boolean setFocus() {
        return this.m_textWidget.setFocus();
    }

    public void fromDimension(MigDimensionInfo dimension) {
        if (!this.m_updatingDimension) {
            this.m_dimension = dimension;
            String specification = this.m_dimension.getString(false);
            if (!this.m_textWidget.getText().equals(specification)) {
                this.setText(specification);
            }
        }
    }

    private void toDimension(String s) {
        this.m_updatingDimension = true;
        try {
            try {
                this.m_dimension.setString(s);
                this.notifyModified(true);
                this.m_field.setErrorMessage(null);
            }
            catch (Throwable e) {
                this.notifyModified(false);
                this.m_field.setErrorMessage(e.getMessage());
                this.m_updatingDimension = false;
            }
        }
        finally {
            this.m_updatingDimension = false;
        }
    }

    private void notifyModified(boolean valid) {
        Event event = new Event();
        event.doit = valid;
        this.notifyListeners(24, event);
    }

    private void setText(String text) {
        this.m_textWidget.removeListener(24, this.m_listener);
        try {
            this.m_textWidget.setText(text);
            this.m_field.setErrorMessage(null);
        }
        finally {
            this.m_textWidget.addListener(24, this.m_listener);
        }
    }
}

