/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.os.linux;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.os.linux.Activator;
import org.eclipse.wb.internal.os.linux.GdkRectangle;
import org.eclipse.wb.internal.os.linux.GtkAllocation;
import org.eclipse.wb.internal.swt.VisualDataMockupProvider;
import org.eclipse.wb.os.OSSupport;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public abstract class OSSupportLinux
extends OSSupport {
    private static Version MINIMUM_VERSION = new Version(3, 126, 0);
    private static final Color TITLE_BORDER_COLOR_DARKEST = DrawUtils.getShiftedColor((Color)ColorConstants.titleBackground, (int)-24);
    private static final Color TITLE_BORDER_COLOR_DARKER = DrawUtils.getShiftedColor((Color)ColorConstants.titleBackground, (int)-16);
    protected static final OSSupport INSTANCE;
    private Map<Long, Control> m_controlsRegistry;
    private boolean m_eclipseToggledOnTop;
    private Shell m_eclipseShell;

    static {
        System.loadLibrary("wbp3");
        INSTANCE = new Impl64();
    }

    private void prepareScreenshot(Shell shell) throws Exception {
        this.createRegistry();
        this.registerControl((Control)shell);
        this.registerByHandle((Control)shell, "shellHandle");
    }

    private void createRegistry() {
        this.m_controlsRegistry = new HashMap<Long, Control>();
    }

    private void registerControl(Control control) throws Exception {
        Point size = control.getSize();
        if (size.x == 0 || size.y == 0) {
            return;
        }
        this.registerByHandle(control, "fixedHandle");
        this.registerByHandle(control, "handle");
        control.setData("WBP_IMAGE", null);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.registerControl(child);
                ++n2;
            }
        }
    }

    private void registerByHandle(Control control, String handleName) throws Exception {
        long handle = this.getHandleValue(control, handleName);
        if (handle != 0L) {
            this.m_controlsRegistry.put(handle, control);
        }
    }

    private Shell getShell(Object controlObject) {
        Assert.instanceOf(Control.class, (Object)controlObject);
        Control control = (Control)controlObject;
        return control.getShell();
    }

    public void beginShot(Object controlObject) {
        Shell shell = this.layoutShell(controlObject);
        if (!this.isWorkaroundsDisabled()) {
            OSSupportLinux._gtk_widget_show_now(this.getShellHandle(shell));
            try {
                Version currentVersion = FrameworkUtil.getBundle(SWT.class).getVersion();
                if (currentVersion.compareTo(MINIMUM_VERSION) < 0) {
                    ReflectionUtils.invokeMethod((Object)shell, (String)"adjustTrim()", (Object[])new Object[0]);
                } else {
                    ReflectionUtils.invokeMethod((Object)shell, (String)"adjustTrim(int,int)", (Object[])new Object[]{-1, -1});
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
            this.m_eclipseShell = DesignerPlugin.getShell();
            if (this.m_eclipseShell != null) {
                OSSupportLinux._gtk_window_set_keep_above(this.getShellHandle(this.m_eclipseShell), true);
            }
        }
        shell.setLocation(10000, 10000);
        shell.setVisible(true);
    }

    public void endShot(Object controlObject) {
        super.endShot(controlObject);
        Shell shell = this.getShell(controlObject);
        if (!this.isWorkaroundsDisabled()) {
            OSSupportLinux._gtk_widget_hide(this.getShellHandle(shell));
            if (this.m_eclipseShell != null) {
                OSSupportLinux._gtk_window_set_keep_above(this.getShellHandle(this.m_eclipseShell), false);
            }
        }
    }

    public void makeShots(Object controlObject) throws Exception {
        Shell shell = this.getShell(controlObject);
        this.makeShots0(shell);
        this.drawDecorations(shell, shell.getDisplay());
    }

    private void makeShots0(Shell shell) throws Exception {
        this.prepareScreenshot(shell);
        HashSet disposeImages = new HashSet();
        this.makeShot(shell, (handle, image) -> {
            Control imageForControl = this.m_controlsRegistry.get(handle);
            if (imageForControl == null || !this.bindImage(imageForControl, (Image)image)) {
                disposeImages.add(image);
            }
        });
        for (Image image2 : disposeImages) {
            image2.dispose();
        }
    }

    private void drawDecorations(Shell shell, Display display) {
        Image shellImage = (Image)shell.getData("WBP_IMAGE");
        if (shellImage != null && (shell.getStyle() & 0x20) != 0) {
            Rectangle shellBounds = shell.getBounds();
            Rectangle imageBounds = shellImage.getBounds();
            Point offset = shell.toControl(shell.getLocation());
            offset.x = -offset.x;
            offset.y = -offset.y;
            if (shell.getMenuBar() != null) {
                offset.y -= this.getWidgetBounds((Object)shell.getMenuBar()).height;
            }
            Image decoratedShellImage = new Image((Device)display, shellBounds);
            GC gc = new GC((Drawable)decoratedShellImage);
            gc.setBackground(ColorConstants.titleBackground);
            gc.fillRectangle(0, 0, shellBounds.width, shellBounds.height);
            gc.setForeground(ColorConstants.titleGradient);
            gc.fillGradientRectangle(0, 0, shellBounds.width, offset.y, true);
            int buttonGapX = offset.x - 1;
            Image buttonImage = Activator.getImage("decorations/button-menu-icon.png");
            Rectangle buttonImageBounds = buttonImage.getBounds();
            int buttonOffsetY = offset.y / 2 - buttonImageBounds.height / 2;
            gc.drawImage(buttonImage, buttonGapX, buttonOffsetY);
            int nextPositionX = buttonGapX + buttonImageBounds.width + buttonGapX;
            buttonImage = Activator.getImage("decorations/button-close-icon.png");
            buttonImageBounds = buttonImage.getBounds();
            nextPositionX = shellBounds.width - buttonImageBounds.width - buttonGapX;
            buttonOffsetY = offset.y / 2 - buttonImageBounds.height / 2;
            gc.drawImage(buttonImage, nextPositionX, buttonOffsetY);
            buttonImage = Activator.getImage("decorations/button-max-icon.png");
            buttonImageBounds = buttonImage.getBounds();
            buttonOffsetY = offset.y / 2 - buttonImageBounds.height / 2;
            gc.drawImage(buttonImage, nextPositionX -= buttonGapX + buttonImageBounds.width, buttonOffsetY);
            buttonImage = Activator.getImage("decorations/button-min-icon.png");
            buttonImageBounds = buttonImage.getBounds();
            buttonOffsetY = offset.y / 2 - buttonImageBounds.height / 2;
            gc.drawImage(buttonImage, nextPositionX -= buttonGapX + buttonImageBounds.width, buttonOffsetY);
            gc.setForeground(TITLE_BORDER_COLOR_DARKEST);
            gc.drawRectangle(offset.x - 1, offset.y - 1, imageBounds.width + 1, imageBounds.height + 1);
            gc.setForeground(TITLE_BORDER_COLOR_DARKER);
            gc.drawRectangle(offset.x - 2, offset.y - 2, imageBounds.width + 3, imageBounds.height + 3);
            gc.drawImage(shellImage, offset.x, offset.y);
            gc.dispose();
            shellImage.dispose();
            shell.setData("WBP_IMAGE", (Object)decoratedShellImage);
        }
    }

    private boolean bindImage(Control control, Image image) {
        return (Boolean)ExecutionUtils.runObject(() -> {
            if (control.getData("WBP_NEED_IMAGE") != null && control.getData("WBP_IMAGE") == null) {
                control.setData("WBP_IMAGE", (Object)image);
                return true;
            }
            return false;
        });
    }

    public Image makeShot(Control control) throws Exception {
        Shell shell = this.getShell(control);
        shell.setLocation(10000, 10000);
        shell.setVisible(true);
        Rectangle controlBounds = control.getBounds();
        if (controlBounds.width == 0 || controlBounds.height == 0) {
            return null;
        }
        try {
            Image image = this.makeShot(shell, null);
            return image;
        }
        finally {
            shell.setVisible(false);
        }
    }

    protected abstract Image makeShot(Shell var1, BiConsumer<Long, Image> var2) throws Exception;

    private Rectangle getWidgetBounds(Object widget) {
        GtkAllocation rect = new GtkAllocation();
        long widgetHandle = this.getHandleValue(widget, "handle");
        OSSupportLinux._gtk_widget_get_allocation(widgetHandle, rect);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    protected long getShellHandle(Shell shell) {
        long widgetHandle = this.getHandleValue(shell, "fixedHandle");
        if (widgetHandle == 0L) {
            widgetHandle = this.getHandleValue(shell, "shellHandle");
        }
        return widgetHandle;
    }

    private static boolean isGtk4() {
        try {
            return ReflectionUtils.getFieldBoolean(OSSupportLinux.class.getClassLoader().loadClass("org.eclipse.swt.internal.gtk.GTK"), (String)"GTK4");
        }
        catch (ReflectiveOperationException e) {
            DesignerPlugin.log((String)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void gdkThreadsEnter() {
        OSSupportLinux.gdk("gdk_threads_enter()", new Object[0]);
    }

    private static void gdkThreadsLeave() {
        OSSupportLinux.gdk("gdk_threads_leave()", new Object[0]);
    }

    protected abstract long getHandleValue(Object var1, String var2);

    protected abstract Image createImage0(long var1) throws Exception;

    private Image createImage(long imageHandle) throws Exception {
        Image image = this.createImage0(imageHandle);
        Image newImage = new Image(null, image.getImageData());
        image.dispose();
        return newImage;
    }

    private Image createImage(long sourceWindow, int width, int height) throws Exception {
        long targetSurface = OSSupportLinux._cairo_image_surface_create(OSSupportLinux._CAIRO_FORMAT_ARGB32(), width, height);
        long cr = OSSupportLinux._cairo_create(targetSurface);
        long visibleRegion = OSSupportLinux._gdk_window_get_visible_region(sourceWindow);
        OSSupportLinux._gdk_cairo_region(cr, visibleRegion);
        OSSupportLinux._cairo_clip(cr);
        OSSupportLinux._gdk_cairo_set_source_window(cr, sourceWindow, 0.0, 0.0);
        OSSupportLinux._cairo_set_operator(cr, OSSupportLinux._CAIRO_OPERATOR_SOURCE());
        OSSupportLinux._cairo_paint(cr);
        OSSupportLinux._cairo_destroy(cr);
        OSSupportLinux._cairo_surface_flush(targetSurface);
        OSSupportLinux._cairo_region_destroy(visibleRegion);
        return this.createImage(targetSurface);
    }

    public Image getMenuBarVisualData(Menu menu, List<Rectangle> bounds) {
        int i = 0;
        while (i < menu.getItemCount()) {
            MenuItem item = menu.getItem(i);
            bounds.add(this.getWidgetBounds(item));
            ++i;
        }
        return null;
    }

    public final Rectangle getMenuBarBounds(Menu menu) {
        Rectangle bounds = this.getWidgetBounds(menu);
        Shell shell = menu.getShell();
        Point p = shell.toControl(shell.getLocation());
        p.x = -p.x;
        p.y = -p.y - bounds.height;
        return new Rectangle(p.x, p.y, bounds.width, bounds.height);
    }

    public final int getDefaultMenuBarHeight() {
        return 24;
    }

    public final Rectangle getTabItemBounds(Object tabItem) {
        return this.getWidgetBounds(tabItem);
    }

    private boolean isWorkaroundsDisabled() {
        return Boolean.parseBoolean(System.getProperty("__wbp.linux.disableScreenshotWorkarounds"));
    }

    public void setAlpha(Shell shell, int alpha) {
        if (OSSupportLinux._gtk_widget_is_composited(this.getShellHandle(shell))) {
            OSSupportLinux._gtk_widget_set_opacity(this.getShellHandle(shell), (double)alpha / 255.0);
        }
    }

    public int getAlpha(Shell shell) {
        if (OSSupportLinux._gtk_widget_is_composited(this.getShellHandle(shell))) {
            return (int)(OSSupportLinux._gtk_widget_get_opacity(this.getShellHandle(shell)) * 255.0);
        }
        return 255;
    }

    public boolean isPlusMinusTreeClick(Tree tree, int x, int y) {
        int[] cell_x = new int[1];
        int[] cell_y = new int[1];
        long[] path = new long[1];
        long[] column = new long[1];
        long tree_view = this.getHandleValue(tree, "handle");
        try {
            long expanderColumn;
            if (OSSupportLinux._gtk_tree_view_get_path_at_pos(tree_view, x, y, path, column, cell_x, cell_y) && (expanderColumn = OSSupportLinux._gtk_tree_view_get_expander_column(tree_view)) == column[0]) {
                GdkRectangle rect = new GdkRectangle();
                OSSupportLinux._gtk_tree_view_get_cell_area(tree_view, path[0], column[0], rect);
                if (x < rect.x) {
                    return true;
                }
            }
            return false;
        }
        finally {
            if (path[0] != 0L) {
                OSSupportLinux._gtk_tree_path_free(path[0]);
            }
        }
    }

    public void runAwt(Runnable job) {
        Display display = Display.getCurrent();
        try {
            if (display != null && !OSSupportLinux.isGtk4()) {
                OSSupportLinux.gdkThreadsLeave();
            }
            super.runAwt(job);
        }
        finally {
            if (display != null && !OSSupportLinux.isGtk4()) {
                OSSupportLinux.gdkThreadsEnter();
            }
        }
    }

    private static native void _gtk_widget_get_allocation(long var0, GtkAllocation var2);

    private static native void _gtk_window_set_keep_above(long var0, boolean var2);

    private static native boolean _gtk_widget_show_now(long var0);

    private static native boolean _gtk_widget_hide(long var0);

    @Deprecated
    private static native void _gdk_window_process_updates(long var0, boolean var2);

    private static native boolean _gdk_window_is_visible(long var0);

    private static native void _gdk_window_get_geometry(long var0, int[] var2, int[] var3, int[] var4, int[] var5);

    private static native long _gtk_widget_get_window(long var0);

    @Deprecated(since="GTK 3.22")
    private static native boolean _gtk_widget_is_composited(long var0);

    private static native double _gtk_widget_get_opacity(long var0);

    private static native void _gtk_widget_set_opacity(long var0, double var2);

    private static native long _gtk_tree_view_get_expander_column(long var0);

    private static native void _gtk_tree_view_get_cell_area(long var0, long var2, long var4, GdkRectangle var6);

    private static native boolean _gtk_tree_view_get_path_at_pos(long var0, int var2, int var3, long[] var4, long[] var5, int[] var6, int[] var7);

    private static native void _gtk_tree_path_free(long var0);

    private static native long _gdk_window_get_visible_region(long var0);

    private static native void _gdk_cairo_region(long var0, long var2);

    private static native void _gdk_cairo_set_source_window(long var0, long var2, double var4, double var6);

    private static native int _CAIRO_FORMAT_ARGB32();

    private static native int _CAIRO_OPERATOR_SOURCE();

    private static native long _cairo_create(long var0);

    private static native long _cairo_image_surface_create(int var0, int var1, int var2);

    private static native void _cairo_clip(long var0);

    private static native void _cairo_paint(long var0);

    private static native void _cairo_set_operator(long var0, int var2);

    private static native void _cairo_destroy(long var0);

    private static native void _cairo_surface_flush(long var0);

    private static native void _cairo_region_destroy(long var0);

    protected static final <T> T gdk(String methodSignature, Object ... args) {
        return OSSupportLinux.swt("org.eclipse.swt.internal.gtk.GDK", methodSignature, args);
    }

    private static final <T> T swt(String fullClassName, String methodSignature, Object ... args) {
        return (T)ExecutionUtils.runObject(() -> ReflectionUtils.invokeMethod(OSSupportLinux.class.getClassLoader().loadClass(fullClassName), (String)methodSignature, (Object[])args));
    }

    private static final class Impl64
    extends OSSupportLinux {
        private final VisualDataMockupProvider mockupProvider = new VisualDataMockupProvider();

        private Impl64() {
        }

        @Override
        protected long getHandleValue(Object widget, String fieldName) {
            Object object = ReflectionUtils.getFieldObject((Object)widget, (String)fieldName);
            if (object instanceof Long) {
                Long longValue = (Long)object;
                return longValue;
            }
            return 0L;
        }

        public Image getMenuPopupVisualData(Menu menu, int[] bounds) throws Exception {
            return this.mockupProvider.mockMenuPopupVisualData(menu, bounds);
        }

        @Override
        protected Image createImage0(long imageHandle) throws Exception {
            return (Image)ReflectionUtils.invokeMethod2(Image.class, (String)"gtk_new", Device.class, Integer.TYPE, Long.TYPE, Long.TYPE, null, (Object)0, (Object)imageHandle, (Object)0);
        }

        private long findHandleValue(Widget widget) {
            if (widget instanceof Shell) {
                Shell shell = (Shell)widget;
                return this.getShellHandle(shell);
            }
            return this.getHandleValue(widget, "handle");
        }

        protected Image getImageSurface(Widget widget, BiConsumer<Long, Image> callback) throws Exception {
            long handle = this.findHandleValue(widget);
            long window = OSSupportLinux._gtk_widget_get_window(handle);
            if (!OSSupportLinux._gdk_window_is_visible(window)) {
                return null;
            }
            int[] x = new int[1];
            int[] y = new int[1];
            int[] width = new int[1];
            int[] height = new int[1];
            OSSupportLinux._gdk_window_get_geometry(window, x, y, width, height);
            OSSupportLinux._gdk_window_process_updates(window, true);
            Image image = super.createImage(window, width[0], height[0]);
            if (callback != null) {
                callback.accept(handle, image);
            }
            return image;
        }

        private Image traverse(Widget widget, BiConsumer<Long, Image> callback) throws Exception {
            Image image = this.getImageSurface(widget, callback);
            if (image == null) {
                return null;
            }
            if (widget instanceof Composite) {
                Composite composite = (Composite)widget;
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control childWidget = controlArray[n2];
                    Image childImage = this.traverse((Widget)childWidget, callback);
                    if (childImage != null && callback == null) {
                        childImage.dispose();
                    }
                    ++n2;
                }
            }
            return image;
        }

        @Override
        protected Image makeShot(Shell shell, BiConsumer<Long, Image> callback) throws Exception {
            return this.traverse((Widget)shell, callback);
        }
    }
}

