/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.timestamp;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

@NonNullByDefault
public class TmfTimeRange {
    public static final TmfTimeRange ETERNITY = new EternityTimeRange();
    public static final TmfTimeRange NULL_RANGE = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_BANG);
    private final ITmfTimestamp fStartTime;
    private final ITmfTimestamp fEndTime;

    public TmfTimeRange(ITmfTimestamp startTime, ITmfTimestamp endTime) {
        this.fStartTime = startTime;
        this.fEndTime = endTime;
    }

    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    public boolean contains(ITmfTimestamp ts) {
        return this.fStartTime.compareTo(ts) <= 0 && this.fEndTime.compareTo(ts) >= 0;
    }

    public boolean contains(TmfTimeRange range) {
        ITmfTimestamp startTime = range.getStartTime();
        ITmfTimestamp endTime = range.getEndTime();
        return this.fStartTime.compareTo(startTime) <= 0 && this.fEndTime.compareTo(endTime) >= 0;
    }

    public @Nullable TmfTimeRange getIntersection(TmfTimeRange range) {
        if (this.fStartTime.compareTo(range.fEndTime) > 0 || this.fEndTime.compareTo(range.fStartTime) < 0) {
            return null;
        }
        return new TmfTimeRange(this.fStartTime.compareTo(range.fStartTime) < 0 ? range.fStartTime : this.fStartTime, this.fEndTime.compareTo(range.fEndTime) > 0 ? range.fEndTime : this.fEndTime);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fEndTime.hashCode();
        result = 31 * result + this.fStartTime.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfTimeRange)) {
            return false;
        }
        TmfTimeRange other = (TmfTimeRange)obj;
        if (!this.fEndTime.equals(other.fEndTime)) {
            return false;
        }
        return this.fStartTime.equals(other.fStartTime);
    }

    public String toString() {
        return "TmfTimeRange [fStartTime=" + String.valueOf(this.fStartTime) + ", fEndTime=" + String.valueOf(this.fEndTime) + "]";
    }

    private static final class EternityTimeRange
    extends TmfTimeRange {
        public EternityTimeRange() {
            super(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        }

        @Override
        public boolean contains(ITmfTimestamp ts) {
            return true;
        }

        @Override
        public boolean contains(TmfTimeRange range) {
            return true;
        }

        @Override
        public @NonNull TmfTimeRange getIntersection(TmfTimeRange range) {
            return range;
        }
    }
}

