/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IRelayResponse;

public class SessionResponse
implements IRelayResponse {
    public static final int SIZE = 339;
    private final long fId;
    private final int fLiveTimer;
    private final int fClients;
    private final int fStreams;
    private final String fHostname;
    private final String fSessionName;

    public SessionResponse(DataInputStream inNet) throws IOException {
        byte[] data = new byte[339];
        inNet.readFully(data);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        this.fId = bb.getLong();
        this.fLiveTimer = bb.getInt();
        this.fClients = bb.getInt();
        this.fStreams = bb.getInt();
        byte[] hostName = new byte[64];
        byte[] sessionName = new byte[255];
        bb.get(hostName, 0, hostName.length);
        bb.get(sessionName, 0, sessionName.length);
        this.fHostname = new String(hostName);
        this.fSessionName = new String(sessionName);
    }

    public long getId() {
        return this.fId;
    }

    public int getLiveTimer() {
        return this.fLiveTimer;
    }

    public int getClients() {
        return this.fClients;
    }

    public int getStreams() {
        return this.fStreams;
    }

    public String getHostname() {
        return this.fHostname;
    }

    public String getSessionName() {
        return this.fSessionName;
    }
}

