/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.ide.ui.source.IEMFComparisonSource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class SelectAncestorDialog<T>
extends MessageDialog {
    private List<T> elements;
    T originElement;
    T leftElement;
    T rightElement;
    private Button[] buttons;
    private final AdapterFactory adapterFactory;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button selectedButton = (Button)e.widget;
            if (!selectedButton.getSelection()) {
                return;
            }
            int i = 0;
            while (i < 3) {
                if (selectedButton == SelectAncestorDialog.this.buttons[i]) {
                    SelectAncestorDialog.this.pickOrigin(i);
                }
                ++i;
            }
        }
    };

    public SelectAncestorDialog(Shell parentShell, AdapterFactory adapterFactory, T[] theResources) {
        super(parentShell, CompareMessages.SelectAncestorDialog_title, null, CompareMessages.SelectAncestorDialog_message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.adapterFactory = adapterFactory;
        this.elements = new ArrayList<T>(Arrays.asList(theResources));
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.buttons = new Button[3];
        int i = 0;
        while (i < 3) {
            this.buttons[i] = new Button(composite, 16);
            this.buttons[i].addSelectionListener(this.selectionListener);
            String text = "'" + this.getText(this.elements.get(i)) + "'";
            if (this.elements.get(i) instanceof EObject) {
                text = String.valueOf(text) + " (" + EcoreUtil.getURI((EObject)((EObject)this.elements.get(i))) + ")";
            }
            this.buttons[i].setText(text);
            this.buttons[i].setFont(parent.getFont());
            this.buttons[i].setSelection(i == 0);
            ++i;
        }
        this.pickOrigin(0);
        return composite;
    }

    private void pickOrigin(int i) {
        this.originElement = this.elements.get(i);
        this.leftElement = this.elements.get(i == 0 ? 1 : 0);
        this.rightElement = this.elements.get(i == 2 ? 1 : 2);
    }

    private String getText(Object object) {
        IEMFComparisonSource emfComparisonSourceAdapter = (IEMFComparisonSource)Platform.getAdapterManager().getAdapter(object, IEMFComparisonSource.class);
        if (emfComparisonSourceAdapter != null) {
            return emfComparisonSourceAdapter.getName();
        }
        Object itemLabelProvider = this.adapterFactory.adapt(object, IItemLabelProvider.class);
        if (itemLabelProvider instanceof IItemLabelProvider) {
            return ((IItemLabelProvider)itemLabelProvider).getText(object);
        }
        ILabelProvider labelProvider = (ILabelProvider)Platform.getAdapterManager().getAdapter(object, ILabelProvider.class);
        if (labelProvider != null) {
            return labelProvider.getText(object);
        }
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
        if (workbenchAdapter != null) {
            return workbenchAdapter.getLabel(object);
        }
        return object.toString();
    }
}

