/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property;

import com.google.common.collect.Iterables;
import java.util.ResourceBundle;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyAccessor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyItem;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyTreeMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.AbstractTreeContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

class PropertyContentMergeViewer
extends AbstractTreeContentMergeViewer {
    private static final String BUNDLE_NAME = PropertyContentMergeViewer.class.getName();
    static final IMergeViewer.MergeViewerSide[] MERGE_VIEWER_SIDES = new IMergeViewer.MergeViewerSide[]{IMergeViewer.MergeViewerSide.ANCESTOR, IMergeViewer.MergeViewerSide.LEFT, IMergeViewer.MergeViewerSide.RIGHT};
    static String SHOW_ADVANCED_PROPERTIES = "SHOW_ADVANCED_PROPERTIES";
    static String SHOW_CATEGORIES = "SHOW_CATEGORIES";
    private PropertyAccessor ancestorPropertyAccessor;
    private PropertyAccessor leftPropertyAccessor;
    private PropertyAccessor rightPropertyAccessor;
    private ITreeViewerListener treeListener = new ITreeViewerListener(){

        public void treeExpanded(TreeExpansionEvent event) {
            this.update(event, true);
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            this.update(event, false);
        }

        private void update(TreeExpansionEvent event, boolean expanded) {
            AbstractTreeViewer treeViewer = event.getTreeViewer();
            PropertyItem element = (PropertyItem)((Object)event.getElement());
            IMergeViewer.MergeViewerSide[] mergeViewerSideArray = MERGE_VIEWER_SIDES;
            int n = MERGE_VIEWER_SIDES.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyItem sideElement;
                IMergeViewer.MergeViewerSide side = mergeViewerSideArray[n2];
                PropertyTreeMergeViewer propertyMergeViewer = PropertyContentMergeViewer.this.getPropertyMergeViewer(side);
                if (propertyMergeViewer.getStructuredViewer() != treeViewer && (sideElement = element.getSide(side)) != null) {
                    propertyMergeViewer.setExpandedState((Object)sideElement, expanded);
                    propertyMergeViewer.columnResizer.resizeColumns();
                }
                ++n2;
            }
            PropertyContentMergeViewer.this.redrawCenterControl();
        }
    };

    protected PropertyContentMergeViewer(Composite parent, EMFCompareConfiguration configuration) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), configuration);
        this.buildControl(parent);
    }

    protected PropertyTreeMergeViewer getPropertyMergeViewer(IMergeViewer.MergeViewerSide side) {
        switch (side) {
            case ANCESTOR: {
                return (PropertyTreeMergeViewer)this.getAncestorMergeViewer();
            }
            case LEFT: {
                return (PropertyTreeMergeViewer)this.getLeftMergeViewer();
            }
        }
        return (PropertyTreeMergeViewer)this.getRightMergeViewer();
    }

    @Override
    public void setContentProvider(IContentProvider contentProvider) {
        if (this.getContentProvider() == null) {
            IMergeViewerContentProvider mergeViewerContentProvider = (IMergeViewerContentProvider)contentProvider;
            super.setContentProvider((IContentProvider)new PropertyContentProvider(mergeViewerContentProvider));
        } else {
            super.setContentProvider(contentProvider);
        }
    }

    @Override
    protected IMergeViewer createMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        PropertyTreeMergeViewer propertyMergeViewer = new PropertyTreeMergeViewer(parent, side, this, this.getCompareConfiguration());
        this.hookListeners(propertyMergeViewer);
        propertyMergeViewer.getStructuredViewer().addTreeListener(this.treeListener);
        return propertyMergeViewer;
    }

    @Override
    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        ToggleAction showCategories = new ToggleAction(SHOW_CATEGORIES, true, "icons/full/toolb16/show_categories.png", "PropertyContentMergeViewer.hideCategories.tooltip", "PropertyContentMergeViewer.showCategories.tooltip");
        toolBarManager.add((IContributionItem)new ActionContributionItem((IAction)showCategories));
        ToggleAction showAdvancedProperties = new ToggleAction(SHOW_ADVANCED_PROPERTIES, false, "icons/full/toolb16/show_advanced_properties.png", "PropertyContentMergeViewer.hideAdvancedProperties.tooltip", "PropertyContentMergeViewer.showAdvancedProperties.tooltip");
        toolBarManager.add((IContributionItem)new ActionContributionItem((IAction)showAdvancedProperties));
    }

    public void setInput(Object input) {
        this.buildProperties(input);
        super.setInput(input);
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        this.ancestorPropertyAccessor = null;
        this.leftPropertyAccessor = null;
        this.rightPropertyAccessor = null;
        super.handleDispose(event);
    }

    private void buildProperties(Object input) {
        CompareInputAdapter compareInputAdapter;
        Notifier target;
        if (input instanceof CompareInputAdapter && (target = (compareInputAdapter = (CompareInputAdapter)((Object)input)).getTarget()) instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)target;
            this.buildPropertiesFromTreeNode(treeNode, true);
            return;
        }
        this.buildPropertiesFromSides(null, null, null);
    }

    private void buildPropertiesFromTreeNode(TreeNode treeNode, boolean visitParent) {
        EObject data = treeNode.getData();
        if (treeNode instanceof DiffNode) {
            TreeNode parent;
            TreeNode refinedDiff = (TreeNode)Iterables.getFirst((Iterable)((DiffNode)treeNode).getRefinedDiffs(), null);
            if (refinedDiff != null) {
                this.buildPropertiesFromTreeNode(refinedDiff, false);
                this.setInitialItemsForProperties(data);
                return;
            }
            if (visitParent && (parent = treeNode.getParent()) != null) {
                this.buildPropertiesFromTreeNode(parent, true);
                this.setInitialItemsForProperties(data);
                return;
            }
        }
        this.buildPropertiesFromEObject(data);
        this.setInitialItemsForProperties(data);
    }

    private void buildPropertiesFromEObject(EObject eObject) {
        if (eObject instanceof Match) {
            Match match = (Match)eObject;
            EObject effectiveAncestor = match.getOrigin();
            EObject effectiveLeft = match.getLeft();
            EObject effectiveRight = match.getRight();
            if (effectiveAncestor == null && effectiveLeft == null && effectiveRight == null) {
                EObject eContainer = match.eContainer();
                if (eContainer instanceof Match) {
                    this.buildPropertiesFromEObject(eContainer);
                }
            } else {
                this.buildPropertiesFromSides(effectiveAncestor, effectiveLeft, effectiveRight);
            }
        } else if (eObject instanceof Diff) {
            Diff diff = (Diff)eObject;
            this.buildPropertiesFromEObject((EObject)diff.getMatch());
            this.setInitialItemsForProperties((EObject)diff);
        } else if (eObject instanceof MatchResource) {
            MatchResource matchResource = (MatchResource)eObject;
            this.buildPropertiesFromSides(matchResource.getOrigin(), matchResource.getLeft(), matchResource.getRight());
        } else if (eObject instanceof Equivalence) {
            Equivalence equivalence = (Equivalence)eObject;
            EList differences = equivalence.getDifferences();
            Diff first = (Diff)Iterables.getFirst((Iterable)differences, null);
            this.buildPropertiesFromEObject((EObject)first);
        } else if (eObject instanceof Conflict) {
            Conflict conflict = (Conflict)eObject;
            EList differences = conflict.getDifferences();
            Diff first = (Diff)Iterables.getFirst((Iterable)differences, null);
            this.buildPropertiesFromEObject((EObject)first);
        }
    }

    private void buildPropertiesFromSides(Object origin, Object left, Object right) {
        EMFCompareConfiguration configuration = this.getCompareConfiguration();
        this.ancestorPropertyAccessor = new PropertyAccessor(configuration, origin, IMergeViewer.MergeViewerSide.ANCESTOR);
        this.leftPropertyAccessor = new PropertyAccessor(configuration, left, this.getEffectiveSide(IMergeViewer.MergeViewerSide.LEFT));
        this.rightPropertyAccessor = new PropertyAccessor(configuration, right, this.getEffectiveSide(IMergeViewer.MergeViewerSide.RIGHT));
        this.ancestorPropertyAccessor.rootPropertyItem.reconcile(this.leftPropertyAccessor.rootPropertyItem, this.rightPropertyAccessor.rootPropertyItem);
    }

    private void setInitialItemsForProperties(EObject eObject) {
        Diff diff = null;
        if (eObject instanceof Diff) {
            diff = (Diff)eObject;
        }
        this.ancestorPropertyAccessor.setInitialItem(diff);
        this.leftPropertyAccessor.setInitialItem(diff);
        this.rightPropertyAccessor.setInitialItem(diff);
    }

    public void refresh() {
        this.buildProperties(this.getInput());
        IMergeViewer.MergeViewerSide[] mergeViewerSideArray = MERGE_VIEWER_SIDES;
        int n = MERGE_VIEWER_SIDES.length;
        int n2 = 0;
        while (n2 < n) {
            IMergeViewer.MergeViewerSide side = mergeViewerSideArray[n2];
            PropertyTreeMergeViewer propertyMergeViewer = this.getPropertyMergeViewer(side);
            ISelection selection = propertyMergeViewer.getSelection();
            PropertyItem selectedItem = null;
            if (!selection.isEmpty()) {
                selectedItem = (PropertyItem)((Object)((IStructuredSelection)selection).getFirstElement());
            }
            switch (side) {
                case ANCESTOR: {
                    this.ancestorPropertyAccessor.setInitialItem(selectedItem);
                    break;
                }
                case LEFT: {
                    this.leftPropertyAccessor.setInitialItem(selectedItem);
                    break;
                }
                case RIGHT: {
                    this.rightPropertyAccessor.setInitialItem(selectedItem);
                }
            }
            ++n2;
        }
        super.refresh();
    }

    @Override
    protected void updateContent(Object ancestor, Object left, Object right) {
        if (this.getCompareConfiguration().isMirrored()) {
            super.updateContent(this.ancestorPropertyAccessor, this.rightPropertyAccessor, this.leftPropertyAccessor);
        } else {
            super.updateContent(this.ancestorPropertyAccessor, this.leftPropertyAccessor, this.rightPropertyAccessor);
        }
    }

    private final class PropertyContentProvider
    implements IMergeViewerContentProvider {
        private final IMergeViewerContentProvider mergeViewerContentProvider;

        private PropertyContentProvider(IMergeViewerContentProvider mergeViewerContentProvider) {
            this.mergeViewerContentProvider = mergeViewerContentProvider;
        }

        public void dispose() {
            this.mergeViewerContentProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.mergeViewerContentProvider.inputChanged(viewer, oldInput, newInput);
        }

        private String getSideLabel(String baseLabel, IMergeViewer.MergeViewerSide side) {
            String text;
            PropertyTreeMergeViewer propertyMergeViewer = PropertyContentMergeViewer.this.getPropertyMergeViewer(side);
            if (propertyMergeViewer != null && propertyMergeViewer.getRootPropertyItem() != null && !(text = propertyMergeViewer.getRootPropertyItem().getText()).isEmpty()) {
                return String.valueOf(text) + " - " + baseLabel;
            }
            return baseLabel;
        }

        private Image getSideImage(Image baseImage, IMergeViewer.MergeViewerSide side) {
            Object image;
            PropertyTreeMergeViewer propertyMergeViewer = PropertyContentMergeViewer.this.getPropertyMergeViewer(side);
            if (propertyMergeViewer != null && propertyMergeViewer.getRootPropertyItem() != null && (image = propertyMergeViewer.getRootPropertyItem().getImage()) != null) {
                return ExtendedImageRegistry.INSTANCE.getImage(image);
            }
            return baseImage;
        }

        public String getAncestorLabel(Object input) {
            return this.getSideLabel(this.mergeViewerContentProvider.getAncestorLabel(input), IMergeViewer.MergeViewerSide.ANCESTOR);
        }

        public Image getAncestorImage(Object input) {
            return this.getSideImage(this.mergeViewerContentProvider.getAncestorImage(input), IMergeViewer.MergeViewerSide.ANCESTOR);
        }

        public Object getAncestorContent(Object input) {
            return this.mergeViewerContentProvider.getAncestorContent(input);
        }

        public boolean showAncestor(Object input) {
            return this.mergeViewerContentProvider.showAncestor(input);
        }

        public String getLeftLabel(Object input) {
            return this.getSideLabel(this.mergeViewerContentProvider.getLeftLabel(input), IMergeViewer.MergeViewerSide.LEFT);
        }

        public Image getLeftImage(Object input) {
            return this.getSideImage(this.mergeViewerContentProvider.getLeftImage(input), IMergeViewer.MergeViewerSide.LEFT);
        }

        public Object getLeftContent(Object input) {
            return this.mergeViewerContentProvider.getLeftContent(input);
        }

        public boolean isLeftEditable(Object input) {
            return this.mergeViewerContentProvider.isLeftEditable(input);
        }

        public void saveLeftContent(Object input, byte[] bytes) {
            this.mergeViewerContentProvider.saveLeftContent(input, bytes);
        }

        public String getRightLabel(Object input) {
            return this.getSideLabel(this.mergeViewerContentProvider.getRightLabel(input), IMergeViewer.MergeViewerSide.RIGHT);
        }

        public Image getRightImage(Object input) {
            return this.getSideImage(this.mergeViewerContentProvider.getRightImage(input), IMergeViewer.MergeViewerSide.RIGHT);
        }

        public Object getRightContent(Object input) {
            return this.mergeViewerContentProvider.getRightContent(input);
        }

        public boolean isRightEditable(Object input) {
            return this.mergeViewerContentProvider.isRightEditable(input);
        }

        public void saveRightContent(Object input, byte[] bytes) {
            this.mergeViewerContentProvider.saveRightContent(input, bytes);
        }
    }

    private final class ToggleAction
    extends Action {
        private final String propertyKey;
        private final String checkedTooltip;
        private final String uncheckedTooltip;

        public ToggleAction(String propertyKey, boolean propertyDefaultValue, String imageLocation, String checkedTooltipKey, String uncheckedTooltipKey) {
            this.propertyKey = propertyKey;
            this.checkedTooltip = EMFCompareIDEUIMessages.getString(checkedTooltipKey);
            this.uncheckedTooltip = EMFCompareIDEUIMessages.getString(uncheckedTooltipKey);
            this.setChecked(PropertyContentMergeViewer.this.getCompareConfiguration().getBooleanProperty(propertyKey, propertyDefaultValue));
            this.setImageDescriptor(EMFCompareIDEUIPlugin.getImageDescriptor(imageLocation));
            this.updateToolTipText();
        }

        public void run() {
            PropertyContentMergeViewer.this.getCompareConfiguration().setProperty(this.propertyKey, this.isChecked());
            PropertyContentMergeViewer.this.refresh();
            this.updateToolTipText();
        }

        private void updateToolTipText() {
            String toolTipText = this.isChecked() ? this.checkedTooltip : this.uncheckedTooltip;
            this.setToolTipText(toolTipText);
        }
    }
}

