/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.ui.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetPageInfo;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetWizardInfo;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;

public class DataSetUIElement {
    private static final String WIZARD_ELEMENT_NAME = "dataSetWizard";
    private static final String PAGE_ELEMENT_NAME = "dataSetPage";
    private static final String ID_ATRIBUTE_NAME = "id";
    private String m_id;
    private String m_initialPageId;
    private boolean m_supportsInParameters;
    private boolean m_supportsOutParameters;
    private DataSetWizardInfo m_wizardInfo;
    private Hashtable m_dataSetPages;
    private ArrayList m_dataSetPageIds;
    private IConfigurationElement m_dataSetElement;

    DataSetUIElement(IConfigurationElement dataSetElement) throws OdaException {
        IConfigurationElement wizardElement;
        this.m_dataSetElement = dataSetElement;
        this.m_id = dataSetElement.getAttribute(ID_ATRIBUTE_NAME);
        if (this.m_id == null || this.m_id.length() == 0) {
            throw new OdaException(Messages.bind((String)Messages.manifest_missingAttributeValue, (Object)ID_ATRIBUTE_NAME));
        }
        this.m_initialPageId = dataSetElement.getAttribute("initialPageId");
        this.m_supportsInParameters = true;
        String hasParamDefn = dataSetElement.getAttribute("supportsInParameters");
        if (hasParamDefn != null && (hasParamDefn.equalsIgnoreCase("true") || hasParamDefn.equalsIgnoreCase("false"))) {
            this.m_supportsInParameters = Boolean.valueOf(hasParamDefn);
        }
        this.m_supportsOutParameters = false;
        hasParamDefn = dataSetElement.getAttribute("supportsOutParameters");
        if (hasParamDefn != null && (hasParamDefn.equalsIgnoreCase("true") || hasParamDefn.equalsIgnoreCase("false"))) {
            this.m_supportsOutParameters = Boolean.valueOf(hasParamDefn);
        }
        if ((wizardElement = DataSetUIElement.getWizardElement(dataSetElement)) != null) {
            this.m_wizardInfo = new DataSetWizardInfo(wizardElement);
        }
        this.getDataSetPages(dataSetElement);
    }

    private Hashtable getDataSetPages(IConfigurationElement dataSetElement) throws OdaException {
        IConfigurationElement[] pages = dataSetElement.getChildren(PAGE_ELEMENT_NAME);
        if (pages.length == 0) {
            throw new OdaException(Messages.bind((String)Messages.manifest_dataSetUi_missingElement, (Object)PAGE_ELEMENT_NAME));
        }
        this.m_dataSetPages = new Hashtable(pages.length);
        this.m_dataSetPageIds = new ArrayList(pages.length);
        int i = 0;
        while (i < pages.length) {
            IConfigurationElement aPage = pages[i];
            String pageId = aPage.getAttribute(ID_ATRIBUTE_NAME);
            this.m_dataSetPages.put(pageId, new DataSetPageInfo(aPage));
            this.m_dataSetPageIds.add(pageId);
            ++i;
        }
        return this.m_dataSetPages;
    }

    public String getId() {
        return this.m_id;
    }

    public String getInitialPageId() {
        return this.m_initialPageId;
    }

    public boolean supportsInParameters() {
        return this.m_supportsInParameters;
    }

    public boolean supportsOutParameters() {
        return this.m_supportsOutParameters;
    }

    public IConfigurationElement getElement() {
        return this.m_dataSetElement;
    }

    public DataSetWizardInfo getWizardInfo() {
        return this.m_wizardInfo;
    }

    public static IConfigurationElement getWizardElement(IConfigurationElement dataSetUIElement) throws OdaException {
        if (dataSetUIElement == null) {
            return null;
        }
        IConfigurationElement[] wizardElements = dataSetUIElement.getChildren(WIZARD_ELEMENT_NAME);
        if (wizardElements.length < 1) {
            throw new OdaException(Messages.bind((String)Messages.manifest_dataSetUi_missingElement, (Object)WIZARD_ELEMENT_NAME));
        }
        return wizardElements[0];
    }

    public DataSetPageInfo[] getPageDefinitions() {
        if (this.m_dataSetPageIds == null) {
            return new DataSetPageInfo[0];
        }
        int numPages = this.m_dataSetPageIds.size();
        ArrayList<DataSetPageInfo> dataSetPages = new ArrayList<DataSetPageInfo>(numPages);
        int i = 0;
        while (i < numPages) {
            String pageId = (String)this.m_dataSetPageIds.get(i);
            try {
                dataSetPages.add(this.getPageDefinition(pageId));
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return dataSetPages.toArray(new DataSetPageInfo[dataSetPages.size()]);
    }

    public String[] getPageIds() {
        if (this.m_dataSetPageIds == null) {
            return new String[0];
        }
        return this.m_dataSetPageIds.toArray(new String[this.m_dataSetPageIds.size()]);
    }

    public DataSetPageInfo getPageDefinition(String pageId) throws OdaException {
        if (pageId == null || pageId.length() == 0) {
            if (this.m_dataSetPages == null || this.m_dataSetPages.size() != 1) {
                throw new OdaException(Messages.manifest_dataSetUi_missingPageId);
            }
            Collection pages = this.m_dataSetPages.values();
            assert (pages.size() == 1);
            return (DataSetPageInfo)pages.toArray()[0];
        }
        DataSetPageInfo pageInfo = (DataSetPageInfo)this.m_dataSetPages.get(pageId);
        if (pageInfo == null) {
            throw new OdaException(Messages.bind((String)Messages.manifest_dataSetUi_invalidPageId, (Object)pageId));
        }
        return pageInfo;
    }

    public static IConfigurationElement getPageElement(IConfigurationElement dataSetUIElement, String pageId) throws OdaException {
        if (dataSetUIElement == null) {
            return null;
        }
        IConfigurationElement[] pages = dataSetUIElement.getChildren(PAGE_ELEMENT_NAME);
        if (pageId == null || pageId.length() == 0) {
            if (pages.length != 1) {
                throw new OdaException(Messages.manifest_dataSetUi_missingPageId);
            }
            return pages[0];
        }
        int i = 0;
        while (i < pages.length) {
            IConfigurationElement pageElement = pages[i];
            if (pageId.equalsIgnoreCase(pageElement.getAttribute(ID_ATRIBUTE_NAME))) {
                return pageElement;
            }
            ++i;
        }
        return null;
    }
}

