/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.net.URL;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePage;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;

public class BuildConsole
extends AbstractConsole {
    public static final String ERROR_GROUP = "errorGroup";
    public static final String P_STREAM_COLOR = "org.eclipse.cdt.ui.CONSOLE_P_STREAM_COLOR";
    private BuildConsolePage fBuildConsolePage;
    private static BuildConsolePage fCurrentBuildConsolePage;
    private IBuildConsoleManager fConsoleManager;
    private String fConsoleName;
    private String fConsoleId;
    private Color fBackground;

    public BuildConsole(IBuildConsoleManager manager, String name, String contextId) {
        this(manager, name, contextId, null);
    }

    public BuildConsole(IBuildConsoleManager manager, String name, String contextId, URL iconUrl) {
        super(name, CDTSharedImages.getImageDescriptor("icons/view16/buildconsole.gif"));
        if (iconUrl != null) {
            CDTSharedImages.register(iconUrl);
            this.setImageDescriptor(CDTSharedImages.getImageDescriptor(iconUrl.toString()));
        }
        this.fConsoleManager = manager;
        this.fConsoleName = name;
        this.fConsoleId = contextId;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        fCurrentBuildConsolePage = this.fBuildConsolePage = new BuildConsolePage(view, this, this.fConsoleId);
        return this.fBuildConsolePage;
    }

    BuildConsolePage getPage() {
        return this.fBuildConsolePage;
    }

    static BuildConsolePage getCurrentPage() {
        return fCurrentBuildConsolePage;
    }

    static void setCurrentPage(BuildConsolePage page) {
        fCurrentBuildConsolePage = page;
    }

    public void setTitle(IProject project) {
        Object title = this.fConsoleName;
        if (project != null) {
            title = (String)title + " [" + project.getName() + "]";
        }
        this.setName((String)title);
    }

    public IBuildConsoleManager getConsoleManager() {
        return this.fConsoleManager;
    }

    public void setBackground(Color background) {
        if (this.fBackground == null ? background == null : this.fBackground.equals((Object)background)) {
            return;
        }
        Color old = this.fBackground;
        this.fBackground = background;
        this.firePropertyChange((Object)this, IConsoleConstants.P_BACKGROUND_COLOR, old, this.fBackground);
    }

    public Color getBackground() {
        return this.fBackground;
    }
}

