/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.wst.jsdt.chromium.JsArray;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.JsVariable;

public class JsValueStringifier {
    private static final String ELLIPSIS = "...";
    private static final String UNKNOWN_VALUE = "<null>";
    private final Config config;

    public static String toVisibleString(JsValue value) {
        return JsValueStringifier.possiblyQuoteValueString(value);
    }

    private static String possiblyQuoteValueString(JsValue value) {
        if (value == null) {
            return UNKNOWN_VALUE;
        }
        String valueString = value.getValueString();
        return value.getType() == JsValue.Type.TYPE_STRING ? "\"" + valueString + "\"" : valueString;
    }

    public JsValueStringifier() {
        this.config = new Config();
    }

    public JsValueStringifier(Config config) {
        this.config = config;
    }

    public String render(JsValue value) {
        if (value == null) {
            return UNKNOWN_VALUE;
        }
        StringBuilder output = new StringBuilder();
        this.renderInternal(value, this.config.maxLength, true, output);
        return output.toString();
    }

    private void renderInternal(JsValue value, int maxLength, boolean descend, StringBuilder output) {
        if (!descend) {
            this.renderPrimitive(value, maxLength, output);
            return;
        }
        JsValue.Type type = value.getType();
        switch (type) {
            case TYPE_ARRAY: {
                this.renderArray(value.asObject().asArray(), maxLength, output);
                break;
            }
            case TYPE_OBJECT: {
                this.renderObject(value.asObject(), maxLength, output);
                break;
            }
            default: {
                this.renderPrimitive(value, maxLength, output);
            }
        }
    }

    private void renderPrimitive(JsValue value, int maxLength, StringBuilder output) {
        output.append(JsValueStringifier.possiblyQuoteValueString(value));
        this.truncate(output, maxLength, ELLIPSIS);
    }

    private void truncate(StringBuilder valueBuilder, int maxLength, String suffix) {
        int length = valueBuilder.length();
        if (length > maxLength) {
            valueBuilder.setLength(maxLength);
            valueBuilder.replace(maxLength - suffix.length(), maxLength, suffix);
        }
    }

    private StringBuilder renderArray(JsArray value, int maxLength, StringBuilder output) {
        output.append('[');
        SortedMap indexToElement = value.toSparseArray();
        boolean isFirst = true;
        int maxLengthWithoutLastBracket = maxLength - 1;
        StringBuilder elementBuilder = new StringBuilder();
        int entriesWritten = 0;
        for (Map.Entry entry : indexToElement.entrySet()) {
            Long index = (Long)entry.getKey();
            JsVariable var = (JsVariable)entry.getValue();
            if (!isFirst) {
                output.append(',');
            } else {
                isFirst = false;
            }
            elementBuilder.setLength(0);
            elementBuilder.append(index).append('=');
            this.renderInternal(var.getValue(), maxLengthWithoutLastBracket, false, elementBuilder);
            if (output.length() + elementBuilder.length() >= maxLengthWithoutLastBracket) {
                this.appendNMore(output, indexToElement.size() - entriesWritten);
                break;
            }
            output.append(elementBuilder.toString());
            ++entriesWritten;
        }
        return output.append(']');
    }

    private StringBuilder renderObject(JsObject value, int maxLength, StringBuilder output) {
        output.append('[');
        Collection properties = value.getProperties();
        boolean isFirst = true;
        int maxLengthWithoutLastBracket = maxLength - 1;
        StringBuilder elementBuilder = new StringBuilder();
        int entriesWritten = 0;
        for (JsVariable property : properties) {
            String name = property.getName();
            if (!isFirst) {
                output.append(',');
            } else {
                isFirst = false;
            }
            elementBuilder.setLength(0);
            elementBuilder.append(name).append('=');
            this.renderInternal(property.getValue(), maxLengthWithoutLastBracket, false, elementBuilder);
            if (output.length() + elementBuilder.length() >= maxLengthWithoutLastBracket) {
                this.appendNMore(output, properties.size() - entriesWritten);
                break;
            }
            output.append(elementBuilder.toString());
            ++entriesWritten;
        }
        return output.append(']');
    }

    private StringBuilder appendNMore(StringBuilder output, int n) {
        return output.append(" +").append(n).append(ELLIPSIS);
    }

    public static class Config {
        public int maxLength = 80;
    }
}

