/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.remote.internal;

import java.util.List;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.terminal.connector.AbstractSettingsPage;
import org.eclipse.tm.terminal.connector.remote.internal.RemoteSettings;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class RemoteSettingsPage
extends AbstractSettingsPage {
    private final RemoteSettings fTerminalSettings;
    private RemoteConnectionWidget fRemoteConnectionWidget;

    public RemoteSettingsPage(RemoteSettings settings) {
        this.fTerminalSettings = settings;
    }

    public void saveSettings() {
        if (this.fTerminalSettings != null && this.fRemoteConnectionWidget != null && !this.fRemoteConnectionWidget.isDisposed() && this.fRemoteConnectionWidget.getConnection() != null) {
            if (this.fRemoteConnectionWidget.getConnection().getConnectionType() != null) {
                this.fTerminalSettings.setConnectionTypeId(this.fRemoteConnectionWidget.getConnection().getConnectionType().getId());
            }
            this.fTerminalSettings.setConnectionName(this.fRemoteConnectionWidget.getConnection().getName());
        }
    }

    public void loadSettings() {
        if (this.fTerminalSettings != null && this.fRemoteConnectionWidget != null && !this.fRemoteConnectionWidget.isDisposed()) {
            this.fRemoteConnectionWidget.setConnection(this.fTerminalSettings.getConnectionTypeId(), this.fTerminalSettings.getConnectionName());
        }
    }

    String get(String value, String def) {
        if (value == null || value.length() == 0) {
            return def;
        }
        return value;
    }

    public boolean validateSettings() {
        return this.fRemoteConnectionWidget != null && !this.fRemoteConnectionWidget.isDisposed() && this.fRemoteConnectionWidget.getConnection() != null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference ref = context.getServiceReference(IRemoteServicesManager.class);
        IRemoteServicesManager manager = (IRemoteServicesManager)context.getService(ref);
        List types = manager.getConnectionTypesSupporting(new Class[]{IRemoteCommandShellService.class});
        this.fRemoteConnectionWidget = new RemoteConnectionWidget(composite, 0, null, 0, types);
        this.fRemoteConnectionWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteSettingsPage.this.fireListeners((Control)RemoteSettingsPage.this.fRemoteConnectionWidget);
            }
        });
        this.loadSettings();
    }
}

