/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.api.VersionedPackage;
import org.eclipse.php.composer.api.collection.Dependencies;
import org.eclipse.php.composer.ui.controller.DependencyController;
import org.eclipse.php.composer.ui.dialogs.DependencyDialog;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.editor.TableSection;
import org.eclipse.php.composer.ui.editor.composer.Messages;
import org.eclipse.php.composer.ui.job.UpdateDevJob;
import org.eclipse.php.composer.ui.parts.TablePart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DependencySection
extends TableSection
implements PropertyChangeListener {
    private Dependencies dependencies;
    private TableViewer dependencyViewer;
    private IAction editAction;
    private IAction removeAction;
    private IAction updateAction;
    private UpdateDevJob updateJob;
    private static final int EDIT_INDEX = 0;
    private static final int REMOVE_INDEX = 1;
    private static final int UPDATE_INDEX = 2;

    public DependencySection(ComposerFormPage page, Composite parent, Dependencies dependencies, String title, String description, boolean expanded) {
        super(page, parent, 450, new String[]{Messages.DependencySection_EditButton, Messages.DependencySection_RemoveButton, Messages.DependencySection_UpdateButton});
        this.dependencies = dependencies;
        this.createClient(this.getSection(), page.getManagedForm().getToolkit(), title, description, expanded);
        this.updateJob = new UpdateDevJob(page.getComposerEditor().getProject());
        this.updateJob.setUser(true);
    }

    protected void createClient(Section section, FormToolkit toolkit, String title, String description, boolean expanded) {
        section.setText(title);
        section.setDescription(description);
        section.setExpanded(expanded);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = expanded;
        section.setLayoutData((Object)gd);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        TablePart tablePart = this.getTablePart();
        DependencyController dependencyController = new DependencyController();
        this.dependencyViewer = tablePart.getTableViewer();
        this.dependencyViewer.setContentProvider((IContentProvider)dependencyController);
        this.dependencyViewer.setLabelProvider((IBaseLabelProvider)dependencyController);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.dependencyViewer.setInput((Object)this.dependencies);
        this.dependencies.addPropertyChangeListener((PropertyChangeListener)this);
        this.updateButtons();
        this.makeActions();
        this.updateMenu();
    }

    public void setExpanded(boolean expanded) {
        this.getSection().setExpanded(expanded);
        ((GridData)this.getSection().getLayoutData()).widthHint = expanded ? 0 : -1;
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    private void updateButtons() {
        ISelection selection = this.dependencyViewer.getSelection();
        TablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, !selection.isEmpty() && this.enabled);
        tablePart.setButtonEnabled(1, !selection.isEmpty() && this.enabled);
        tablePart.setButtonEnabled(2, !selection.isEmpty() && this.enabled);
    }

    private void updateMenu() {
        IStructuredSelection selection = (IStructuredSelection)this.dependencyViewer.getSelection();
        this.editAction.setEnabled(selection.size() > 0);
        this.removeAction.setEnabled(selection.size() > 0);
        this.updateAction.setEnabled(selection.size() > 0);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
        this.refresh();
        this.dependencyViewer.getTable().setEnabled(enabled);
    }

    public void refresh() {
        this.dependencyViewer.refresh();
        super.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.refresh();
    }

    @Override
    protected void selectionChanged(IStructuredSelection sel) {
        this.updateButtons();
        this.updateMenu();
    }

    private void makeActions() {
        this.editAction = new Action(Messages.DependencySection_EditActionTitle){

            public void run() {
                DependencySection.this.handleEdit();
            }
        };
        this.removeAction = new Action(Messages.DependencySection_RemoveActionTitle){

            public void run() {
                DependencySection.this.handleRemove();
            }
        };
        this.updateAction = new Action(Messages.DependencySection_UpdateActionTitle){

            public void run() {
                DependencySection.this.handleUpdate();
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.editAction);
        manager.add(this.removeAction);
        manager.add(this.updateAction);
    }

    private void handleEdit() {
        VersionedPackage dep = (VersionedPackage)((StructuredSelection)this.dependencyViewer.getSelection()).getFirstElement();
        DependencyDialog diag = new DependencyDialog(this.dependencyViewer.getTable().getShell(), dep.clone());
        if (diag.open() == 0) {
            dep.setVersion(diag.getDependency().getVersion());
        }
    }

    private void handleRemove() {
        StructuredSelection selection = (StructuredSelection)this.dependencyViewer.getSelection();
        Iterator it = selection.iterator();
        Object[] names = new String[selection.size()];
        ArrayList<VersionedPackage> deps = new ArrayList<VersionedPackage>();
        int i = 0;
        while (it.hasNext()) {
            VersionedPackage dep = (VersionedPackage)it.next();
            deps.add(dep);
            names[i] = dep.getName();
            ++i;
        }
        String title = selection.size() > 1 ? Messages.DependencySection_RemoveDialogTitlePlural : Messages.DependencySection_RemoveDialogTitle;
        MessageDialog diag = new MessageDialog(this.dependencyViewer.getTable().getShell(), title, null, NLS.bind((String)Messages.DependencySection_RemoveDialogMessage, (Object)StringUtils.join((Object[])names, (String)", ")), 4, new String[]{Messages.DependencySection_YesButton, Messages.DependencySection_NoButton}, 0);
        if (diag.open() == 0) {
            for (VersionedPackage dep : deps) {
                this.dependencies.remove(dep);
            }
        }
    }

    private void handleUpdate() {
        StructuredSelection selection = (StructuredSelection)this.dependencyViewer.getSelection();
        Iterator it = selection.iterator();
        String[] names = new String[selection.size()];
        ArrayList<VersionedPackage> deps = new ArrayList<VersionedPackage>();
        int i = 0;
        while (it.hasNext()) {
            VersionedPackage dep = (VersionedPackage)it.next();
            deps.add(dep);
            names[i] = dep.getName();
            ++i;
        }
        this.updateJob.setPackages(names);
        this.updateJob.schedule();
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleEdit();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleUpdate();
            }
        }
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
    }
}

