/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.command;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.command.DefaultJobCommandContext;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.core.utility.command.JobCommandContext;
import org.eclipse.jpt.common.core.utility.command.RepeatingJobCommand;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StackTrace;
import org.eclipse.jpt.common.utility.internal.command.RepeatingCommandState;

public class RepeatingJobCommandWrapper
implements RepeatingJobCommand {
    final JobCommand command;
    private final JobCommand startCommand;
    private final JobCommandContext startCommandContext;
    final ExceptionHandler exceptionHandler;
    final RepeatingCommandState state;
    private final ArrayList<StackTrace> stackTraces;

    private static boolean debug() {
        return JptCommonCorePlugin.instance().isDebugEnabled();
    }

    public RepeatingJobCommandWrapper(JobCommand command, ExceptionHandler exceptionHandler) {
        this(command, DefaultJobCommandContext.instance(), exceptionHandler);
    }

    public RepeatingJobCommandWrapper(JobCommand command, JobCommandContext startCommandContext, ExceptionHandler exceptionHandler) {
        ArrayList arrayList = this.stackTraces = RepeatingJobCommandWrapper.debug() ? new ArrayList() : null;
        if (command == null || startCommandContext == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.command = command;
        this.startCommandContext = startCommandContext;
        this.startCommand = this.buildStartJobCommand();
        this.exceptionHandler = exceptionHandler;
        this.state = this.buildState();
    }

    private JobCommand buildStartJobCommand() {
        return new StartJobCommand();
    }

    private RepeatingCommandState buildState() {
        return new RepeatingCommandState();
    }

    @Override
    public void start() {
        this.state.start();
    }

    @Override
    public synchronized IStatus execute(IProgressMonitor monitor) {
        if (this.state.isReadyToStartExecutionCycle()) {
            if (RepeatingJobCommandWrapper.debug()) {
                this.stackTraces.clear();
                this.stackTraces.add(new StackTrace());
            }
            this.executeStartCommand();
        } else if (RepeatingJobCommandWrapper.debug()) {
            this.stackTraces.add(new StackTrace());
        }
        return Status.OK_STATUS;
    }

    void executeStartCommand() {
        this.startCommandContext.execute(this.startCommand);
    }

    @Override
    public void stop() throws InterruptedException {
        this.state.stop();
    }

    IStatus execute_(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (this.state.wasStoppedBeforeFirstExecutionCouldStart()) {
            return status;
        }
        do {
            if (status.getSeverity() == 8) continue;
            status = this.executeCommand(monitor);
        } while (this.state.isRepeat());
        return status;
    }

    IStatus executeCommand(IProgressMonitor monitor) {
        try {
            return this.command.execute(monitor);
        }
        catch (OperationCanceledException ex) {
            this.exceptionHandler.handleException((Throwable)ex);
            return Status.CANCEL_STATUS;
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
            return Status.OK_STATUS;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.command);
    }

    class StartJobCommand
    implements JobCommand {
        StartJobCommand() {
        }

        @Override
        public IStatus execute(IProgressMonitor monitor) {
            return RepeatingJobCommandWrapper.this.execute_(monitor);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)RepeatingJobCommandWrapper.this.command);
        }
    }
}

