/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerEightByte;

public class SerializerDouble
extends SerializerEightByte<Double> {
    @Override
    protected Double unpack(long l) {
        return new Double(Double.longBitsToDouble(l));
    }

    @Override
    protected long pack(Double l) {
        return Double.doubleToLongBits(l);
    }

    @Override
    public int valueArraySearch(Object keys, Double key) {
        return Arrays.binarySearch(this.valueArrayToArray(keys), key);
    }

    @Override
    public void serialize(DataOutput2 out, Double value) throws IOException {
        out.writeDouble(value);
    }

    @Override
    public Double deserialize(DataInput2 in, int available) throws IOException {
        return new Double(in.readDouble());
    }
}

