/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class ConnectionsGroup
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionsGroup.class);
    private final SailConnection baseConnection;
    private final SailConnection previousStateConnection;
    private final SailConnection addedStatements;
    private final SailConnection removedStatements;
    private final ShaclSailConnection.Settings transactionSettings;
    private final Stats stats;
    private final RdfsSubClassOfReasonerProvider rdfsSubClassOfReasonerProvider;
    private final boolean sparqlValidation;
    private final Map<PlanNode, BufferedSplitter> nodeCache = new ConcurrentHashMap<PlanNode, BufferedSplitter>();
    private final Cache<Value, Value> INTERNED_VALUE_CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors() * 2).maximumSize(10000L).build();

    public ConnectionsGroup(SailConnection baseConnection, SailConnection previousStateConnection, Sail addedStatements, Sail removedStatements, Stats stats, RdfsSubClassOfReasonerProvider rdfsSubClassOfReasonerProvider, ShaclSailConnection.Settings transactionSettings, boolean sparqlValidation) {
        this.baseConnection = baseConnection;
        this.previousStateConnection = previousStateConnection;
        this.stats = stats;
        this.rdfsSubClassOfReasonerProvider = rdfsSubClassOfReasonerProvider;
        this.transactionSettings = transactionSettings;
        this.sparqlValidation = sparqlValidation;
        if (addedStatements != null) {
            this.addedStatements = addedStatements.getConnection();
            this.addedStatements.begin((IsolationLevel)IsolationLevels.NONE);
        } else {
            this.addedStatements = null;
        }
        if (removedStatements != null) {
            this.removedStatements = removedStatements.getConnection();
            this.removedStatements.begin((IsolationLevel)IsolationLevels.NONE);
        } else {
            this.removedStatements = null;
        }
    }

    public SailConnection getPreviousStateConnection() {
        return this.previousStateConnection;
    }

    public boolean hasPreviousStateConnection() {
        return this.previousStateConnection != null;
    }

    public SailConnection getAddedStatements() {
        return this.addedStatements;
    }

    public SailConnection getRemovedStatements() {
        return this.removedStatements;
    }

    public <T extends Value> T getSailSpecificValue(T value, StatementPosition statementPosition, SailConnection connection) {
        try {
            Value t = (Value)this.INTERNED_VALUE_CACHE.get(value, () -> {
                switch (statementPosition.ordinal()) {
                    case 0: {
                        try (Stream statements = connection.getStatements((Resource)value, null, null, false, new Resource[0]).stream();){
                            Resource ret = statements.map(Statement::getSubject).findAny().orElse(null);
                            if (ret == null) {
                                Value value2 = value;
                                return value2;
                            }
                            Resource resource = ret;
                            return resource;
                        }
                    }
                    case 1: {
                        try (Stream statements = connection.getStatements(null, (IRI)value, null, false, new Resource[0]).stream();){
                            IRI ret = statements.map(Statement::getPredicate).findAny().orElse(null);
                            if (ret == null) {
                                Value value3 = value;
                                return value3;
                            }
                            IRI iRI = ret;
                            return iRI;
                        }
                    }
                    case 2: {
                        try (Stream statements = connection.getStatements(null, null, value, false, new Resource[0]).stream();){
                            Value ret = statements.map(Statement::getObject).findAny().orElse(null);
                            if (ret == null) {
                                Value value4 = value;
                                return value4;
                            }
                            Value value5 = ret;
                            return value5;
                        }
                    }
                }
                throw new IllegalStateException("Unknown statement position: " + String.valueOf((Object)statementPosition));
            });
            return (T)t;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new SailException(e);
        }
    }

    @Override
    public void close() {
        if (this.addedStatements != null) {
            this.addedStatements.commit();
            this.addedStatements.close();
        }
        if (this.removedStatements != null) {
            this.removedStatements.commit();
            this.removedStatements.close();
        }
        this.nodeCache.clear();
    }

    public SailConnection getBaseConnection() {
        return this.baseConnection;
    }

    public PlanNode getCachedNodeFor(PlanNode planNode) {
        if (!this.transactionSettings.isCacheSelectNodes()) {
            return planNode;
        }
        if (planNode instanceof UnorderedSelect || planNode instanceof UnBufferedPlanNode || planNode instanceof BufferedSplitter.BufferedSplitterPlaneNode && ((BufferedSplitter.BufferedSplitterPlaneNode)planNode).cached) {
            return planNode;
        }
        if (logger.isDebugEnabled()) {
            boolean[] matchedCache = new boolean[]{true};
            BufferedSplitter bufferedSplitter = this.nodeCache.computeIfAbsent(planNode, parent -> {
                matchedCache[0] = false;
                return BufferedSplitter.getInstance(parent);
            });
            logger.debug("Found in cache: {} {}  -  {} : {}", new Object[]{matchedCache[0] ? " TRUE" : "FALSE", bufferedSplitter.getId(), planNode.getClass().getSimpleName(), planNode.getId()});
            return bufferedSplitter.getPlanNode();
        }
        return this.nodeCache.computeIfAbsent(planNode, BufferedSplitter::getInstance).getPlanNode();
    }

    public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner() {
        if (this.rdfsSubClassOfReasonerProvider == null) {
            return null;
        }
        return this.rdfsSubClassOfReasonerProvider.getRdfsSubClassOfReasoner();
    }

    public Stats getStats() {
        return this.stats;
    }

    public ShaclSailConnection.Settings getTransactionSettings() {
        return this.transactionSettings;
    }

    public boolean isSparqlValidation() {
        return this.sparqlValidation;
    }

    public boolean hasAddedStatements() {
        return this.addedStatements != null;
    }

    public static interface RdfsSubClassOfReasonerProvider {
        public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner();
    }

    public static enum StatementPosition {
        subject,
        predicate,
        object;

    }
}

